/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache;", "", "()V", "KOTLIN_BINARY_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "kotlin.jvm.PlatformType", "KOTLIN_IS_COMPILED_FILE_ATTRIBUTE", "", "attributeService", "Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "createHeaderInfo", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryHeaderData;", "kotlinBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getKotlinBinaryClass", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "getKotlinBinaryClassHeaderData", "getKotlinBinaryFromCache", "KotlinBinaryData", "KotlinBinaryHeaderData", "idea-analysis"})
public final class IDEKotlinBinaryClassCache {
    private static final FileAttributeService attributeService;
    private static final String KOTLIN_IS_COMPILED_FILE_ATTRIBUTE;
    private static final Key<KotlinBinaryData> KOTLIN_BINARY_DATA_KEY;
    public static final IDEKotlinBinaryClassCache INSTANCE;

    @Nullable
    public final KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file);
        if (cached != null && !cached.isKotlinBinary()) {
            return null;
        }
        KotlinJvmBinaryClass kotlinBinaryClass = KotlinBinaryClassCache.Companion.getKotlinBinaryClass(file, fileContent);
        boolean isKotlinBinaryClass = kotlinBinaryClass != null;
        attributeService.writeBooleanAttribute(KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file, isKotlinBinaryClass);
        if (isKotlinBinaryClass) {
            KotlinBinaryHeaderData headerInfo = this.createHeaderInfo(kotlinBinaryClass);
            file.putUserData(KOTLIN_BINARY_DATA_KEY, (Object)new KotlinBinaryData(isKotlinBinaryClass, file.getTimeStamp(), headerInfo));
        }
        return kotlinBinaryClass;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ KotlinJvmBinaryClass getKotlinBinaryClass$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getKotlinBinaryClass");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClass(virtualFile2, byArray);
    }

    @Nullable
    public final KotlinBinaryHeaderData getKotlinBinaryClassHeaderData(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file);
        if (cached != null) {
            if (!cached.isKotlinBinary()) {
                return null;
            }
            if (cached.getHeaderData() != null) {
                return cached.getHeaderData();
            }
        }
        KotlinJvmBinaryClass kotlinBinaryClass = this.getKotlinBinaryClass(file, fileContent);
        return this.createHeaderInfo(kotlinBinaryClass);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ KotlinBinaryHeaderData getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getKotlinBinaryClassHeaderData");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(virtualFile2, byArray);
    }

    private final KotlinBinaryHeaderData createHeaderInfo(KotlinJvmBinaryClass kotlinBinaryClass) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinBinaryClass;
        KotlinClassHeader header = kotlinJvmBinaryClass != null ? kotlinJvmBinaryClass.getClassHeader() : null;
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinBinaryClass;
        ClassId classId = kotlinJvmBinaryClass2 != null ? kotlinJvmBinaryClass2.getClassId() : null;
        return header != null && classId != null ? new KotlinBinaryHeaderData(header, classId) : (KotlinBinaryHeaderData)null;
    }

    private final KotlinBinaryData getKotlinBinaryFromCache(VirtualFile file) {
        KotlinBinaryData userData = (KotlinBinaryData)file.getUserData(KOTLIN_BINARY_DATA_KEY);
        if (userData != null && userData.getTimestamp() == file.getTimeStamp()) {
            return userData;
        }
        CachedAttributeData<Boolean> isKotlinBinaryAttribute = attributeService.readBooleanAttribute(KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file);
        if (isKotlinBinaryAttribute != null) {
            boolean isKotlinBinary = isKotlinBinaryAttribute.getValue();
            KotlinBinaryData kotlinBinaryData = new KotlinBinaryData(isKotlinBinary, file.getTimeStamp(), null);
            if (isKotlinBinary) {
                file.putUserData(KOTLIN_BINARY_DATA_KEY, (Object)kotlinBinaryData);
            }
            return kotlinBinaryData;
        }
        return null;
    }

    private IDEKotlinBinaryClassCache() {
        INSTANCE = this;
        attributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
        String string = "kotlin-is-binary-compiled";
        String $receiver = string;
        ((FileAttributeService)ServiceManager.getService(FileAttributeService.class)).register($receiver, 1);
        KOTLIN_IS_COMPILED_FILE_ATTRIBUTE = string;
        KOTLIN_BINARY_DATA_KEY = Key.create((String)KOTLIN_IS_COMPILED_FILE_ATTRIBUTE);
    }

    static {
        new IDEKotlinBinaryClassCache();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryHeaderData;", "", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassHeader", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "component1", "component2", "copy", "idea-analysis"})
    public static final class KotlinBinaryHeaderData {
        @NotNull
        private final KotlinClassHeader classHeader;
        @NotNull
        private final ClassId classId;

        @NotNull
        public final KotlinClassHeader getClassHeader() {
            return this.classHeader;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        public KotlinBinaryHeaderData(@NotNull KotlinClassHeader classHeader, @NotNull ClassId classId) {
            Intrinsics.checkParameterIsNotNull((Object)classHeader, (String)"classHeader");
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            this.classHeader = classHeader;
            this.classId = classId;
        }

        @NotNull
        public final KotlinClassHeader component1() {
            return this.classHeader;
        }

        @NotNull
        public final ClassId component2() {
            return this.classId;
        }

        @NotNull
        public final KotlinBinaryHeaderData copy(@NotNull KotlinClassHeader classHeader, @NotNull ClassId classId) {
            Intrinsics.checkParameterIsNotNull((Object)classHeader, (String)"classHeader");
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            return new KotlinBinaryHeaderData(classHeader, classId);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ KotlinBinaryHeaderData copy$default(KotlinBinaryHeaderData kotlinBinaryHeaderData, KotlinClassHeader kotlinClassHeader, ClassId classId, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                kotlinClassHeader = kotlinBinaryHeaderData.classHeader;
            }
            if ((n & 2) != 0) {
                classId = kotlinBinaryHeaderData.classId;
            }
            return kotlinBinaryHeaderData.copy(kotlinClassHeader, classId);
        }

        public String toString() {
            return "KotlinBinaryHeaderData(classHeader=" + this.classHeader + ", classId=" + this.classId + ")";
        }

        public int hashCode() {
            KotlinClassHeader kotlinClassHeader = this.classHeader;
            ClassId classId = this.classId;
            return (kotlinClassHeader != null ? kotlinClassHeader.hashCode() : 0) * 31 + (classId != null ? ((Object)classId).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinBinaryHeaderData)) break block3;
                    KotlinBinaryHeaderData kotlinBinaryHeaderData = (KotlinBinaryHeaderData)object;
                    if (!Intrinsics.areEqual((Object)this.classHeader, (Object)kotlinBinaryHeaderData.classHeader) || !Intrinsics.areEqual((Object)this.classId, (Object)kotlinBinaryHeaderData.classId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "", "isKotlinBinary", "", "timestamp", "", "headerData", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryHeaderData;", "(ZJLorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryHeaderData;)V", "getHeaderData", "()Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryHeaderData;", "()Z", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "idea-analysis"})
    public static final class KotlinBinaryData {
        private final boolean isKotlinBinary;
        private final long timestamp;
        @Nullable
        private final KotlinBinaryHeaderData headerData;

        public final boolean isKotlinBinary() {
            return this.isKotlinBinary;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryHeaderData getHeaderData() {
            return this.headerData;
        }

        public KotlinBinaryData(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryHeaderData headerData) {
            this.isKotlinBinary = isKotlinBinary;
            this.timestamp = timestamp;
            this.headerData = headerData;
        }

        public final boolean component1() {
            return this.isKotlinBinary;
        }

        public final long component2() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryHeaderData component3() {
            return this.headerData;
        }

        @NotNull
        public final KotlinBinaryData copy(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryHeaderData headerData) {
            return new KotlinBinaryData(isKotlinBinary, timestamp, headerData);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ KotlinBinaryData copy$default(KotlinBinaryData kotlinBinaryData, boolean bl, long l, KotlinBinaryHeaderData kotlinBinaryHeaderData, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                bl = kotlinBinaryData.isKotlinBinary;
            }
            if ((n & 2) != 0) {
                l = kotlinBinaryData.timestamp;
            }
            if ((n & 4) != 0) {
                kotlinBinaryHeaderData = kotlinBinaryData.headerData;
            }
            return kotlinBinaryData.copy(bl, l, kotlinBinaryHeaderData);
        }

        public String toString() {
            return "KotlinBinaryData(isKotlinBinary=" + this.isKotlinBinary + ", timestamp=" + this.timestamp + ", headerData=" + this.headerData + ")";
        }

        public int hashCode() {
            int n = this.isKotlinBinary ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            long l = this.timestamp;
            KotlinBinaryHeaderData kotlinBinaryHeaderData = this.headerData;
            return (n * 31 + (int)(l ^ l >>> 32)) * 31 + (kotlinBinaryHeaderData != null ? ((Object)kotlinBinaryHeaderData).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinBinaryData)) break block3;
                    KotlinBinaryData kotlinBinaryData = (KotlinBinaryData)object;
                    if (!(this.isKotlinBinary == kotlinBinaryData.isKotlinBinary) || !(this.timestamp == kotlinBinaryData.timestamp) || !Intrinsics.areEqual((Object)this.headerData, (Object)kotlinBinaryData.headerData)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

