/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper;
import org.jetbrains.kotlin.idea.project.ResolveElementCache;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 Q2\u00020\u0001:\u0001QB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0019H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\u001e\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0017H\u0016J\u0016\u0010:\u001a\u0002082\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130%H\u0016J\u0010\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020\u0017H\u0002J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\u0006\u0010*\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020@0%2\u0006\u0010*\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00109\u001a\u00020\u0017H\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010\u00192\u0006\u0010,\u001a\u00020\u0017H\u0002J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\u0006\u0010E\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u001e\u0010F\u001a\b\u0012\u0004\u0012\u00020 0%2\u0006\u0010G\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u0018\u0010H\u001a\u00020I2\u0006\u0010&\u001a\u00020 2\u0006\u0010/\u001a\u00020(H\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020MH\u0016J&\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010O\u001a\u0004\u0018\u00010P2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport;", "Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "scopeFileComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createClsJavaClassFromVirtualFile", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "mirrorFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "correspondingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createLightClassForDecompiledKotlinFile", "Lorg/jetbrains/kotlin/idea/caches/resolve/KtLightClassForDecompiledDeclaration;", "file", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/KtClsFile;", "createLightClassForFileFacade", "", "Lcom/intellij/psi/PsiClass;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeFiles", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "findClassOrObjectDeclarations", "", "fqName", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClassOrObjectDeclarationsInPackage", "packageFqName", "findCorrespondingLightClass", "decompiledClassOrObject", "rootLightClassForDecompiledFile", "findFilesForFacade", "scope", "findFilesForPackage", "forceResolvePackageDeclarations", "", "files", "session", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "getClassRelativeName", "getContextForClassOrObject", "Lorg/jetbrains/kotlin/asJava/LightClassConstructionContext;", "classOrObject", "getContextForFacade", "getContextForLocalClassOrObject", "getContextForNonLocalClassOrObject", "getFacadeClasses", "getFacadeClassesInPackage", "getFacadeNames", "", "getLightClass", "Lorg/jetbrains/kotlin/asJava/KtLightClass;", "getLightClassForDecompiledClassOrObject", "getMultifilePartClasses", "partFqName", "getSubPackages", "fqn", "packageExists", "", "resolveToDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "withFakeLightClasses", "lightClassForFacade", "Lorg/jetbrains/kotlin/asJava/KtLightClassForFacade;", "Companion", "idea-analysis"})
public final class IDELightClassGenerationSupport
extends LightClassGenerationSupport {
    private final Comparator<PsiElement> scopeFileComparator;
    private final PsiManager psiManager;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public LightClassConstructionContext getContextForClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        if (classOrObject.isLocal()) {
            return this.getContextForLocalClassOrObject(classOrObject);
        }
        return this.getContextForNonLocalClassOrObject(classOrObject);
    }

    /*
     * WARNING - void declaration
     */
    private final LightClassConstructionContext getContextForNonLocalClassOrObject(KtClassOrObject classOrObject) {
        void $receiver$iv;
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade(classOrObject);
        BindingContext bindingContext2 = classOrObject instanceof KtClass && classOrObject.isAnnotation() ? resolutionFacade2.getFrontendService(ResolveElementCache.class).resolvePrimaryConstructorParametersDefaultValues((KtClass)classOrObject) : ResolutionFacade.DefaultImpls.analyze$default(resolutionFacade2, classOrObject, null, 2, null);
        Object v = bindingContext2.get(BindingContext.CLASS, classOrObject);
        void v0 = $receiver$iv;
        if (v0 == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "Class descriptor was not found for " + PsiUtilsKt.getElementTextWithContext(classOrObject);
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)v0;
        ForceResolveUtil.forceResolveAllContents(classDescriptor);
        return new LightClassConstructionContext(bindingContext2, resolutionFacade2.getModuleDescriptor());
    }

    private final LightClassConstructionContext getContextForLocalClassOrObject(KtClassOrObject classOrObject) {
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade(classOrObject);
        BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(resolutionFacade2, classOrObject, null, 2, null);
        ClassDescriptor descriptor2 = (ClassDescriptor)bindingContext2.get(BindingContext.CLASS, classOrObject);
        if (descriptor2 == null) {
            IDELightClassGenerationSupport.Companion.getLOG().warn("No class descriptor in context for class: " + PsiUtilsKt.getElementTextWithContext(classOrObject));
            return new LightClassConstructionContext(bindingContext2, resolutionFacade2.getModuleDescriptor());
        }
        ForceResolveUtil.forceResolveAllContents(descriptor2);
        return new LightClassConstructionContext(bindingContext2, resolutionFacade2.getModuleDescriptor());
    }

    @NotNull
    public LightClassConstructionContext getContextForFacade(@NotNull Collection<? extends KtFile> files) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        boolean bl = !files.isEmpty();
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "No files in facade";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Iterable iterable = files;
        Comparator<PsiElement> comparator = this.scopeFileComparator;
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"scopeFileComparator");
        List sortedFiles = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        KtFile file = (KtFile)CollectionsKt.first((List)sortedFiles);
        ResolveSession resolveSession = ResolutionUtils.getResolutionFacade(file).getFrontendService(ResolveSession.class);
        this.forceResolvePackageDeclarations(files, resolveSession);
        return new LightClassConstructionContext(resolveSession.getBindingContext(), resolveSession.getModuleDescriptor());
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Collection<KtClassOrObject> collection = KotlinFullClassNameIndex.getInstance().get(fqName2.asString(), this.project, KotlinSourceFilterScope.sourceAndClassFiles(searchScope2, this.project));
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFullClassNameIndex\u2026es(searchScope, project))");
        return collection;
    }

    @Override
    @NotNull
    public Collection<KtFile> findFilesForPackage(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.sourceAndClassFiles(searchScope2, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"sourceAndClassFiles(searchScope, project)");
        return PackageIndexUtil.findFilesWithExactPackage(fqName2, globalSearchScope, this.project);
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Collection<KtClassOrObject> collection = KotlinTopLevelClassByPackageIndex.getInstance().get(packageFqName.asString(), this.project, KotlinSourceFilterScope.sourceAndClassFiles(searchScope2, this.project));
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinTopLevelClassByPac\u2026es(searchScope, project))");
        return collection;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.sourceAndClassFiles(scope2, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"sourceAndClassFiles(scope, project)");
        return PackageIndexUtil.packageExists(fqName2, globalSearchScope, this.project);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqn, (String)"fqn");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.sourceAndClassFiles(scope2, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"sourceAndClassFiles(scope, project)");
        return PackageIndexUtil.getSubPackageFqNames(fqn, globalSearchScope, this.project, MemberScope.Companion.getALL_NAME_FILTER());
    }

    @Override
    @Nullable
    public KtLightClass getLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        VirtualFile virtualFile2 = classOrObject.getContainingFile().getVirtualFile();
        if (virtualFile2 != null) {
            if (ProjectRootsUtil.isProjectSourceFile(this.project, virtualFile2)) {
                return KtLightClassForExplicitDeclaration.Companion.create(classOrObject);
            }
            if (ProjectRootsUtil.isLibraryClassFile(this.project, virtualFile2)) {
                return this.getLightClassForDecompiledClassOrObject(classOrObject);
            }
            if (ProjectRootsUtil.isLibrarySourceFile(this.project, virtualFile2)) {
                PsiClass psiClass = SourceNavigationHelper.getOriginalClass(classOrObject);
                if (!(psiClass instanceof KtLightClass)) {
                    psiClass = null;
                }
                return (KtLightClass)psiClass;
            }
        }
        if (KtPsiFactoryKt.getAnalysisContext(classOrObject.getContainingKtFile()) != null) {
            return KtLightClassForExplicitDeclaration.Companion.create(classOrObject);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiClass> withFakeLightClasses(KtLightClassForFacade lightClassForFacade, List<? extends KtFile> facadeFiles) {
        if (lightClassForFacade == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<KtLightClassForFacade> lightClasses = new ArrayList<KtLightClassForFacade>();
        lightClasses.add(lightClassForFacade);
        if (facadeFiles.size() > 1) {
            List list2;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = facadeFiles;
            ArrayList<KtLightClassForFacade> arrayList = lightClasses;
            void var5_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                list2 = destination$iv$iv;
                FakeLightClassForFileOfPackage fakeLightClassForFileOfPackage = new FakeLightClassForFileOfPackage(lightClassForFacade, (KtFile)it);
                list2.add(fakeLightClassForFileOfPackage);
            }
            list2 = (List)destination$iv$iv;
            arrayList.addAll(list2);
        }
        return lightClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClasses(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope2) {
        void filesByModule;
        Collection destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Iterable iterable = this.findFilesForFacade(facadeFqName, scope2);
        void var5_4 = $receiver$iv;
        Map map2 = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            void $receiver$iv$iv$iv;
            KtFile it = (KtFile)element$iv$iv;
            IdeaModuleInfo key$iv$iv = GetModuleInfoKt.getModuleInfo((PsiElement)it);
            void var12_10 = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = filesByModule = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            Iterable list$iv$iv = this.createLightClassForFileFacade(facadeFqName, (List)it.getValue(), (IdeaModuleInfo)it.getKey());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiClass> getMultifilePartClasses(@NotNull FqName partFqName, @NotNull GlobalSearchScope scope2) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)partFqName, (String)"partFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (partFqName.isRoot()) {
            return CollectionsKt.emptyList();
        }
        Collection<KtFile> facadeKtFiles = StaticFacadeIndexUtil.getMultifileClassForPart(partFqName, scope2, this.project);
        String partShortName = partFqName.shortName().asString();
        String partClassFileShortName = partShortName + ".class";
        Iterable iterable = facadeKtFiles;
        void var7_7 = $receiver$iv;
        Collection collection = new ArrayList();
        void var9_9 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration;
            Object element$iv$iv = element$iv$iv$iv;
            KtFile facadeKtFile = (KtFile)element$iv$iv;
            if (facadeKtFile instanceof KtClsFile) {
                if (((KtClsFile)facadeKtFile).getVirtualFile().getParent().findChild(partClassFileShortName) == null) {
                    ktLightClassForDecompiledDeclaration = null;
                } else {
                    ClsClassImpl javaClsClass;
                    VirtualFile partClassFile;
                    VirtualFile virtualFile2 = partClassFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"partClassFile");
                    ktLightClassForDecompiledDeclaration = this.createClsJavaClassFromVirtualFile(facadeKtFile, virtualFile2, null) == null ? (KtLightClassForDecompiledDeclaration)null : new KtLightClassForDecompiledDeclaration(javaClsClass, null, (KtClsFile)facadeKtFile);
                }
            } else {
                ktLightClassForDecompiledDeclaration = null;
            }
            if (ktLightClassForDecompiledDeclaration != null) {
                KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration2 = ktLightClassForDecompiledDeclaration;
                KtLightClassForDecompiledDeclaration it$iv$iv = ktLightClassForDecompiledDeclaration2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiClass> createLightClassForFileFacade(@NotNull FqName facadeFqName, @NotNull List<? extends KtFile> facadeFiles, @NotNull IdeaModuleInfo moduleInfo) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull(facadeFiles, (String)"facadeFiles");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        if (moduleInfo instanceof ModuleSourceInfo) {
            KtLightClassForFacade lightClassForFacade = KtLightClassForFacade.Factory.createForFacade(this.psiManager, facadeFqName, moduleInfo.contentScope(), (Collection<? extends KtFile>)facadeFiles);
            return this.withFakeLightClasses(lightClassForFacade, facadeFiles);
        }
        Iterable lightClassForFacade = facadeFiles;
        void var5_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtClsFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable iterable = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            Object element$iv$iv = element$iv$iv$iv;
            KtClsFile it = (KtClsFile)element$iv$iv;
            if (this.createLightClassForDecompiledKotlinFile(it) != null) {
                KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration;
                KtLightClassForDecompiledDeclaration it$iv$iv = ktLightClassForDecompiledDeclaration;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacade(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        String string = facadeFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeFqName.asString()");
        Collection<KtFile> collection = KotlinFileFacadeFqNameIndex.INSTANCE.get(string, this.project, scope2);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFileFacadeFqNameIn\u2026String(), project, scope)");
        return collection;
    }

    @Override
    @Nullable
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        try {
            return ResolutionUtils.resolveToDescriptor(declaration);
        }
        catch (NoDescriptorForDeclarationException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public BindingContext analyze(@NotNull KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getFacadeNames(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        KotlinFileFacadeClassByPackageIndex kotlinFileFacadeClassByPackageIndex = KotlinFileFacadeClassByPackageIndex.Companion.getInstance();
        String string = packageFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName.asString()");
        Collection<KtFile> facadeFilesInPackage = kotlinFileFacadeClassByPackageIndex.get(string, this.project, scope2);
        Iterable iterable = facadeFilesInPackage;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            void var13_10 = destination$iv$iv;
            String string2 = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)it).shortName().asString();
            var13_10.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClassesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        void groupedByFqNameAndModuleInfo;
        List answer$iv$iv$iv;
        Object value$iv$iv$iv;
        Object $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Object key$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        KotlinFileFacadeClassByPackageIndex kotlinFileFacadeClassByPackageIndex = KotlinFileFacadeClassByPackageIndex.Companion.getInstance();
        String string = packageFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName.asString()");
        Collection<KtFile> facadeFilesInPackage = kotlinFileFacadeClassByPackageIndex.get(string, this.project, scope2);
        Iterable iterable = facadeFilesInPackage;
        void var6_5 = $receiver$iv;
        Map map2 = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            KtFile it = (KtFile)element$iv$iv;
            key$iv$iv = new Pair((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName(it), (Object)GetModuleInfoKt.getModuleInfo((PsiElement)it));
            Collection collection = destination$iv$iv;
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = groupedByFqNameAndModuleInfo = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            void moduleInfo;
            void files;
            void fqName2;
            void key;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            $receiver$iv$iv$iv = key$iv$iv = it;
            value$iv$iv$iv = (Pair)$receiver$iv$iv$iv.getKey();
            $receiver$iv$iv$iv = key$iv$iv;
            answer$iv$iv$iv = (List)$receiver$iv$iv$iv.getValue();
            key$iv$iv = null;
            Object var16_14 = key;
            key$iv$iv = (FqName)var16_14.component1();
            $receiver$iv$iv$iv = (IdeaModuleInfo)var16_14.component2();
            var16_14 = null;
            Iterable list$iv$iv = this.createLightClassForFileFacade((FqName)fqName2, (List<? extends KtFile>)files, (IdeaModuleInfo)moduleInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void forceResolvePackageDeclarations(Collection<? extends KtFile> files, ResolveSession session) {
        for (KtFile ktFile : files) {
            if (ktFile.isScript()) continue;
            FqName packageFqName = ktFile.getPackageFqName();
            ModuleDescriptor moduleDescriptor = session.getModuleDescriptor();
            FqName fqName2 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
            PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
            if (packageDescriptor.isEmpty()) {
                IDELightClassGenerationSupport.Companion.getLOG().warn("No descriptor found for package " + packageFqName + " in file " + ktFile.getName() + "\n" + ktFile.getText());
                session.forceResolveAll();
                continue;
            }
            for (KtDeclaration declaration : ktFile.getDeclarations()) {
                if (declaration instanceof KtFunction) {
                    Name name2 = ((KtFunction)declaration).getNameAsSafeName();
                    MemberScope memberScope2 = packageDescriptor.getMemberScope();
                    Name name3 = name2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                    Collection<SimpleFunctionDescriptor> functions2 = memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_IDE);
                    for (SimpleFunctionDescriptor simpleFunctionDescriptor : functions2) {
                        ForceResolveUtil.forceResolveAllContents(simpleFunctionDescriptor);
                    }
                    continue;
                }
                if (declaration instanceof KtProperty) {
                    Name name4 = ((KtProperty)declaration).getNameAsSafeName();
                    MemberScope memberScope3 = packageDescriptor.getMemberScope();
                    Name name5 = name4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)name5, (String)"name");
                    Collection<PropertyDescriptor> properties2 = memberScope3.getContributedVariables(name5, NoLookupLocation.FROM_IDE);
                    for (PropertyDescriptor propertyDescriptor : properties2) {
                        ForceResolveUtil.forceResolveAllContents(propertyDescriptor);
                    }
                    continue;
                }
                if (declaration instanceof KtClassOrObject) continue;
                IDELightClassGenerationSupport.Companion.getLOG().error("Unsupported declaration kind: " + declaration + " in file " + ktFile.getName() + "\n" + ktFile.getText());
            }
            ForceResolveUtil.forceResolveAllContents(session.getFileAnnotations(ktFile));
        }
    }

    private final KtLightClassForDecompiledDeclaration getLightClassForDecompiledClassOrObject(KtClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject instanceof KtEnumEntry) {
            return null;
        }
        KtFile containingJetFile = decompiledClassOrObject.getContainingKtFile();
        if (!(containingJetFile instanceof KtClsFile)) {
            return null;
        }
        KtClsFile ktClsFile = (KtClsFile)containingJetFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktClsFile, (String)"containingJetFile");
        KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration = this.createLightClassForDecompiledKotlinFile(ktClsFile);
        if (ktLightClassForDecompiledDeclaration == null) {
            return null;
        }
        KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = ktLightClassForDecompiledDeclaration;
        return this.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightClassForDecompiledDeclaration findCorrespondingLightClass(KtClassOrObject decompiledClassOrObject, KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile) {
        Unit unit;
        FqName relativeFqName = this.getClassRelativeName(decompiledClassOrObject);
        Iterator<Name> iterator2 = relativeFqName.pathSegments().iterator();
        Name base = iterator2.next();
        boolean bl = Intrinsics.areEqual((Object)rootLightClassForDecompiledFile.getName(), (Object)base.asString());
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Light class for file:\n" + decompiledClassOrObject.getContainingKtFile().getVirtualFile().getCanonicalPath() + "\nwas expected to have name: " + base.asString() + "\n Actual: " + rootLightClassForDecompiledFile.getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KtLightClassForDecompiledDeclaration current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            PsiClass innerClass;
            void $receiver$iv;
            Name name2 = iterator2.next();
            PsiClass psiClass = current.findInnerClassByName(name2.asString(), false);
            void v1 = $receiver$iv;
            if (v1 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Could not find corresponding inner/nested class " + relativeFqName + " in class " + decompiledClassOrObject.getFqName() + "\n" + "File: " + decompiledClassOrObject.getContainingKtFile().getVirtualFile().getName();
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            PsiClass psiClass2 = innerClass = (PsiClass)v1;
            if (psiClass2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.caches.resolve.KtLightClassForDecompiledDeclaration");
            }
            current = (KtLightClassForDecompiledDeclaration)psiClass2;
        }
        return current;
    }

    private final FqName getClassRelativeName(KtClassOrObject decompiledClassOrObject) {
        Name name2 = decompiledClassOrObject.getNameAsName();
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Name name3 = name2;
        KtClassOrObject parent2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, KtClassOrObject.class, (boolean)true);
        if (parent2 == null) {
            Unit unit;
            boolean bl = decompiledClassOrObject.isTopLevel();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            FqName fqName2 = FqName.topLevel(name3);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.topLevel(name)");
            return fqName2;
        }
        FqName fqName3 = this.getClassRelativeName(parent2).child(name3);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"getClassRelativeName(parent).child(name)");
        return fqName3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(@NotNull KtClsFile file) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile2 = file.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Iterable iterable = file.getDeclarations();
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtClassOrObject classOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        ClsClassImpl clsClassImpl = this.createClsJavaClassFromVirtualFile(file, virtualFile3, classOrObject);
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl javaClsClass = clsClassImpl;
        return new KtLightClassForDecompiledDeclaration(javaClsClass, classOrObject, file);
    }

    private final ClsClassImpl createClsJavaClassFromVirtualFile(KtFile mirrorFile, VirtualFile classFile, KtClassOrObject correspondingClassOrObject) {
        PsiJavaFileStubImpl psiJavaFileStubImpl = ClsJavaStubByVirtualFileCache.Companion.getInstance(this.project).get(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl javaFileStub = psiJavaFileStubImpl;
        javaFileStub.setPsiFactory((StubPsiFactory)new ClsWrapperStubPsiFactory());
        PsiManager manager = PsiManager.getInstance((Project)mirrorFile.getProject());
        ClsFileImpl fakeFile2 = new ClsFileImpl(correspondingClassOrObject, javaFileStub, mirrorFile, (FileViewProvider)new ClassFileViewProvider(manager, classFile)){
            final /* synthetic */ KtClassOrObject $correspondingClassOrObject;
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ KtFile $mirrorFile;

            @NotNull
            public PsiElement getNavigationElement() {
                if (this.$correspondingClassOrObject != null) {
                    PsiElement psiElement = (PsiElement)this.$correspondingClassOrObject.getNavigationElement().getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"correspondingClassOrObje\u2026ionElement.containingFile");
                    return psiElement;
                }
                PsiElement psiElement = super.getNavigationElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"super.getNavigationElement()");
                return psiElement;
            }

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public KtFile getMirror() {
                return this.$mirrorFile;
            }

            public boolean isPhysical() {
                return false;
            }
            {
                this.$correspondingClassOrObject = $captured_local_variable$0;
                this.$javaFileStub = $captured_local_variable$1;
                this.$mirrorFile = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        Object object = ArraysKt.single((Object[])fakeFile2.getClasses());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        return (ClsClassImpl)object;
    }

    public IDELightClassGenerationSupport(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scopeFileComparator = JavaElementFinder.byClasspathComparator(GlobalSearchScope.allScope((Project)this.project));
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        this.psiManager = psiManager;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(IDELightClassGenerationSupport.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

