/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.completion.AllClassesCompletion;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.LookupElementsCollector;
import org.jetbrains.kotlin.idea.completion.ParameterNameAndTypeCompletion;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.quickfix.GenerateUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 /2\u00020\u0001:\u0007./01234B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eJ*\u0010!\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eJ(\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020 H\u0002J \u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010&\u001a\u00020 H\u0002J \u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010&\u001a\u00020 H\u0002J \u0010,\u001a\u00020 *\u00020-2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion;", "", "collector", "Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "(Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;)V", "classNamePrefixMatchers", "", "suggestionsByTypesAdded", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "userPrefixes", "", "addFromAllClasses", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "addFromImportedClasses", "position", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "addFromParametersInFile", "addSuggestions", "className", "userPrefix", "type", "notImported", "addSuggestionsForClassifier", "classifier", "addSuggestionsForJavaClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "isVisible", "Lorg/jetbrains/kotlin/types/KotlinType;", "ArbitraryType", "Companion", "DescriptorType", "JavaClassType", "MyLookupElement", "Type", "Weigher", "idea-completion"})
public final class ParameterNameAndTypeCompletion {
    private final List<String> userPrefixes;
    private final List<PrefixMatcher> classNamePrefixMatchers;
    private final HashSet<Type> suggestionsByTypesAdded;
    private final LookupElementsCollector collector;
    private final BasicLookupElementFactory lookupElementFactory;
    private final PrefixMatcher prefixMatcher;
    private final ResolutionFacade resolutionFacade;
    private static final Key<Integer> PRIORITY_KEY;
    private static final OffsetKey REPLACEMENT_OFFSET;
    public static final Companion Companion;

    public final void addFromImportedClasses(@NotNull PsiElement position, @NotNull BindingContext bindingContext2, @NotNull Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull(visibilityFilter, (String)"visibilityFilter");
        for (Pair pair2 : CollectionsKt.zip((Iterable)this.classNamePrefixMatchers, (Iterable)this.userPrefixes)) {
            PrefixMatcher classNameMatcher = (PrefixMatcher)pair2.component1();
            String userPrefix = (String)pair2.component2();
            LexicalScope resolutionScope = ScopeUtils.getResolutionScope(position, bindingContext2, this.resolutionFacade);
            Collection<DeclarationDescriptor> classifiers = ScopeUtilsKt.collectDescriptorsFiltered(resolutionScope, DescriptorKindFilter.NON_SINGLETON_CLASSIFIERS, CompletionUtilsKt.asNameFilter(classNameMatcher));
            for (DeclarationDescriptor classifier2 : classifiers) {
                if (!((Boolean)visibilityFilter.invoke((Object)classifier2)).booleanValue()) continue;
                this.addSuggestionsForClassifier(classifier2, userPrefix, false);
            }
            this.collector.flushToResultSet();
        }
    }

    public final void addFromAllClasses(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper indicesHelper2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)indicesHelper2, (String)"indicesHelper");
        for (Pair pair2 : CollectionsKt.zip((Iterable)this.classNamePrefixMatchers, (Iterable)this.userPrefixes)) {
            PrefixMatcher classNameMatcher = (PrefixMatcher)pair2.component1();
            String userPrefix = (String)pair2.component2();
            new AllClassesCompletion(parameters2, indicesHelper2, classNameMatcher, this.resolutionFacade, (Function1<? super ClassKind, Boolean>)((Function1)addFromAllClasses.1.INSTANCE)).collect((Function1<? super ClassDescriptor, Unit>)((Function1)new Function1<ClassDescriptor, Unit>(this, userPrefix){
                final /* synthetic */ ParameterNameAndTypeCompletion this$0;
                final /* synthetic */ String $userPrefix;

                public final void invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ParameterNameAndTypeCompletion.access$addSuggestionsForClassifier(this.this$0, it, this.$userPrefix, true);
                }
                {
                    this.this$0 = parameterNameAndTypeCompletion;
                    this.$userPrefix = string;
                    super(1);
                }
            }), (Function1<? super PsiClass, Unit>)((Function1)new Function1<PsiClass, Unit>(this, userPrefix){
                final /* synthetic */ ParameterNameAndTypeCompletion this$0;
                final /* synthetic */ String $userPrefix;

                public final void invoke(@NotNull PsiClass it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ParameterNameAndTypeCompletion.access$addSuggestionsForJavaClass(this.this$0, it, this.$userPrefix, true);
                }
                {
                    this.this$0 = parameterNameAndTypeCompletion;
                    this.$userPrefix = string;
                    super(1);
                }
            }));
            this.collector.flushToResultSet();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addFromParametersInFile(@NotNull PsiElement position, @NotNull ResolutionFacade resolutionFacade2, @NotNull Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        void action$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull(visibilityFilter, (String)"visibilityFilter");
        LinkedHashMap lookupElementToCount = new LinkedHashMap();
        Object object = (PsiElement)position.getContainingFile();
        Object object2 = (Function1)new Function1<KtParameter, Unit>(this, resolutionFacade2, visibilityFilter, lookupElementToCount){
            final /* synthetic */ ParameterNameAndTypeCompletion this$0;
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ Function1 $visibilityFilter;
            final /* synthetic */ LinkedHashMap $lookupElementToCount;

            public final void invoke(@NotNull KtParameter parameter) {
                KotlinType parameterType;
                VariableDescriptor descriptor2;
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                ProgressManager.checkCanceled();
                String name2 = parameter.getName();
                if (name2 != null && ParameterNameAndTypeCompletion.access$getPrefixMatcher$p(this.this$0).isStartMatch(name2) && (descriptor2 = (VariableDescriptor)ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, parameter, null, 2, null).get(BindingContext.VALUE_PARAMETER, parameter)) != null && ParameterNameAndTypeCompletion.access$isVisible(this.this$0, parameterType = descriptor2.getType(), this.$visibilityFilter)) {
                    LookupElement lookupElement2;
                    Integer n;
                    KotlinType kotlinType = parameterType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameterType");
                    LookupElement lookupElement3 = MyLookupElement.Companion.create(name2, new ArbitraryType(kotlinType), ParameterNameAndTypeCompletion.access$getLookupElementFactory$p(this.this$0));
                    if (lookupElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((n = (Integer)this.$lookupElementToCount.get(lookupElement2 = lookupElement3)) == null) {
                        n = 0;
                    }
                    Integer count = n;
                    Map map2 = this.$lookupElementToCount;
                    Integer n2 = ((Number)count).intValue() + 1;
                    map2.put(lookupElement2, n2);
                }
            }
            {
                this.this$0 = parameterNameAndTypeCompletion;
                this.$resolutionFacade = resolutionFacade2;
                this.$visibilityFilter = function1;
                this.$lookupElementToCount = linkedHashMap;
                super(1);
            }
        };
        $receiver$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv){
            final /* synthetic */ Function1 $action;

            public void visitElement(PsiElement element2) {
                PsiElement it = element2;
                if (!(it instanceof KtExpression) || it instanceof KtDeclaration) {
                    super.visitElement(element2);
                }
                if (element2 instanceof KtParameter) {
                    this.$action.invoke((Object)element2);
                }
            }
            {
                this.$action = $captured_local_variable$1;
            }
        });
        Map $i$f$forEachDescendantOfType = lookupElementToCount;
        object2 = $i$f$forEachDescendantOfType.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = (Map.Entry)object2.next();
            LookupElement lookupElement2 = (LookupElement)object3.getKey();
            Object object4 = object;
            int count = ((Number)object4.getValue()).intValue();
            lookupElement2.putUserData(ParameterNameAndTypeCompletion.Companion.getPRIORITY_KEY(), (Object)(-count));
            LookupElementsCollector.addElement$default(this.collector, lookupElement2, false, 2, null);
        }
    }

    private final void addSuggestionsForClassifier(DeclarationDescriptor classifier2, String userPrefix, boolean notImported) {
        String string = classifier2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classifier.name.asString()");
        DeclarationDescriptor declarationDescriptor = classifier2;
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
        }
        this.addSuggestions(string, userPrefix, new DescriptorType((ClassifierDescriptor)declarationDescriptor), notImported);
    }

    private final void addSuggestionsForJavaClass(PsiClass psiClass, String userPrefix, boolean notImported) {
        String string = psiClass.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiClass.name!!");
        this.addSuggestions(string, userPrefix, new JavaClassType(psiClass), notImported);
    }

    private final void addSuggestions(String className, String userPrefix, Type type2, boolean notImported) {
        ProgressManager.checkCanceled();
        if (this.suggestionsByTypesAdded.contains(type2)) {
            return;
        }
        CharSequence charSequence = userPrefix;
        Function1 function1 = addSuggestions.nameSuggestions.1.INSTANCE;
        String string = className;
        KotlinNameSuggester kotlinNameSuggester = KotlinNameSuggester.INSTANCE;
        boolean bl = charSequence.length() == 0;
        List<String> nameSuggestions2 = kotlinNameSuggester.getCamelNames(string, (Function1<? super String, Boolean>)function1, bl);
        for (String name2 : nameSuggestions2) {
            LookupElement lookupElement2;
            String parameterName = userPrefix + name2;
            if (!this.prefixMatcher.isStartMatch(parameterName) || (lookupElement2 = MyLookupElement.Companion.create(parameterName, type2, this.lookupElementFactory)) == null) continue;
            lookupElement2.putUserData(ParameterNameAndTypeCompletion.Companion.getPRIORITY_KEY(), (Object)userPrefix.length());
            this.collector.addElement(lookupElement2, notImported);
            this.suggestionsByTypesAdded.add(type2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisible(@NotNull KotlinType $receiver, Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        boolean bl;
        void $receiver$iv;
        ClassifierDescriptor classifier2;
        if ($receiver.isError()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) return false;
        ClassifierDescriptor classifierDescriptor2 = classifier2 = classifierDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor2, (String)"classifier");
        if ((Boolean)visibilityFilter.invoke((Object)classifierDescriptor2) == false) return false;
        Iterable iterable = $receiver.getArguments();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            TypeProjection it = (TypeProjection)element$iv;
            if (!it.isStarProjection()) {
                if (!this.isVisible(it.getType(), visibilityFilter)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public ParameterNameAndTypeCompletion(@NotNull LookupElementsCollector collector, @NotNull BasicLookupElementFactory lookupElementFactory, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade) {
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)lookupElementFactory, (String)"lookupElementFactory");
        Intrinsics.checkParameterIsNotNull((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        super();
        this.collector = collector;
        this.lookupElementFactory = lookupElementFactory;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade;
        prefix = this.prefixMatcher.getPrefix();
        prefixWords = NameUtil.splitNameIntoWords((String)prefix);
        var8_7 = prefix;
        if (var8_7.length() == 0) ** GOTO lbl-1000
        var8_8 = prefix.charAt(0);
        if (Character.isUpperCase(var8_8)) lbl-1000:
        // 2 sources

        {
            v0 = CollectionsKt.emptyList();
        } else {
            var8_7 = (Iterable)ArraysKt.getIndices((Object[])prefixWords);
            var9_9 = $receiver$iv;
            var10_10 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            var11_11 = $receiver$iv$iv.iterator();
            while (var11_11.hasNext()) {
                var13_14 = item$iv$iv = ((IntIterator)var11_11).nextInt();
                var17_16 = destination$iv$iv;
                var18_17 = index == 0 ? prefix : CollectionsKt.joinToString$default((Iterable)ArraysKt.drop((Object[])prefixWords, (int)index), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                var17_16.add(var18_17);
            }
            v0 = (List)destination$iv$iv;
        }
        nameSuggestionPrefixes = v0;
        $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)nameSuggestionPrefixes);
        var17_16 = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        var11_11 = $receiver$iv$iv.iterator();
        while (var11_11.hasNext()) {
            index = item$iv$iv = ((IntIterator)var11_11).nextInt();
            var18_17 = destination$iv$iv;
            var19_19 = CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])prefixWords, (int)it), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            var18_17.add(var19_19);
        }
        var18_17 = (List)destination$iv$iv;
        var17_16.userPrefixes = var18_17;
        $receiver$iv = nameSuggestionPrefixes;
        var17_16 = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            var18_17 = destination$iv$iv;
            var19_19 = new CamelHumpMatcher(StringsKt.capitalize((String)it), false);
            var18_17.add(var19_19);
        }
        var17_16.classNamePrefixMatchers = var18_17 = (List)destination$iv$iv;
        this.suggestionsByTypesAdded = new HashSet<E>();
    }

    static {
        Companion = new Companion(null);
        PRIORITY_KEY = new Key("ParameterNameAndTypeCompletion.PRIORITY_KEY");
        REPLACEMENT_OFFSET = OffsetKey.create((String)"ParameterNameAndTypeCompletion.REPLACEMENT_OFFSET");
    }

    public static final /* synthetic */ void access$addSuggestionsForClassifier(ParameterNameAndTypeCompletion $this, @NotNull DeclarationDescriptor classifier2, @NotNull String userPrefix, boolean notImported) {
        $this.addSuggestionsForClassifier(classifier2, userPrefix, notImported);
    }

    public static final /* synthetic */ void access$addSuggestionsForJavaClass(ParameterNameAndTypeCompletion $this, @NotNull PsiClass psiClass, @NotNull String userPrefix, boolean notImported) {
        $this.addSuggestionsForJavaClass(psiClass, userPrefix, notImported);
    }

    @NotNull
    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(ParameterNameAndTypeCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ boolean access$isVisible(ParameterNameAndTypeCompletion $this, @NotNull KotlinType $receiver, @NotNull Function1 visibilityFilter) {
        return $this.isVisible($receiver, (Function1<? super DeclarationDescriptor, Boolean>)visibilityFilter);
    }

    @NotNull
    public static final /* synthetic */ BasicLookupElementFactory access$getLookupElementFactory$p(ParameterNameAndTypeCompletion $this) {
        return $this.lookupElementFactory;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "", "idString", "", "(Ljava/lang/String;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "equals", "", "other", "hashCode", "", "idea-completion"})
    private static abstract class Type {
        private final String idString;

        @Nullable
        public abstract LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory var1);

        public boolean equals(@Nullable Object other) {
            return other instanceof Type && Intrinsics.areEqual((Object)((Type)other).idString, (Object)this.idString);
        }

        public int hashCode() {
            return this.idString.hashCode();
        }

        public Type(@NotNull String idString) {
            Intrinsics.checkParameterIsNotNull((Object)idString, (String)"idString");
            this.idString = idString;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$DescriptorType;", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "idea-completion"})
    private static final class DescriptorType
    extends Type {
        private final ClassifierDescriptor classifier;

        @Override
        @NotNull
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkParameterIsNotNull((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return BasicLookupElementFactory.createLookupElement$default(lookupElementFactory2, this.classifier, true, false, false, 12, null);
        }

        public DescriptorType(@NotNull ClassifierDescriptor classifier2) {
            Intrinsics.checkParameterIsNotNull((Object)classifier2, (String)"classifier");
            super(IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(classifier2));
            this.classifier = classifier2;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$JavaClassType;", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "psiClass", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "idea-completion"})
    private static final class JavaClassType
    extends Type {
        private final PsiClass psiClass;

        @Override
        @NotNull
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkParameterIsNotNull((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return BasicLookupElementFactory.createLookupElementForJavaClass$default(lookupElementFactory2, this.psiClass, true, false, 4, null);
        }

        public JavaClassType(@NotNull PsiClass psiClass) {
            Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
            String string = psiClass.getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiClass.qualifiedName!!");
            super(string);
            this.psiClass = psiClass;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$ArbitraryType;", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "idea-completion"})
    private static final class ArbitraryType
    extends Type {
        private final KotlinType type;

        @Override
        @Nullable
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkParameterIsNotNull((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return CompletionUtilsKt.createLookupElementForType(lookupElementFactory2, this.type);
        }

        public ArbitraryType(@NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
            this.type = type2;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$MyLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "", "type", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "typeLookupElement", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;Lcom/intellij/codeInsight/lookup/LookupElement;)V", "lookupString", "equals", "", "other", "", "getAllLookupStrings", "", "getLookupString", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "hashCode", "", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "Companion", "idea-completion"})
    private static final class MyLookupElement
    extends LookupElementDecorator<LookupElement> {
        private final String lookupString;
        private final String parameterName;
        private final Type type;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getLookupString() {
            return this.lookupString;
        }

        @NotNull
        public Set<String> getAllLookupStrings() {
            return SetsKt.setOf((Object)this.lookupString);
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            super.renderElement(presentation);
            presentation.setItemText(this.parameterName + ": " + presentation.getItemText());
        }

        public void handleInsert(@NotNull InsertionContext context) {
            int replacementOffset;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (context.getCompletionChar() == '\t' && (replacementOffset = context.getOffsetMap().getOffset(Companion.getREPLACEMENT_OFFSET())) != -1) {
                int tailOffset = context.getTailOffset();
                context.getDocument().deleteString(tailOffset, replacementOffset);
                CharSequence chars = context.getDocument().getCharsSequence();
                int offset2 = HandlerUtilsKt.skipSpaces(chars, tailOffset);
                if (HandlerUtilsKt.isCharAt(chars, offset2, ',')) {
                    ++offset2;
                    offset2 = HandlerUtilsKt.skipSpaces(chars, offset2);
                    GenerateUtilKt.moveCaret$default(context.getEditor(), offset2, null, 2, null);
                }
            }
            KotlinCodeStyleSettings settings = (KotlinCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)context.getProject()).getCurrentSettings().getCustomSettings(KotlinCodeStyleSettings.class);
            String spaceBefore = settings.SPACE_BEFORE_TYPE_COLON ? " " : "";
            String spaceAfter = settings.SPACE_AFTER_TYPE_COLON ? " " : "";
            String text2 = this.parameterName + spaceBefore + ":" + spaceAfter;
            int startOffset = context.getStartOffset();
            context.getDocument().insertString(startOffset, (CharSequence)text2);
            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + text2.length());
            super.handleInsert(context);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof MyLookupElement && Intrinsics.areEqual((Object)this.parameterName, (Object)((MyLookupElement)((Object)other)).parameterName) && Intrinsics.areEqual((Object)this.type, (Object)((MyLookupElement)((Object)other)).type);
        }

        public int hashCode() {
            return this.parameterName.hashCode();
        }

        private MyLookupElement(String parameterName, Type type2, LookupElement typeLookupElement2) {
            super(typeLookupElement2);
            this.parameterName = parameterName;
            this.type = type2;
            this.lookupString = this.parameterName + " : " + this.getDelegate().getLookupString();
        }

        public /* synthetic */ MyLookupElement(@NotNull String parameterName, @NotNull Type type2, @NotNull LookupElement typeLookupElement2, DefaultConstructorMarker $constructor_marker) {
            this(parameterName, type2, typeLookupElement2);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$MyLookupElement$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "", "type", "Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Type;", "factory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "idea-completion"})
        public static final class Companion {
            @Nullable
            public final LookupElement create(@NotNull String parameterName, @NotNull Type type2, @NotNull BasicLookupElementFactory factory2) {
                Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
                LookupElement lookupElement2 = type2.createTypeLookupElement(factory2);
                if (lookupElement2 == null) {
                    return null;
                }
                LookupElement typeLookupElement2 = lookupElement2;
                MyLookupElement lookupElement3 = new MyLookupElement(parameterName, type2, typeLookupElement2, null);
                return CompletionUtilsKt.suppressAutoInsertion((LookupElement)lookupElement3);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Weigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "()V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/lookup/WeighingContext;", "(Lcom/intellij/codeInsight/lookup/LookupElement;Lcom/intellij/codeInsight/lookup/WeighingContext;)Ljava/lang/Integer;", "idea-completion"})
    public static final class Weigher
    extends LookupElementWeigher {
        public static final Weigher INSTANCE;

        @NotNull
        public Integer weigh(@NotNull LookupElement element2, @NotNull WeighingContext context) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Integer n = (Integer)element2.getUserData(Companion.getPRIORITY_KEY());
            return n != null ? ((Number)n).intValue() : 0;
        }

        private Weigher() {
            super("kotlin.parameterNameAndTypePriority");
            INSTANCE = this;
        }

        static {
            new Weigher();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ParameterNameAndTypeCompletion$Companion;", "", "()V", "PRIORITY_KEY", "Lcom/intellij/openapi/util/Key;", "", "getPRIORITY_KEY", "()Lcom/intellij/openapi/util/Key;", "REPLACEMENT_OFFSET", "Lcom/intellij/codeInsight/completion/OffsetKey;", "kotlin.jvm.PlatformType", "getREPLACEMENT_OFFSET", "()Lcom/intellij/codeInsight/completion/OffsetKey;", "idea-completion"})
    public static final class Companion {
        private final Key<Integer> getPRIORITY_KEY() {
            return PRIORITY_KEY;
        }

        public final OffsetKey getREPLACEMENT_OFFSET() {
            return REPLACEMENT_OFFSET;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

