/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a!\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00062\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u000e\u001a\u00020\f*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u0012\u0010\u0014\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"surroundWithBracesIfInStringTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "indexOfSkippingSpace", "", "", "c", "", "startIndex", "(Ljava/lang/CharSequence;CI)Ljava/lang/Integer;", "isCharAt", "", "offset", "isTextAt", "Lcom/intellij/openapi/editor/Document;", "text", "", "skipSpaces", "index", "skipSpacesAndLineBreaks", "idea-completion"})
public final class HandlerUtilsKt {
    public static final void surroundWithBracesIfInStringTemplate(@NotNull InsertionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int startOffset = context.getStartOffset();
        Document document = context.getDocument();
        if (startOffset > 0 && document.getCharsSequence().charAt(startOffset - 1) == '$') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            psiDocumentManager.commitAllDocuments();
            PsiElement psiElement = context.getFile().findElementAt(startOffset - 1);
            if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START))) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                document.insertString(startOffset, (CharSequence)"{");
                context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
                int tailOffset = context.getTailOffset();
                document.insertString(tailOffset, (CharSequence)"}");
                context.setTailOffset(tailOffset);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer indexOfSkippingSpace(@NotNull CharSequence $receiver, char c, int startIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = startIndex;
        int n2 = $receiver.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                char currentChar;
                if (c == (currentChar = $receiver.charAt((int)i))) {
                    return (int)i;
                }
                if (currentChar != ' ' && currentChar != '\t') {
                    return null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return null;
    }

    public static final int skipSpaces(@NotNull CharSequence $receiver, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = (Iterable)new IntRange(index2, $receiver.length() - 1);
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                char c = $receiver.charAt(it);
                if (!(c != ' ' && c != '\t')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? ((Number)n).intValue() : $receiver.length();
    }

    public static final int skipSpacesAndLineBreaks(@NotNull CharSequence $receiver, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = (Iterable)new IntRange(index2, $receiver.length() - 1);
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                char c = $receiver.charAt(it);
                if (!(c != ' ' && c != '\t' && c != '\n' && c != '\r')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? ((Number)n).intValue() : $receiver.length();
    }

    public static final boolean isCharAt(@NotNull CharSequence $receiver, int offset2, char c) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return offset2 < $receiver.length() && $receiver.charAt(offset2) == c;
    }

    public static final boolean isTextAt(@NotNull Document $receiver, int offset2, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return offset2 + text2.length() <= $receiver.getTextLength() && Intrinsics.areEqual((Object)$receiver.getText(new TextRange(offset2, offset2 + text2.length())), (Object)text2);
    }
}

