/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class KotlinGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    public static final String NAME = "gradle";
    public static final String APPLY_KOTLIN = "apply plugin: 'kotlin'";

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JvmPlatform jvmPlatform = JvmPlatform.INSTANCE;
        if (jvmPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "getTargetPlatform"));
        }
        return jvmPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "getPresentableText"));
        }
        return "Gradle";
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "isApplicable"));
        }
        return KotlinPluginUtil.isGradleModule(module) && !KotlinPluginUtil.isAndroidGradleModule(module);
    }

    @Override
    protected String getApplyPluginDirective() {
        return APPLY_KOTLIN;
    }

    @Override
    protected boolean addSourceSetsBlock(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "addSourceSetsBlock"));
        }
        GrClosableBlock sourceSetBlock = KotlinGradleModuleConfigurator.getSourceSetsBlock((GrStatementOwner)file);
        return KotlinGradleModuleConfigurator.addLastExpressionInBlockIfNeeded("main.java.srcDirs += 'src/main/kotlin'\n", sourceSetBlock);
    }

    @Override
    protected boolean addElementsToFile(@NotNull GroovyFile groovyFile, boolean isTopLevelProjectFile, @NotNull String version) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "addElementsToFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator", "addElementsToFile"));
        }
        if (!isTopLevelProjectFile) {
            boolean wasModified = KotlinGradleModuleConfigurator.addElementsToProjectFile(groovyFile, version);
            return wasModified |= this.addElementsToModuleFile(groovyFile, version);
        }
        return false;
    }

    KotlinGradleModuleConfigurator() {
    }
}

