/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.SubpackagesImportingScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/HeuristicSignatures;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "correctedParameterType", "Lorg/jetbrains/kotlin/types/KotlinType;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterIndex", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "typeFromText", "text", "", "typeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Companion", "idea-core"})
public final class HeuristicSignatures {
    private final ModuleDescriptor moduleDescriptor;
    private final Project project;
    private final TypeResolver typeResolver;
    private static final HashMap<Pair<FqName, Name>, List<String>> signatures;
    public static final Companion Companion;

    @Nullable
    public final KotlinType correctedParameterType(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        int parameterIndex2 = function2.getValueParameters().indexOf(parameter);
        boolean bl = parameterIndex2 >= 0;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return this.correctedParameterType(function2, parameterIndex2);
    }

    private final KotlinType correctedParameterType(FunctionDescriptor function2, int parameterIndex2) {
        Collection<? extends FunctionDescriptor> superFunctions2;
        Annotated annotated = function2.getDispatchReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return null;
        }
        Annotated ownerType = annotated;
        Collection<? extends FunctionDescriptor> collection = superFunctions2 = function2.getOverriddenDescriptors();
        if (!collection.isEmpty()) {
            Iterator<? extends FunctionDescriptor> iterator2 = superFunctions2.iterator();
            while (iterator2.hasNext()) {
                FunctionDescriptor superFunction;
                FunctionDescriptor functionDescriptor = superFunction = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"superFunction");
                KotlinType kotlinType = this.correctedParameterType(functionDescriptor, parameterIndex2);
                if (kotlinType == null) {
                    continue;
                }
                KotlinType correctedType = kotlinType;
                TypeSubstitutor typeSubstitutor2 = SubstitutionUtils.buildDeepSubstitutor((KotlinType)ownerType);
                return typeSubstitutor2.safeSubstitute(correctedType, Variance.INVARIANT);
            }
            return null;
        }
        ClassifierDescriptor classifierDescriptor = ownerType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return null;
        }
        ClassifierDescriptor ownerClass = classifierDescriptor;
        FqNameUnsafe classFqName = DescriptorUtils.getFqName(ownerClass);
        if (!classFqName.isSafe()) {
            return null;
        }
        List list2 = (List)HeuristicSignatures.Companion.getSignatures().get(TuplesKt.to((Object)classFqName.toSafe(), (Object)function2.getName()));
        if (list2 == null) {
            return null;
        }
        List parameterTypes = list2;
        String typeStr = (String)parameterTypes.get(parameterIndex2);
        List<TypeParameterDescriptor> typeParameters = ownerClass.getTypeConstructor().getParameters();
        Collection collection2 = typeParameters;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"typeParameters");
        KotlinType type2 = this.typeFromText(typeStr, collection2);
        TypeConstructor typeConstructor2 = ownerClass.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ownerClass.typeConstructor");
        List<TypeProjection> list3 = ownerType.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ownerType.arguments");
        TypeSubstitutor substitutor3 = TypeConstructorSubstitution.Companion.create(typeConstructor2, list3).buildSubstitutor();
        return substitutor3.substitute(type2, Variance.INVARIANT);
    }

    private final KotlinType typeFromText(String text2, Collection<? extends TypeParameterDescriptor> typeParameters) {
        Unit unit;
        KtTypeReference typeRef = new KtPsiFactory(this.project).createType(text2);
        ImportingScope importingScope = null;
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        SubpackagesImportingScope rootPackagesScope = new SubpackagesImportingScope(importingScope, this.moduleDescriptor, fqName2);
        LexicalScopeImpl scope2 = new LexicalScopeImpl(rootPackagesScope, this.moduleDescriptor, false, null, LexicalScopeKind.SYNTHETIC, null, (Function1)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(typeParameters){
            final /* synthetic */ Collection $typeParameters;

            public final void invoke(@NotNull LexicalScopeImpl.InitializeHandler $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver$iv = this.$typeParameters;
                for (T element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    $receiver.addClassifierDescriptor(it);
                }
            }
            {
                this.$typeParameters = collection;
                super(1);
            }
        }, 32, null);
        KotlinType type2 = this.typeResolver.resolveType(scope2, typeRef, new BindingTraceContext(), false);
        boolean bl = !type2.isError();
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "No type resolved from '" + text2 + "'";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return type2;
    }

    public HeuristicSignatures(@NotNull ModuleDescriptor moduleDescriptor, @NotNull Project project, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        this.moduleDescriptor = moduleDescriptor;
        this.project = project;
        this.typeResolver = typeResolver;
    }

    static {
        Companion = new Companion(null);
        signatures = new HashMap();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.collection;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"BUILTIN_NAMES.collection");
        HeuristicSignatures.Companion.registerSignature(fqName2, "contains", "E");
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.collection;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"BUILTIN_NAMES.collection");
        HeuristicSignatures.Companion.registerSignature(fqName3, "containsAll", KotlinBuiltIns.FQ_NAMES.collection.asString() + "<E>");
        FqName fqName4 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"BUILTIN_NAMES.mutableCollection");
        HeuristicSignatures.Companion.registerSignature(fqName4, "remove", "E");
        FqName fqName5 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName5, (String)"BUILTIN_NAMES.mutableCollection");
        HeuristicSignatures.Companion.registerSignature(fqName5, "removeAll", KotlinBuiltIns.FQ_NAMES.collection.asString() + "<E>");
        FqName fqName6 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName6, (String)"BUILTIN_NAMES.mutableCollection");
        HeuristicSignatures.Companion.registerSignature(fqName6, "retainAll", KotlinBuiltIns.FQ_NAMES.collection.asString() + "<E>");
        FqName fqName7 = KotlinBuiltIns.FQ_NAMES.list;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName7, (String)"BUILTIN_NAMES.list");
        HeuristicSignatures.Companion.registerSignature(fqName7, "indexOf", "E");
        FqName fqName8 = KotlinBuiltIns.FQ_NAMES.list;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName8, (String)"BUILTIN_NAMES.list");
        HeuristicSignatures.Companion.registerSignature(fqName8, "lastIndexOf", "E");
        FqName fqName9 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName9, (String)"BUILTIN_NAMES.map");
        HeuristicSignatures.Companion.registerSignature(fqName9, "get", "K");
        FqName fqName10 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName10, (String)"BUILTIN_NAMES.map");
        HeuristicSignatures.Companion.registerSignature(fqName10, "containsKey", "K");
        FqName fqName11 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName11, (String)"BUILTIN_NAMES.map");
        HeuristicSignatures.Companion.registerSignature(fqName11, "containsValue", "V");
        FqName fqName12 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName12, (String)"BUILTIN_NAMES.mutableMap");
        HeuristicSignatures.Companion.registerSignature(fqName12, "remove", "K");
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\t2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0011\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0012R2\u0010\u0003\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/core/HeuristicSignatures$Companion;", "", "()V", "signatures", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/Name;", "", "", "getSignatures", "()Ljava/util/HashMap;", "registerSignature", "", "classFqName", "name", "parameterTypes", "", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;[Ljava/lang/String;)V", "idea-core"})
    public static final class Companion {
        private final HashMap<Pair<FqName, Name>, List<String>> getSignatures() {
            return signatures;
        }

        private final void registerSignature(FqName classFqName, String name2, String ... parameterTypes) {
            Map map2 = this.getSignatures();
            Pair pair2 = TuplesKt.to((Object)classFqName, (Object)Name.identifier(name2));
            List list2 = ArraysKt.toList((Object[])parameterTypes);
            map2.put(pair2, list2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

