/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0016J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createPresentationCodeFragment", "createWrappingContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "newFragmentText", "", "labels", "", "Lcom/sun/jdi/Value;", "originalContext", "fixImportIfNeeded", "import", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "kotlin.jvm.PlatformType", "getWrappedContextElement", "initImports", "imports", "isContextAccepted", "", "contextElement", "wrapContextIfNeeded", "Companion", "idea"})
public final class KotlinCodeFragmentFactory
extends CodeFragmentFactory {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());
    @NotNull
    private static final Key<Value> LABEL_VARIABLE_VALUE_KEY;
    @NotNull
    private static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    @NotNull
    private static final Key<StackFrameProxyImpl> DEBUG_FRAME_FOR_TESTS;
    public static final Companion Companion;

    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtElement contextElement = this.getWrappedContextElement(project, context);
        if (contextElement == null) {
            PsiElement psiElement = context;
            this.LOG.warn("CodeFragment with null context created:" + "\n" + "originalContext = " + (psiElement != null ? PsiUtilsKt.getElementTextWithContext(psiElement) : null));
        }
        if (Intrinsics.areEqual((Object)item.getKind(), (Object)CodeFragmentKind.EXPRESSION)) {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtExpressionCodeFragment(project, "fragment.kt", charSequence, this.initImports(item.getImports()), (PsiElement)contextElement);
        } else {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtBlockCodeFragment(project, "fragment.kt", charSequence, this.initImports(item.getImports()), (PsiElement)contextElement);
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        codeFragment.putCopyableUserData(KtCodeFragment.Companion.getRUNTIME_TYPE_EVALUATOR(), new Function1<KtExpression, KotlinType>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinType invoke(@NotNull KtExpression expression2) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx((Project)this.$project).getContext();
                DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                    kotlinType = null;
                } else {
                    Unit unit;
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    AtomicReference<V> nameRef = new AtomicReference<V>();
                    Editor editor = null;
                    DebuggerContextImpl debuggerContextImpl = debuggerContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                    KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(nameRef, semaphore, editor, expression2, debuggerContextImpl, progressIndicator){
                        final /* synthetic */ AtomicReference $nameRef;
                        final /* synthetic */ Semaphore $semaphore;

                        protected void typeCalculationFinished(@Nullable KotlinType type2) {
                            this.$nameRef.set(type2);
                            this.$semaphore.up();
                        }
                        {
                            this.$nameRef = $captured_local_variable$0;
                            this.$semaphore = $captured_local_variable$1;
                            super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
                        }
                    };
                    DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
                    if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                        debugProcessImpl.invoke((DebuggerCommandImpl)worker2);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    int n = 0;
                    int n2 = 50;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            ProgressManager.checkCanceled();
                            if (semaphore.waitFor(20L) || i == n2) break;
                            ++i;
                        }
                    }
                    kotlinType = (KotlinType)nameRef.get();
                }
                return kotlinType;
            }
            {
                this.$project = project;
                super(1);
            }
        });
        return codeFragment;
    }

    /*
     * WARNING - void declaration
     */
    private final String initImports(String imports) {
        if (imports != null) {
            CharSequence charSequence = imports;
            if (!(charSequence.length() == 0)) {
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Iterable $receiver$iv = StringsKt.split$default((CharSequence)imports, (String[])new String[]{KtCodeFragment.Companion.getIMPORT_SEPARATOR()}, (boolean)false, (int)0, (int)6, null);
                Iterable iterable = $receiver$iv;
                Collection collection = new ArrayList();
                void var5_5 = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Boolean bl;
                    Object element$iv$iv = element$iv$iv$iv;
                    String it = (String)element$iv$iv;
                    if (this.fixImportIfNeeded(it) != null) {
                        String string;
                        String it$iv$iv = string;
                        bl = destination$iv$iv.add(it$iv$iv);
                        continue;
                    }
                    bl = null;
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)KtCodeFragment.Companion.getIMPORT_SEPARATOR(), null, null, (int)0, null, null, (int)62, null);
            }
        }
        return null;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"[]");
            KotlinCodeFragmentFactory kotlinCodeFragmentFactory = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            return kotlinCodeFragmentFactory.fixImportIfNeeded(string4);
        }
        if (Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string) ^ true) {
            return null;
        }
        return string;
    }

    private final KtElement getWrappedContextElement(Project project, PsiElement context) {
        return this.wrapContextIfNeeded(project, Companion.getContextElement(context));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaCodeFragment kotlinCodeFragment = this.createCodeFragment(item, context, project);
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)kotlinCodeFragment)) && kotlinCodeFragment instanceof KtExpressionCodeFragment) {
            Object e2;
            PsiExpression psiExpression;
            try {
                psiExpression = PsiElementFactory.SERVICE.getInstance((Project)project).createExpressionFromText(item.getText(), context);
            }
            catch (IncorrectOperationException e2) {
                psiExpression = null;
            }
            PsiExpression javaExpression = psiExpression;
            try {
                PsiImportList psiImportList;
                KtImportList ktImportList = ((KtExpressionCodeFragment)kotlinCodeFragment).importsAsImportList();
                if (ktImportList != null) {
                    e2 = ktImportList;
                    KtImportList it = (KtImportList)e2;
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)it.getText());
                    if (!(psiFile instanceof PsiJavaFile)) {
                        psiFile = null;
                    }
                    PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                    psiImportList = psiJavaFile != null ? psiJavaFile.getImportList() : null;
                } else {
                    psiImportList = null;
                }
                e2 = psiImportList;
            }
            catch (IncorrectOperationException e3) {
                e2 = null;
            }
            PsiImportList importList = e2;
            if (javaExpression != null) {
                void convertedFragment;
                e2 = new Ref.ObjectRef();
                e2.element = null;
                ApplicationUtilsKt.executeWriteCommand(project, "Convert java expression to kotlin in Evaluate Expression", (Function0<Unit>)((Function0)new Function0<Unit>(javaExpression, importList, (Ref.ObjectRef)convertedFragment, project, kotlinCodeFragment){
                    final /* synthetic */ PsiExpression $javaExpression;
                    final /* synthetic */ PsiImportList $importList;
                    final /* synthetic */ Ref.ObjectRef $convertedFragment;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JavaCodeFragment $kotlinCodeFragment;

                    public final void invoke() {
                        String newImports;
                        String newText = JetRefactoringUtilKt.j2kText((PsiElement)this.$javaExpression);
                        PsiImportList psiImportList = this.$importList;
                        String string = newImports = psiImportList != null ? JetRefactoringUtilKt.j2kText((PsiElement)psiImportList) : null;
                        if (newText != null) {
                            String string2 = ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"kotlinCodeFragment.name");
                            this.$convertedFragment.element = new KtExpressionCodeFragment(this.$project, string2, newText, newImports, ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getContext());
                            AfterConversionPass afterConversionPass = new AfterConversionPass(this.$project, new J2kPostProcessor(false));
                            KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)this.$convertedFragment.element;
                            if (ktExpressionCodeFragment == null) {
                                Intrinsics.throwNpe();
                            }
                            afterConversionPass.run(ktExpressionCodeFragment, null);
                        }
                    }
                    {
                        this.$javaExpression = psiExpression;
                        this.$importList = psiImportList;
                        this.$convertedFragment = objectRef;
                        this.$project = project;
                        this.$kotlinCodeFragment = javaCodeFragment;
                        super(0);
                    }
                }));
                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)convertedFragment.element;
                return ktExpressionCodeFragment != null ? (JavaCodeFragment)ktExpressionCodeFragment : kotlinCodeFragment;
            }
        }
        return kotlinCodeFragment;
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        if (contextElement instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)contextElement).getContext();
            return this.isContextAccepted((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        }
        PsiElement psiElement = contextElement;
        return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)KotlinFileType.INSTANCE.getLanguage());
    }

    public KotlinFileType getFileType() {
        return KotlinFileType.INSTANCE;
    }

    @NotNull
    public KotlinEvaluationBuilder getEvaluatorBuilder() {
        return KotlinEvaluationBuilder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement wrapContextIfNeeded(Project project, KtElement originalContext) {
        void labels;
        void text2;
        Map markupMap;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (!(xDebugSession instanceof XDebugSessionImpl)) {
            xDebugSession = null;
        }
        XDebugSessionImpl xDebugSessionImpl = (XDebugSessionImpl)xDebugSession;
        if (xDebugSessionImpl == null) {
            return originalContext;
        }
        XDebugSessionImpl session = xDebugSessionImpl;
        XValueMarkers xValueMarkers = session.getValueMarkers();
        Map map2 = markupMap = xValueMarkers != null ? xValueMarkers.getAllMarkers() : null;
        if (markupMap == null || markupMap.isEmpty()) {
            return originalContext;
        }
        Object object = Companion.createCodeFragmentForLabeledObjects(project, markupMap);
        String string = (String)object.component1();
        Map map3 = (Map)object.component2();
        object = null;
        object = (CharSequence)text2;
        if (object.length() == 0) {
            return originalContext;
        }
        return this.createWrappingContext((String)text2, (Map<String, ? extends Value>)labels, (PsiElement)originalContext, project);
    }

    @Nullable
    public final KtElement createWrappingContext(@NotNull String newFragmentText, @NotNull Map<String, ? extends Value> labels, @Nullable PsiElement originalContext, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)newFragmentText, (String)"newFragmentText");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtBlockCodeFragment codeFragment = new KtPsiFactory(project).createBlockCodeFragment(newFragmentText, originalContext);
        codeFragment.accept(new KtTreeVisitorVoid(labels){
            final /* synthetic */ Map $labels;

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                Map map2 = this.$labels;
                String string = property2.getName();
                Map map3 = map2;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                Value reference2 = (Value)map3.get(string);
                if (reference2 != null) {
                    property2.putUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY(), reference2);
                }
            }
            {
                this.$labels = $captured_local_variable$0;
            }
        });
        return Companion.getContextElement(codeFragment.findElementAt(codeFragment.getText().length() - 1));
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"_label_variable_value_key_");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Value>(\"_label_variable_value_key_\")");
        LABEL_VARIABLE_VALUE_KEY = key;
        DEBUG_LABEL_SUFFIX = DEBUG_LABEL_SUFFIX;
        Key key2 = Key.create((String)"DEBUG_FRAME_FOR_TESTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_FRAME_FOR_TESTS\")");
        DEBUG_FRAME_FOR_TESTS = key2;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u0011J*\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010\u001bH\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$Companion;", "", "()V", "DEBUG_FRAME_FOR_TESTS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getDEBUG_FRAME_FOR_TESTS", "()Lcom/intellij/openapi/util/Key;", "DEBUG_LABEL_SUFFIX", "", "getDEBUG_LABEL_SUFFIX", "()Ljava/lang/String;", "LABEL_VARIABLE_VALUE_KEY", "Lcom/sun/jdi/Value;", "getLABEL_VARIABLE_VALUE_KEY", "createCodeFragmentForLabeledObjects", "Lkotlin/Pair;", "", "project", "Lcom/intellij/openapi/project/Project;", "markupMap", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "createKotlinProperty", "variableName", "variableTypeName", "value", "getContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementAt", "Lcom/intellij/psi/PsiElement;", "check", "", "idea"})
    public static final class Companion {
        @NotNull
        public final Key<Value> getLABEL_VARIABLE_VALUE_KEY() {
            return LABEL_VARIABLE_VALUE_KEY;
        }

        @NotNull
        public final String getDEBUG_LABEL_SUFFIX() {
            return DEBUG_LABEL_SUFFIX;
        }

        @NotNull
        public final Key<StackFrameProxyImpl> getDEBUG_FRAME_FOR_TESTS() {
            return DEBUG_FRAME_FOR_TESTS;
        }

        @Nullable
        public final KtElement getContextElement(@Nullable PsiElement elementAt) {
            int n;
            if (elementAt == null) {
                return null;
            }
            if (elementAt instanceof PsiCodeBlock) {
                PsiElement psiElement = ((PsiCodeBlock)elementAt).getContext();
                return this.getContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
            }
            if (elementAt instanceof KtLightClass) {
                return this.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
            }
            PsiFile containingFile = elementAt.getContainingFile();
            if (!(containingFile instanceof KtFile)) {
                return null;
            }
            if (elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) {
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                n = psiElement != null ? psiElement.getTextOffset() : elementAt.getTextOffset();
            } else {
                n = elementAt.getTextOffset();
            }
            int lineStartOffset = n;
            KtExpression result2 = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)lineStartOffset, KtExpression.class, (boolean)false);
            if (this.check(result2)) {
                KtExpression ktExpression = result2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CodeInsightUtils.getTopmostElementAtOffset((PsiElement)ktExpression, lineStartOffset, KtExpression.class);
            }
            result2 = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
            if (this.check(result2)) {
                return result2;
            }
            return (KtElement)containingFile;
        }

        private final boolean check(@Nullable KtElement $receiver) {
            return $receiver != null && AddToStdlibKt.check($receiver, check.1.INSTANCE) != null;
        }

        @NotNull
        public final Pair<String, Map<String, Value>> createCodeFragmentForLabeledObjects(@NotNull Project project, @NotNull Map<?, ? extends ValueMarkup> markupMap) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(markupMap, (String)"markupMap");
            StringBuilder sb = new StringBuilder();
            HashMap<String, Value> labeledObjects = new HashMap<String, Value>();
            Set<Map.Entry<?, ValueMarkup>> entrySet = markupMap.entrySet();
            Iterator<Map.Entry<?, ValueMarkup>> iterator2 = entrySet.iterator();
            while (iterator2.hasNext()) {
                Value objectRef;
                Map.Entry<?, ValueMarkup> entry;
                Map.Entry<?, ValueMarkup> entry2 = entry = iterator2.next();
                Object value2 = entry2.getKey();
                Map.Entry<?, ValueMarkup> entry3 = entry;
                ValueMarkup markup = entry3.getValue();
                String labelName = markup.getText();
                if (!Name.isValidIdentifier(labelName)) continue;
                Object obj = value2;
                if (!(obj instanceof Value)) {
                    obj = null;
                }
                if ((Value)obj == null) {
                    continue;
                }
                String labelNameWithSuffix = labelName + this.getDEBUG_LABEL_SUFFIX();
                StringBuilder stringBuilder = new StringBuilder();
                String string = objectRef.type().name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectRef.type().name()");
                sb.append(stringBuilder.append(this.createKotlinProperty(project, labelNameWithSuffix, string, objectRef)).append("\n").toString());
                labeledObjects.put(labelNameWithSuffix, objectRef);
            }
            sb.append("val _debug_context_val = 1");
            return TuplesKt.to((Object)sb.toString(), labeledObjects);
        }

        private final String createKotlinProperty(Project project, String variableName, String variableTypeName, Value value2) {
            Type type2 = JdiValuesKt.asValue(value2).getAsmType();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
            ClassDescriptor actualClassDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type2, globalSearchScope);
            if (actualClassDescriptor != null && actualClassDescriptor.getDefaultType().getArguments().isEmpty()) {
                String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(TypeUtilsKt.makeNullable(actualClassDescriptor.getDefaultType()));
                return "val " + JetRefactoringUtilKt.quoteIfNeeded(variableName) + ": " + renderedType + " = null";
            }
            Function1<String, String> addArraySuffix$ = new Function1<String, String>(value2){
                final /* synthetic */ Value $value;

                @NotNull
                public final String invoke(@NotNull String $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return this.$value instanceof ArrayReference ? $receiver + "[]" : $receiver;
                }
                {
                    this.$value = value2;
                    super(1);
                }
            };
            String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)variableTypeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
            PsiClassType classType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            String type3 = addArraySuffix$.invoke(!(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className);
            PsiField field2 = PsiElementFactory.SERVICE.getInstance((Project)project).createField(variableName, (PsiType)PsiType.getTypeByName((String)type3, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
            String string = JetRefactoringUtilKt.j2kText((PsiElement)field2);
            return string != null ? StringsKt.substringAfter$default((String)string, (String)"private ", null, (int)2, null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

