/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a<\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a6\u0010\u0016\u001a\u0004\u0018\u00010\u0005*\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002\u001a*\u0010\u001c\u001a\u0004\u0018\u00010\u0005*\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a$\u0010\u001e\u001a\u0004\u0018\u00010\u0005*\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u00a8\u0006 "}, d2={"getInlineArgumentIfAny", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "elementAt", "Lcom/intellij/psi/PsiElement;", "getStepOutPosition", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "location", "Lcom/sun/jdi/Location;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "inlineFunctions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "inlinedArgument", "getStepOverPosition", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "range", "Lkotlin/ranges/IntRange;", "inlinedArguments", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToSkip", "getNextPositionWithFilter", "locations", "skip", "Lkotlin/Function2;", "", "", "getXPositionForStepOutFromInlineFunction", "inlineFunctionsToSkip", "getXPositionForStepOutFromInlinedArgument", "inlinedArgumentToSkip", "idea"})
public final class KotlinSteppingCommandProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final XSourcePositionImpl getStepOverPosition(@NotNull Location location2, @NotNull KtFile file, @NotNull IntRange range, @NotNull List<? extends KtElement> inlinedArguments, @NotNull List<? extends PsiElement> elementsToSkip) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Location it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull(inlinedArguments, (String)"inlinedArguments");
        Intrinsics.checkParameterIsNotNull(elementsToSkip, (String)"elementsToSkip");
        ReferenceType referenceType = location2.declaringType();
        if (referenceType == null) {
            return null;
        }
        ReferenceType computedReferenceType = referenceType;
        Function1<Location, Boolean> isLocationSuitable$ = new Function1<Location, Boolean>(location2, range, file){
            final /* synthetic */ Location $location;
            final /* synthetic */ IntRange $range;
            final /* synthetic */ KtFile $file;

            public final boolean invoke(@NotNull Location nextLocation) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)nextLocation, (String)"nextLocation");
                if (Intrinsics.areEqual((Object)nextLocation.method(), (Object)this.$location.method()) ^ true || this.$range.contains(nextLocation.lineNumber()) ^ true) {
                    return false;
                }
                try {
                    bl = Intrinsics.areEqual((Object)nextLocation.sourceName("Kotlin"), (Object)this.$file.getName());
                }
                catch (AbsentInformationException e) {
                    return true;
                }
                return bl;
            }
            {
                this.$location = location2;
                this.$range = intRange;
                this.$file = ktFile;
                super(1);
            }
        };
        Iterable iterable = computedReferenceType.allLineLocations();
        boolean yielding$iv22 = false;
        Collection list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv22) {
                ((ArrayList)list$iv).add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (Intrinsics.areEqual((Object)it, (Object)location2) ^ true) continue;
            ((ArrayList)list$iv).add(item$iv);
            yielding$iv22 = true;
        }
        $receiver$iv = CollectionsKt.drop((Iterable)((List)list$iv), (int)1);
        Iterable yielding$iv22 = $receiver$iv;
        list$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Location location3 = it = (Location)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"it");
            if (!isLocationSuitable$.invoke(location3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        boolean yielding$iv = false;
        list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                ((ArrayList)list$iv).add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (it.lineNumber() == location2.lineNumber()) continue;
            ((ArrayList)list$iv).add(item$iv);
            yielding$iv = true;
        }
        List locations = (List)list$iv;
        for (Location locationAtLine : locations) {
            boolean bl;
            int lineStartOffset;
            block13: {
                boolean bl2;
                KtElement it2;
                Iterable $receiver$iv2;
                block12: {
                    Object item$iv;
                    int lineNumber = locationAtLine.lineNumber();
                    Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber - 1);
                    if (n == null) {
                        continue;
                    }
                    lineStartOffset = ((Number)n).intValue();
                    item$iv = inlinedArguments;
                    for (Object element$iv : $receiver$iv2) {
                        it2 = (KtElement)element$iv;
                        if (!it2.getTextRange().contains(lineStartOffset)) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
                if (bl2) continue;
                $receiver$iv2 = elementsToSkip;
                for (Object element$iv : $receiver$iv2) {
                    it2 = (PsiElement)element$iv;
                    if (!it2.getTextRange().contains(lineStartOffset)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            if (bl) continue;
            PsiElement psiElement = file.findElementAt(lineStartOffset);
            if (psiElement == null) {
                continue;
            }
            PsiElement elementAt = psiElement;
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)elementAt);
            if (xSourcePositionImpl == null) {
                return null;
            }
            return xSourcePositionImpl;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final XSourcePositionImpl getStepOutPosition(@NotNull Location location2, @NotNull SuspendContextImpl suspendContext, @NotNull List<? extends KtNamedFunction> inlineFunctions, @Nullable KtFunctionLiteral inlinedArgument) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Location it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(inlineFunctions, (String)"inlineFunctions");
        ReferenceType referenceType = location2.declaringType();
        if (referenceType == null) {
            return null;
        }
        ReferenceType computedReferenceType = referenceType;
        List<Location> locations = computedReferenceType.allLineLocations();
        Iterable iterable = locations;
        boolean yielding$iv22 = false;
        Collection list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv22) {
                ((ArrayList)list$iv).add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (Intrinsics.areEqual((Object)it, (Object)location2) ^ true) continue;
            ((ArrayList)list$iv).add(item$iv);
            yielding$iv22 = true;
        }
        $receiver$iv = CollectionsKt.drop((Iterable)((List)list$iv), (int)1);
        Iterable yielding$iv22 = $receiver$iv;
        list$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Location)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.method(), (Object)location2.method())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        boolean yielding$iv = false;
        list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                ((ArrayList)list$iv).add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (it.lineNumber() == location2.lineNumber()) continue;
            ((ArrayList)list$iv).add(item$iv);
            yielding$iv = true;
        }
        List nextLineLocations = (List)list$iv;
        iterable = inlineFunctions;
        if (!iterable.isEmpty()) {
            XSourcePositionImpl xSourcePositionImpl = KotlinSteppingCommandProviderKt.getXPositionForStepOutFromInlineFunction(suspendContext, nextLineLocations, inlineFunctions);
            if (xSourcePositionImpl == null) {
                return null;
            }
            return xSourcePositionImpl;
        }
        if (inlinedArgument != null) {
            XSourcePositionImpl xSourcePositionImpl = KotlinSteppingCommandProviderKt.getXPositionForStepOutFromInlinedArgument(suspendContext, nextLineLocations, inlinedArgument);
            if (xSourcePositionImpl == null) {
                return null;
            }
            return xSourcePositionImpl;
        }
        return null;
    }

    private static final XSourcePositionImpl getXPositionForStepOutFromInlineFunction(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, List<? extends KtNamedFunction> inlineFunctionsToSkip) {
        return KotlinSteppingCommandProviderKt.getNextPositionWithFilter($receiver, locations, (Function2<? super Integer, ? super PsiElement, Boolean>)((Function2)new Function2<Integer, PsiElement, Boolean>(inlineFunctionsToSkip){
            final /* synthetic */ List $inlineFunctionsToSkip;

            public final boolean invoke(int offset2, @NotNull PsiElement elementAt) {
                boolean bl;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)elementAt, (String)"elementAt");
                    Iterable $receiver$iv = this.$inlineFunctionsToSkip;
                    for (T element$iv : $receiver$iv) {
                        KtNamedFunction it = (KtNamedFunction)element$iv;
                        if (!it.getTextRange().contains(offset2)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
                return KotlinSteppingCommandProviderKt.access$getInlineArgumentIfAny(elementAt) != null;
            }
            {
                this.$inlineFunctionsToSkip = list2;
                super(2);
            }
        }));
    }

    private static final XSourcePositionImpl getXPositionForStepOutFromInlinedArgument(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, KtFunctionLiteral inlinedArgumentToSkip) {
        return KotlinSteppingCommandProviderKt.getNextPositionWithFilter($receiver, locations, (Function2<? super Integer, ? super PsiElement, Boolean>)((Function2)new Function2<Integer, PsiElement, Boolean>(inlinedArgumentToSkip){
            final /* synthetic */ KtFunctionLiteral $inlinedArgumentToSkip;

            public final boolean invoke(int offset2, @NotNull PsiElement elementAt) {
                Intrinsics.checkParameterIsNotNull((Object)elementAt, (String)"elementAt");
                return this.$inlinedArgumentToSkip.getTextRange().contains(offset2);
            }
            {
                this.$inlinedArgumentToSkip = ktFunctionLiteral;
                super(2);
            }
        }));
    }

    private static final XSourcePositionImpl getNextPositionWithFilter(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, Function2<? super Integer, ? super PsiElement, Boolean> skip2) {
        for (Location location2 : locations) {
            PsiElement elementAt;
            KtFile file;
            SourcePosition sourcePosition2;
            SourcePosition sourcePosition3;
            try {
                sourcePosition3 = $receiver.getDebugProcess().getPositionManager().getSourcePosition(location2);
            }
            catch (NoDataException e) {
                sourcePosition3 = null;
            }
            if (sourcePosition3 == null) {
                continue;
            }
            PsiFile psiFile = sourcePosition2.getFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            if ((KtFile)psiFile == null) {
                continue;
            }
            if (sourcePosition2.getElementAt() == null) {
                continue;
            }
            int currentLine = location2.lineNumber() - 1;
            Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, currentLine);
            if (n == null) {
                continue;
            }
            int lineStartOffset = ((Number)n).intValue();
            if (((Boolean)skip2.invoke((Object)lineStartOffset, (Object)elementAt)).booleanValue()) continue;
            return XSourcePositionImpl.createByElement((PsiElement)elementAt);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtFunctionLiteral getInlineArgumentIfAny(PsiElement elementAt) {
        Object object;
        block5: {
            block4: {
                void $receiver$iv;
                object = elementAt;
                if (object == null) break block4;
                PsiElement psiElement = object;
                boolean strict$iv = false;
                object = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLambdaExpression.class, (boolean)strict$iv);
                if (object != null) break block5;
            }
            return null;
        }
        Object functionLiteralExpression = object;
        BindingContext context = ResolutionUtils.analyze((KtElement)functionLiteralExpression, BodyResolveMode.PARTIAL);
        if (!InlineUtil.isInlinedArgument(((KtLambdaExpression)functionLiteralExpression).getFunctionLiteral(), context, false)) {
            return null;
        }
        return ((KtLambdaExpression)functionLiteralExpression).getFunctionLiteral();
    }

    @Nullable
    public static final /* synthetic */ KtFunctionLiteral access$getInlineArgumentIfAny(@Nullable PsiElement elementAt) {
        return KotlinSteppingCommandProviderKt.getInlineArgumentIfAny(elementAt);
    }
}

