/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b6\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "", "()V", "Companion", "Compatible", "Incompatible", "idea-analysis"})
public abstract class BuiltInDefinitionFile {
    private static boolean FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
    public static final Companion Companion;

    private BuiltInDefinitionFile() {
    }

    static {
        Companion = new Companion(null);
        FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = true;
    }

    public /* synthetic */ BuiltInDefinitionFile(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile$Incompatible;", "Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "version", "Lorg/jetbrains/kotlin/builtins/BuiltInsBinaryVersion;", "(Lorg/jetbrains/kotlin/builtins/BuiltInsBinaryVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/builtins/BuiltInsBinaryVersion;", "idea-analysis"})
    public static final class Incompatible
    extends BuiltInDefinitionFile {
        @NotNull
        private final BuiltInsBinaryVersion version;

        @NotNull
        public final BuiltInsBinaryVersion getVersion() {
            return this.version;
        }

        public Incompatible(@NotNull BuiltInsBinaryVersion version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            super(null);
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R5\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile$Compatible;", "Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "proto", "Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsProtoBuf$BuiltIns;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsProtoBuf$BuiltIns;Lcom/intellij/openapi/vfs/VirtualFile;)V", "classesToDecompile", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "kotlin.jvm.PlatformType", "getClassesToDecompile", "()Ljava/util/List;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getProto", "()Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsProtoBuf$BuiltIns;", "shouldDecompileBuiltInClass", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "idea-analysis"})
    public static final class Compatible
    extends BuiltInDefinitionFile {
        @NotNull
        private final NameResolverImpl nameResolver;
        @NotNull
        private final FqName packageFqName;
        private final List<ProtoBuf.Class> classesToDecompile;
        @NotNull
        private final BuiltInsProtoBuf.BuiltIns proto;
        @NotNull
        private final VirtualFile packageDirectory;

        @NotNull
        public final NameResolverImpl getNameResolver() {
            return this.nameResolver;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        public final List<ProtoBuf.Class> getClassesToDecompile() {
            return this.classesToDecompile;
        }

        private final boolean shouldDecompileBuiltInClass(ClassId classId) {
            if (classId.isNestedClass()) {
                return false;
            }
            String realJvmClassFileName = classId.getShortClassName().asString() + "." + JavaClassFileType.INSTANCE.getDefaultExtension();
            return this.packageDirectory.findChild(realJvmClassFileName) == null;
        }

        @NotNull
        public final BuiltInsProtoBuf.BuiltIns getProto() {
            return this.proto;
        }

        @NotNull
        public final VirtualFile getPackageDirectory() {
            return this.packageDirectory;
        }

        /*
         * WARNING - void declaration
         */
        public Compatible(@NotNull BuiltInsProtoBuf.BuiltIns proto, @NotNull VirtualFile packageDirectory) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
            Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
            super(null);
            this.proto = proto;
            this.packageDirectory = packageDirectory;
            ProtoBuf.StringTable stringTable = this.proto.getStrings();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"proto.strings");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"proto.qualifiedNames");
            this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            this.packageFqName = this.nameResolver.getPackageFqName(((Number)this.proto.getPackage().getExtension(BuiltInsProtoBuf.packageFqName)).intValue());
            Compatible compatible = this;
            if (Companion.getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES()) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = this.proto.getClassList();
                Compatible compatible2 = compatible;
                void var4_5 = $receiver$iv;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv$iv;
                    if (!this.shouldDecompileBuiltInClass(this.nameResolver.getClassId(classProto.getFqName()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                compatible = compatible2;
                list2 = list3;
            } else {
                list2 = this.proto.getClassList();
            }
            compatible.classesToDecompile = list2;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile$Companion;", "", "()V", "<set-?>", "", "FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "()Z", "setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "(Z)V", "read", "Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
    public static final class Companion {
        public final boolean getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES() {
            return FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
        }

        public final void setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES(boolean bl) {
            FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = bl;
        }

        @Nullable
        public final BuiltInDefinitionFile read(@NotNull VirtualFile file) {
            BuiltInsProtoBuf.BuiltIns proto;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ByteArrayInputStream stream2 = new ByteArrayInputStream(file.contentsToByteArray());
            BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream2);
            if (!version.isCompatible()) {
                return new Incompatible(version);
            }
            BuiltInsProtoBuf.BuiltIns builtIns = proto = BuiltInsProtoBuf.BuiltIns.parseFrom(stream2, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
            Intrinsics.checkExpressionValueIsNotNull((Object)builtIns, (String)"proto");
            VirtualFile virtualFile2 = file.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.parent");
            Compatible result2 = new Compatible(builtIns, virtualFile2);
            if (result2.getClassesToDecompile().isEmpty() && result2.getProto().getPackage().getFunctionCount() == 0 && result2.getProto().getPackage().getPropertyCount() == 0) {
                return null;
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

