/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsClassDataFinder;
import org.jetbrains.kotlin.idea.decompiler.builtIns.BuiltInDefinitionFile;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/KotlinBuiltInStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "", "idea-analysis"})
public final class KotlinBuiltInStubBuilder
extends ClsStubBuilder {
    public int getStubVersion() {
        return 15;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        BuiltInDefinitionFile file;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile2 = content2.getFile();
        boolean bl = Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)KotlinBuiltInFileType.INSTANCE);
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Unexpected file type " + virtualFile2.getFileType();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
        BuiltInDefinitionFile builtInDefinitionFile = BuiltInDefinitionFile.Companion.read(virtualFile3);
        if (builtInDefinitionFile == null) {
            return null;
        }
        BuiltInDefinitionFile builtInDefinitionFile2 = file = builtInDefinitionFile;
        if (builtInDefinitionFile2 instanceof BuiltInDefinitionFile.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (builtInDefinitionFile2 instanceof BuiltInDefinitionFile.Compatible) {
            ProtoBuf.Package packageProto = ((BuiltInDefinitionFile.Compatible)file).getProto().getPackage();
            FqName packageFqName = ((BuiltInDefinitionFile.Compatible)file).getPackageFqName();
            NameResolverImpl nameResolver = ((BuiltInDefinitionFile.Compatible)file).getNameResolver();
            ClassDataFinder classDataFinder2 = new BuiltInsClassDataFinder(((BuiltInDefinitionFile.Compatible)file).getProto(), nameResolver);
            AnnotationAndConstantLoader annotationAndConstantLoader = new AnnotationLoaderForStubBuilderImpl(BuiltInSerializerProtocol.INSTANCE);
            VirtualFile virtualFile4 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"virtualFile");
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(classDataFinder2, annotationAndConstantLoader, virtualFile4);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName);
            StubElement stubElement = (StubElement)fileStub;
            ProtoContainer protoContainer = new ProtoContainer.Package(packageFqName, context.getNameResolver(), context.getTypeTable(), null);
            List<ProtoBuf.Function> list2 = packageProto.getFunctionList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"packageProto.functionList");
            List<ProtoBuf.Property> list3 = packageProto.getPropertyList();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"packageProto.propertyList");
            CallableClsStubBuilderKt.createCallableStubs((StubElement<? extends PsiElement>)stubElement, context, protoContainer, list2, list3);
            for (ProtoBuf.Class classProto : ((BuiltInDefinitionFile.Compatible)file).getClassesToDecompile()) {
                StubElement stubElement2 = (StubElement)fileStub;
                ProtoBuf.Class clazz = classProto;
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classProto");
                ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)stubElement2, clazz, nameResolver, nameResolver.getClassId(classProto.getFqName()), context);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }
}

