/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndexer;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.BuiltInClassesAreSerializableOnJvm;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\u000f\u001a\u00020\u0002*\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/ByDescriptorIndexer;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledTextIndexer;", "", "()V", "descriptorRendererForKeys", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getDeclarationForDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "file", "Lorg/jetbrains/kotlin/idea/decompiler/KtDecompiledFile;", "getDeclarationForDescriptor$idea_analysis", "indexDescriptor", "", "toStringKey", "idea-analysis"})
public final class ByDescriptorIndexer
implements DecompiledTextIndexer<String> {
    private static final DescriptorRenderer descriptorRendererForKeys;
    public static final ByDescriptorIndexer INSTANCE;

    @Override
    @NotNull
    public Collection<String> indexDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return CollectionsKt.listOf((Object)this.toStringKey(descriptor2));
    }

    @Nullable
    public final KtDeclaration getDeclarationForDescriptor$idea_analysis(@NotNull DeclarationDescriptor descriptor2, @NotNull KtDecompiledFile file) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        DeclarationDescriptor original = descriptor2.getOriginal();
        if (original instanceof ValueParameterDescriptor) {
            CallableDescriptor callable = ((ValueParameterDescriptor)original).getContainingDeclaration();
            KtDeclaration ktDeclaration = this.getDeclarationForDescriptor$idea_analysis(callable, file);
            if (!(ktDeclaration instanceof KtCallableDeclaration)) {
                ktDeclaration = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)ktDeclaration;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration callableDeclaration = ktCallableDeclaration;
            return callableDeclaration.getValueParameters().get(((ValueParameterDescriptor)original).getIndex());
        }
        if (original instanceof ConstructorDescriptor && ((ConstructorDescriptor)original).isPrimary()) {
            KtClassOrObject classOrObject;
            KtDeclarationStub ktDeclarationStub;
            DeclarationDescriptor declarationDescriptor = ((ConstructorDescriptor)original).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"original.containingDeclaration");
            KtDeclaration ktDeclaration = this.getDeclarationForDescriptor$idea_analysis(declarationDescriptor, file);
            if (!(ktDeclaration instanceof KtClassOrObject)) {
                ktDeclaration = null;
            }
            return (ktDeclarationStub = (classOrObject = (KtClassOrObject)ktDeclaration)) != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtDeclaration)ktDeclarationStub : (KtDeclaration)classOrObject;
        }
        KtDeclaration ktDeclaration = file.getDeclaration(this, this.toStringKey(original));
        if (ktDeclaration == null) {
            ByDescriptorIndexer byDescriptorIndexer = this;
            ByDescriptorIndexer $receiver = byDescriptorIndexer;
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return null;
            }
            FqName classFqName = DescriptorUtilsKt.getFqNameSafe(descriptor2);
            if (BuiltInClassesAreSerializableOnJvm.Companion.isSerializableInJava(classFqName)) {
                KtDeclaration ktDeclaration2;
                ClassDescriptor builtInDescriptor;
                ClassDescriptor classDescriptor = builtInDescriptor = DescriptorUtilsKt.resolveTopLevelClass(TargetPlatform.Default.INSTANCE.getBuiltIns().getBuiltInsModule(), classFqName, NoLookupLocation.FROM_IDE);
                if (classDescriptor != null) {
                    ClassDescriptor classDescriptor2 = classDescriptor;
                    ClassDescriptor it = classDescriptor2;
                    ktDeclaration2 = file.getDeclaration($receiver, $receiver.toStringKey(it));
                } else {
                    ktDeclaration2 = null;
                }
                return ktDeclaration2;
            }
            return null;
        }
        return ktDeclaration;
    }

    private final String toStringKey(@NotNull DeclarationDescriptor $receiver) {
        return descriptorRendererForKeys.render($receiver);
    }

    private ByDescriptorIndexer() {
        INSTANCE = this;
        descriptorRendererForKeys = DescriptorRenderer.COMPACT_WITH_MODIFIERS.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)descriptorRendererForKeys.1.INSTANCE));
    }

    static {
        new ByDescriptorIndexer();
    }
}

