/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContextKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FlagsToModifiers;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeClsStubBuilder;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.Deserialization;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010$\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\u001dH\u0002J\u0016\u0010'\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010(\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J \u0010,\u001a\u00020\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010-\u001a\u00020\nH\u0002J\u0010\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J\b\u0010/\u001a\u000200H\u0002R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00150\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClassClsStubBuilder;", "", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "classProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "outerContext", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;)V", "c", "classKind", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Kind;", "Lorg/jetbrains/annotations/Nullable;", "classOrObjectStub", "companionObjectName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "supertypeIds", "", "thisAsProtoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer$Class;", "typeStubBuilder", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/TypeClsStubBuilder;", "build", "", "createCallableMemberStubs", "classBody", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinPlaceHolderStubImpl;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "createClassBodyAndMemberStubs", "createClassOrObjectStubAndModifierListStub", "createCompanionObjectStub", "createConstructorStub", "createDelegationSpecifierList", "createEnumEntryStubs", "createInnerAndNestedClasses", "createModifierListForClass", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl;", "parent", "createNestedClassStub", "nestedClassId", "doCreateClassOrObjectStub", "isClass", "", "Companion", "idea-analysis"})
final class ClassClsStubBuilder {
    private final ProtoBuf.Class.Kind classKind;
    private final ClsStubBuilderContext c;
    private final TypeClsStubBuilder typeStubBuilder;
    private final List<ClassId> supertypeIds;
    private final Name companionObjectName;
    private final ProtoContainer.Class thisAsProtoContainer;
    private final StubElement<? extends PsiElement> classOrObjectStub;
    private final StubElement<? extends PsiElement> parentStub;
    private final ProtoBuf.Class classProto;
    private final NameResolver nameResolver;
    private final ClassId classId;
    private final ClsStubBuilderContext outerContext;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void build() {
        List<ProtoBuf.TypeParameter> list2 = this.classProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.typeParameterList");
        List<Pair<Name, ProtoBuf.Type>> typeConstraintListData = this.typeStubBuilder.createTypeParameterListStub(this.classOrObjectStub, list2);
        this.createConstructorStub();
        this.createDelegationSpecifierList();
        this.typeStubBuilder.createTypeConstraintListStub(this.classOrObjectStub, typeConstraintListData);
        this.createClassBodyAndMemberStubs();
    }

    private final StubElement<? extends PsiElement> createClassOrObjectStubAndModifierListStub() {
        StubElement<? extends PsiElement> classOrObjectStub = this.doCreateClassOrObjectStub();
        KotlinModifierListStubImpl modifierList = this.createModifierListForClass(classOrObjectStub);
        if (Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags()).booleanValue()) {
            List<ClassId> list2 = this.c.getComponents().getAnnotationLoader().loadClassAnnotations(this.classProto, this.c.getNameResolver());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"c.components.annotationL\u2026assProto, c.nameResolver)");
            ClsStubBuildingKt.createAnnotationStubs(list2, modifierList);
        }
        return classOrObjectStub;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KotlinModifierListStubImpl createModifierListForClass(StubElement<? extends PsiElement> parent2) {
        List list2;
        ArrayList relevantFlags;
        block7: {
            block6: {
                relevantFlags = CollectionsKt.arrayListOf((Object[])new FlagsToModifiers[]{FlagsToModifiers.VISIBILITY});
                if (this.isClass()) {
                    relevantFlags.add(FlagsToModifiers.INNER);
                    relevantFlags.add(FlagsToModifiers.DATA);
                    relevantFlags.add(FlagsToModifiers.MODALITY);
                }
                ProtoBuf.Class.Kind kind2 = this.classKind;
                if (kind2 == null) break block6;
                switch (ClassClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                    case 1: {
                        list2 = CollectionsKt.listOf((Object)((Object)KtTokens.ENUM_KEYWORD));
                        break block7;
                    }
                    case 2: {
                        list2 = CollectionsKt.listOf((Object)((Object)KtTokens.COMPANION_KEYWORD));
                        break block7;
                    }
                    case 3: {
                        list2 = CollectionsKt.listOf((Object)((Object)KtTokens.ANNOTATION_KEYWORD));
                        break block7;
                    }
                }
            }
            list2 = CollectionsKt.emptyList();
        }
        List additionalModifiers = list2;
        return ClsStubBuildingKt.createModifierListStubForDeclaration(parent2, this.classProto.getFlags(), relevantFlags, additionalModifiers);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final StubElement<? extends PsiElement> doCreateClassOrObjectStub() {
        StubElement stubElement;
        Collection destination$iv$iv;
        ClassId it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean isCompanionObject = Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.COMPANION_OBJECT));
        FqName fqName2 = this.classId.asSingleFqName();
        StringRef shortName = ClsStubBuildingKt.ref(fqName2.shortName());
        Iterable iterable = this.supertypeIds;
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ClassId)element$iv$iv;
            FqNameUnsafe fqNameUnsafe = it.asSingleFqName().toUnsafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"it.asSingleFqName().toUnsafe()");
            if (FunctionTypesKt.isNumberedFunctionClassFqName(fqNameUnsafe)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ClassId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            StringRef stringRef = ClsStubBuildingKt.ref(it.getShortClassName());
            collection2.add(stringRef);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        StringRef[] stringRefArray = thisCollection$iv.toArray(new StringRef[thisCollection$iv.size()]);
        if (stringRefArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StringRef[] superTypeRefs = (StringRef[])((Object[])stringRefArray);
        ProtoBuf.Class.Kind kind2 = this.classKind;
        if (kind2 != null) {
            switch (ClassClsStubBuilder$WhenMappings.$EnumSwitchMapping$1[kind2.ordinal()]) {
                case 1: 
                case 2: {
                    stubElement = (StubElement)new KotlinObjectStubImpl(this.parentStub, shortName, fqName2, superTypeRefs, !this.classId.isNestedClass(), isCompanionObject, false, false);
                    return stubElement;
                }
            }
        }
        KtClassElementType ktClassElementType = KtClassElementType.getStubType(Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.ENUM_ENTRY)));
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktClassElementType), (String)"KtClassElementType.getSt\u2026uf.Class.Kind.ENUM_ENTRY)");
        stubElement = (StubElement)new KotlinClassStubImpl(ktClassElementType, this.parentStub, ClsStubBuildingKt.ref(fqName2), shortName, superTypeRefs, Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.INTERFACE)), Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.ENUM_ENTRY)), false, !this.classId.isNestedClass());
        return stubElement;
    }

    private final void createConstructorStub() {
        Object v0;
        block3: {
            if (!this.isClass()) {
                return;
            }
            Iterable iterable = this.classProto.getConstructorList();
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                ProtoBuf.Constructor it = (ProtoBuf.Constructor)t;
                if (!(Flags.IS_SECONDARY.get(it.getFlags()) == false)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ProtoBuf.Constructor constructor = v0;
        if (constructor == null) {
            return;
        }
        ProtoBuf.Constructor primaryConstructorProto = constructor;
        CallableClsStubBuilderKt.createConstructorStub(this.classOrObjectStub, primaryConstructorProto, this.c, this.thisAsProtoContainer);
    }

    private final void createDelegationSpecifierList() {
        if (this.supertypeIds.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl delegationSpecifierListStub = new KotlinPlaceHolderStubImpl((StubElement)this.classOrObjectStub, KtStubElementTypes.SUPER_TYPE_LIST);
        Iterable $receiver$iv = ProtoTypeTableUtilKt.supertypes(this.classProto, this.c.getTypeTable());
        for (Object element$iv : $receiver$iv) {
            ProtoBuf.Type type2 = (ProtoBuf.Type)element$iv;
            KotlinPlaceHolderStubImpl superClassStub = new KotlinPlaceHolderStubImpl(delegationSpecifierListStub, KtStubElementTypes.SUPER_TYPE_ENTRY);
            this.typeStubBuilder.createTypeReferenceStub(superClassStub, type2);
        }
    }

    private final void createClassBodyAndMemberStubs() {
        KotlinPlaceHolderStubImpl<KtClassBody> classBody = new KotlinPlaceHolderStubImpl<KtClassBody>((StubElement)this.classOrObjectStub, KtStubElementTypes.CLASS_BODY);
        this.createEnumEntryStubs(classBody);
        this.createCompanionObjectStub(classBody);
        this.createCallableMemberStubs(classBody);
        this.createInnerAndNestedClasses(classBody);
    }

    private final void createCompanionObjectStub(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        if (this.companionObjectName == null) {
            return;
        }
        ClassId companionObjectId = this.classId.createNestedClassId(this.companionObjectName);
        StubElement stubElement = classBody;
        ClassId classId = companionObjectId;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"companionObjectId");
        this.createNestedClassStub((StubElement<? extends PsiElement>)stubElement, classId);
    }

    /*
     * WARNING - void declaration
     */
    private final void createEnumEntryStubs(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        if (Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.ENUM_CLASS)) ^ true) {
            return;
        }
        Iterable $receiver$iv = this.classProto.getEnumEntryList();
        for (Object element$iv : $receiver$iv) {
            KtClassElementType ktClassElementType;
            void elements$iv;
            KotlinClassStubImpl kotlinClassStubImpl;
            ProtoBuf.EnumEntry entry = (ProtoBuf.EnumEntry)element$iv;
            Name name2 = this.c.getNameResolver().getName(entry.getName());
            List<ClassId> annotations2 = this.c.getComponents().getAnnotationLoader().loadEnumEntryAnnotations(this.thisAsProtoContainer, entry);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)KtStubElementTypes.ENUM_ENTRY), (String)"KtStubElementTypes.ENUM_ENTRY");
            Object object = new StringRef[]{};
            StringRef stringRef = ClsStubBuildingKt.ref(name2);
            StringRef stringRef2 = ClsStubBuildingKt.ref(this.c.getContainerFqName().child(name2));
            StubElement stubElement = classBody;
            KotlinClassStubImpl kotlinClassStubImpl2 = kotlinClassStubImpl;
            KotlinClassStubImpl kotlinClassStubImpl3 = kotlinClassStubImpl;
            Object[] objectArray = (Object[])elements$iv;
            kotlinClassStubImpl2(ktClassElementType, (StubElement<? extends PsiElement>)stubElement, stringRef2, stringRef, (StringRef[])objectArray, false, true, false, false);
            KotlinClassStubImpl enumEntryStub = kotlinClassStubImpl3;
            object = annotations2;
            if (!(!object.isEmpty())) continue;
            List<ClassId> list2 = annotations2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotations");
            ClsStubBuildingKt.createAnnotationStubs(list2, ClsStubBuildingKt.createEmptyModifierListStub(enumEntryStub));
        }
    }

    private final void createCallableMemberStubs(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        for (ProtoBuf.Constructor secondaryConstructorProto : this.classProto.getConstructorList()) {
            if (!Flags.IS_SECONDARY.get(secondaryConstructorProto.getFlags()).booleanValue()) continue;
            StubElement stubElement = classBody;
            ProtoBuf.Constructor constructor = secondaryConstructorProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)constructor, (String)"secondaryConstructorProto");
            CallableClsStubBuilderKt.createConstructorStub((StubElement<? extends PsiElement>)stubElement, constructor, this.c, this.thisAsProtoContainer);
        }
        StubElement stubElement = classBody;
        ProtoContainer protoContainer = this.thisAsProtoContainer;
        List<ProtoBuf.Function> list2 = this.classProto.getFunctionList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.functionList");
        List<ProtoBuf.Property> list3 = this.classProto.getPropertyList();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classProto.propertyList");
        CallableClsStubBuilderKt.createCallableStubs((StubElement<? extends PsiElement>)stubElement, this.c, protoContainer, list2, list3);
    }

    private final boolean isClass() {
        return Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.CLASS)) || Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.ENUM_CLASS)) || Intrinsics.areEqual((Object)((Object)this.classKind), (Object)((Object)ProtoBuf.Class.Kind.ANNOTATION_CLASS));
    }

    private final void createInnerAndNestedClasses(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        Iterable $receiver$iv = this.classProto.getNestedClassNameList();
        for (Object element$iv : $receiver$iv) {
            Integer id = (Integer)element$iv;
            Name nestedClassName = this.c.getNameResolver().getName(((Number)id).intValue());
            if (!(Intrinsics.areEqual((Object)nestedClassName, (Object)this.companionObjectName) ^ true)) continue;
            ClassId nestedClassId = this.classId.createNestedClassId(nestedClassName);
            StubElement stubElement = classBody;
            ClassId classId = nestedClassId;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nestedClassId");
            this.createNestedClassStub((StubElement<? extends PsiElement>)stubElement, classId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createNestedClassStub(StubElement<? extends PsiElement> classBody, ClassId nestedClassId) {
        void nameResolver;
        void classProto;
        ClassDataWithSource classDataWithSource = this.c.getComponents().getClassDataFinder().findClassData(nestedClassId);
        if (classDataWithSource == null) {
            void $receiver$iv;
            VirtualFile rootFile = this.c.getComponents().getVirtualFileForDebug();
            Object[] objectArray = rootFile.getParent().getChildren();
            StringBuilder stringBuilder = new StringBuilder().append("Could not find class data for nested class " + nestedClassId + " of class " + nestedClassId.getOuterClassId() + "\n").append("Root file: " + rootFile.getCanonicalPath() + "\n").append("Dir: " + rootFile.getParent().getCanonicalPath() + "\n").append("Children:\n");
            Logger logger = ClassClsStubBuilder.Companion.getLOG();
            void var6_10 = $receiver$iv;
            Comparator comparator = new Comparator<VirtualFile>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    VirtualFile it = (VirtualFile)a;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            List list2 = ArraysKt.sortedWith((Object[])var6_10, (Comparator)comparator);
            logger.error(stringBuilder.append(String.valueOf(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, (Function1)createNestedClassStub.2.INSTANCE, (int)30, null))).toString());
            return;
        }
        ClassData classData = classDataWithSource.getClassData();
        NameResolver rootFile = classData.component1();
        ProtoBuf.Class $receiver$iv = classData.component2();
        classData = null;
        ClassClsStubBuilderKt.createClassStub(classBody, (ProtoBuf.Class)classProto, (NameResolver)nameResolver, nestedClassId, this.c);
    }

    /*
     * WARNING - void declaration
     */
    public ClassClsStubBuilder(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver, @NotNull ClassId classId, @NotNull ClsStubBuilderContext outerContext) {
        ClassKind classKind;
        ProtoContainer.Class clazz;
        boolean bl;
        void destination$iv$iv;
        void $receiver$iv$iv;
        ClassId $receiver$iv;
        Intrinsics.checkParameterIsNotNull(parentStub, (String)"parentStub");
        Intrinsics.checkParameterIsNotNull((Object)classProto, (String)"classProto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        this.parentStub = parentStub;
        this.classProto = classProto;
        this.nameResolver = nameResolver;
        this.classId = classId;
        this.outerContext = outerContext;
        this.classKind = Flags.CLASS_KIND.get(this.classProto.getFlags());
        List<ProtoBuf.TypeParameter> list2 = this.classProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.typeParameterList");
        Name name2 = this.classId.getShortClassName();
        ProtoBuf.TypeTable typeTable = this.classProto.getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
        this.c = ClsStubBuilderContextKt.child(this.outerContext, list2, this.classKind, name2, this.nameResolver, new TypeTable(typeTable));
        this.typeStubBuilder = new TypeClsStubBuilder(this.c);
        Object object = this;
        ClassClsStubBuilder classClsStubBuilder = this;
        ClassClsStubBuilder $receiver = object;
        Iterable iterable = ProtoTypeTableUtilKt.supertypes($receiver.classProto, $receiver.c.getTypeTable());
        void var9_10 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$receiver$iv), (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
            void var14_15 = destination$iv$iv;
            ClassId classId2 = $receiver.c.getNameResolver().getClassId(it.getClassName());
            var14_15.add(classId2);
        }
        List supertypeIds = (List)destination$iv$iv;
        ClassId classId3 = (ClassId)CollectionsKt.singleOrNull((List)supertypeIds);
        if (classId3 != null) {
            $receiver$iv = classId3;
            ClassId it = $receiver$iv;
            bl = Intrinsics.areEqual((Object)KotlinBuiltIns.FQ_NAMES.any, (Object)it.asSingleFqName().toUnsafe());
        } else {
            bl = false;
        }
        Object object2 = bl ? CollectionsKt.emptyList() : supertypeIds;
        classClsStubBuilder.supertypeIds = object2;
        this.companionObjectName = this.classProto.hasCompanionObjectName() ? this.c.getNameResolver().getName(this.classProto.getCompanionObjectName()) : (Name)null;
        ClassClsStubBuilder classClsStubBuilder2 = this;
        ProtoContainer.Class clazz2 = clazz;
        Object object3 = clazz;
        ProtoBuf.Class clazz3 = this.classProto;
        NameResolver nameResolver2 = this.c.getNameResolver();
        TypeTable typeTable2 = this.c.getTypeTable();
        ProtoBuf.Class.Kind kind2 = this.outerContext.getClassKind();
        if (kind2 != null) {
            object = kind2;
            TypeTable typeTable3 = typeTable2;
            NameResolver nameResolver3 = nameResolver2;
            ProtoBuf.Class clazz4 = clazz3;
            ProtoContainer.Class clazz5 = clazz2;
            object2 = object3;
            classClsStubBuilder = classClsStubBuilder2;
            ProtoBuf.Class.Kind it = (ProtoBuf.Class.Kind)((Object)object);
            ClassKind classKind2 = Deserialization.classKind(it);
            classClsStubBuilder2 = classClsStubBuilder;
            object3 = object2;
            clazz2 = clazz5;
            clazz3 = clazz4;
            nameResolver2 = nameResolver3;
            typeTable2 = typeTable3;
            classKind = classKind2;
        } else {
            classKind = null;
        }
        clazz2(clazz3, nameResolver2, typeTable2, classKind);
        classClsStubBuilder2.thisAsProtoContainer = object3;
        this.classOrObjectStub = this.createClassOrObjectStubAndModifierListStub();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ClassClsStubBuilder.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClassClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

