/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinInvalidBundleOrPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "kotlin.jvm.PlatformType", "idea"})
public final class KotlinInvalidBundleOrPropertyInspection
extends AbstractKotlinInspection {
    public String getDisplayName() {
        return CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            private final void processResourceBundleReference(ResourceBundleReference ref, KtStringTemplateExpression template) {
                if (ref.resolve() == null) {
                    this.$holder.registerProblem((PsiElement)template, CodeInsightBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])new Object[]{ref.getCanonicalText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template.getTextLength()), new LocalQuickFix[0]);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void processPropertyReference(PropertyReference ref, KtStringTemplateExpression template) {
                int keyArgumentIndex;
                List<ResolvedValueArgument> resolvedArguments;
                ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                Property property2;
                block19: {
                    int n;
                    void $receiver$iv;
                    void $receiver$iv2;
                    Object v2;
                    block18: {
                        void $receiver$iv3;
                        PsiElement psiElement = ref.resolve();
                        if (!(psiElement instanceof Property)) {
                            psiElement = null;
                        }
                        if ((property2 = (Property)psiElement) == null) {
                            LocalQuickFix[] localQuickFixArray = ref.getQuickFixes();
                            this.$holder.registerProblem((PsiElement)template, CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])new Object[]{ref.getCanonicalText()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template.getTextLength()), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                            return;
                        }
                        Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents((PsiElement)template);
                        for (E element$iv : $receiver$iv3) {
                            if (!(element$iv instanceof KtValueArgument)) continue;
                            v2 = element$iv;
                            break block18;
                        }
                        v2 = null;
                    }
                    KtValueArgument ktValueArgument = v2;
                    if (ktValueArgument == null) {
                        return;
                    }
                    KtValueArgument argument2 = ktValueArgument;
                    if (Intrinsics.areEqual((Object)argument2.getArgumentExpression(), (Object)KtPsiUtil.deparenthesize(template)) ^ true) {
                        return;
                    }
                    Iterator iterator2 = (PsiElement)argument2;
                    KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallExpression.class, (boolean)true);
                    if (ktCallExpression == null) {
                        return;
                    }
                    KtCallExpression callExpression2 = ktCallExpression;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(callExpression2, ResolutionUtils.analyze(callExpression2, BodyResolveMode.PARTIAL));
                    if (resolvedCall3 == null) {
                        return;
                    }
                    resolvedCall2 = resolvedCall3;
                    List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
                    if (list2 == null) {
                        return;
                    }
                    List<ResolvedValueArgument> list3 = resolvedArguments = list2;
                    IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv));
                    int n2 = intRange.getFirst();
                    int n3 = intRange.getLast();
                    if (n2 <= n3) {
                        while (true) {
                            void index$iv;
                            ResolvedValueArgument it;
                            if ((it = (ResolvedValueArgument)$receiver$iv.get((int)index$iv)) instanceof ExpressionValueArgument && Intrinsics.areEqual((Object)((ExpressionValueArgument)it).getValueArgument(), (Object)argument2)) {
                                n = index$iv;
                                break block19;
                            }
                            if (index$iv == n3) break;
                            ++index$iv;
                        }
                    }
                    n = keyArgumentIndex = -1;
                }
                if (keyArgumentIndex < 0) {
                    return;
                }
                CallableDescriptor callable = resolvedCall2.getResultingDescriptor();
                if (callable.getValueParameters().size() != keyArgumentIndex + 2) {
                    return;
                }
                ResolvedValueArgument resolvedValueArgument = resolvedArguments.get(keyArgumentIndex + 1);
                if (!(resolvedValueArgument instanceof VarargValueArgument)) {
                    resolvedValueArgument = null;
                }
                VarargValueArgument varargValueArgument = (VarargValueArgument)resolvedValueArgument;
                if (varargValueArgument == null) {
                    return;
                }
                VarargValueArgument messageArgument = varargValueArgument;
                ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(messageArgument.getArguments());
                if ((valueArgument != null ? valueArgument.getSpreadElement() : null) != null) {
                    return;
                }
                String string = property2.getValue();
                if (string == null) {
                    string = "";
                }
                int expectedArgumentCount = JavaI18nUtil.getPropertyValuePlaceholdersCount((String)string);
                int actualArgumentCount = messageArgument.getArguments().size();
                if (actualArgumentCount < expectedArgumentCount) {
                    String description = CodeInsightBundle.message((String)"property.has.more.parameters.than.passed", (Object[])new Object[]{ref.getCanonicalText(), expectedArgumentCount, actualArgumentCount});
                    this.$holder.registerProblem((PsiElement)template, description, ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }

            public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                PsiReference[] psiReferenceArray = expression2.getReferences();
                for (int i = 0; i < psiReferenceArray.length; ++i) {
                    PsiReference ref = psiReferenceArray[i];
                    PsiReference psiReference = ref;
                    if (psiReference instanceof ResourceBundleReference) {
                        this.processResourceBundleReference((ResourceBundleReference)ref, expression2);
                        continue;
                    }
                    if (!(psiReference instanceof PropertyReference)) continue;
                    this.processPropertyReference((PropertyReference)ref, expression2);
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

