/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.kdoc.KDocRenderer;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0016\u001a\u00020\u0004*\u00020\u0004J\n\u0010\u0017\u001a\u00020\u0004*\u00020\u0018J\n\u0010\u0019\u001a\u00020\f*\u00020\u000fJ*\u0010\u001a\u001a\u00020\f*\u00020\u00182\u001e\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001d\u0012\u0004\u0012\u00020\f0\u001c\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer;", "", "()V", "markdownToHtml", "", "markdown", "allowSingleParagraph", "", "renderKDoc", "docComment", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "renderSeeAlso", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "to", "Ljava/lang/StringBuilder;", "renderTag", "tag", "title", "renderTagList", "tags", "", "htmlEscape", "toHtml", "Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "trimEnd", "visit", "action", "Lkotlin/Function2;", "Lkotlin/Function0;", "MarkdownNode", "idea"})
public final class KDocRenderer {
    public static final KDocRenderer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderKDoc(@NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)docComment), (String)"docComment");
        String content2 = docComment.getContent();
        StringBuilder result2 = new StringBuilder();
        result2.append(this.markdownToHtml(content2, true));
        if (docComment instanceof KDocSection) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            void destination$iv$iv2;
            Iterable $receiver$iv$iv2;
            void $receiver$iv2;
            result2.append("\n");
            Iterable iterable = ((KDocSection)docComment).findTagsByName("param");
            void var6_5 = $receiver$iv2;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                KDocTag it = (KDocTag)((Object)element$iv$iv);
                if (!(it.getSubjectName() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List paramTags = (List)destination$iv$iv2;
            this.renderTagList(paramTags, "Parameters", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("return"), "Returns", result2);
            $receiver$iv$iv2 = CollectionsKt.union((Iterable)((KDocSection)docComment).findTagsByName("exception"), (Iterable)((KDocSection)docComment).findTagsByName("throws"));
            destination$iv$iv2 = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KDocTag it = (KDocTag)((Object)element$iv$iv);
                if (!(it.getSubjectName() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List throwsTags = (List)destination$iv$iv;
            this.renderTagList(throwsTags, "Throws", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("author"), "Author", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("since"), "Since", result2);
            this.renderSeeAlso((KDocSection)docComment, result2);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSeeAlso(KDocSection docComment, StringBuilder to) {
        void $receiver$iv;
        List<KDocTag> seeTags = docComment.findTagsByName("see");
        if (seeTags.isEmpty()) {
            return;
        }
        to.append("<DD><DL>");
        to.append("<DT><b>").append("See Also:").append("</b>");
        to.append("<DD>");
        Iterable iterable = seeTags;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void tag;
            int n = index$iv++;
            KDocTag kDocTag = (KDocTag)((Object)item$iv);
            int index2 = n;
            String subjectName = tag.getSubjectName();
            if (subjectName != null) {
                DocumentationManagerUtil.createHyperlink((StringBuilder)to, (String)subjectName, (String)subjectName, (boolean)false);
            } else {
                to.append(tag.getContent());
            }
            if (index2 >= seeTags.size() - 1) continue;
            to.append(", ");
        }
        to.append("</DD></DL></DD>");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTagList(List<? extends KDocTag> tags, String title, StringBuilder to) {
        void $receiver$iv;
        if (tags.isEmpty()) {
            return;
        }
        to.append("<dl><dt><b>" + title + ":</b></dt>");
        Iterable iterable = tags;
        for (Object element$iv : $receiver$iv) {
            KDocTag it = (KDocTag)((Object)element$iv);
            String string = it.getContent();
            KDocRenderer kDocRenderer = INSTANCE;
            StringBuilder stringBuilder = new StringBuilder().append("<dd><code>").append(it.getSubjectName()).append("</code> - ");
            StringBuilder stringBuilder2 = to;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
            stringBuilder2.append(stringBuilder.append(KDocRenderer.markdownToHtml$default(kDocRenderer, string3, false, 2, null)).append("</dd>").toString());
        }
        to.append("</dl>\n");
    }

    private final void renderTag(KDocTag tag, String title, StringBuilder to) {
        if (tag != null) {
            to.append("<dl><dt><b>" + title + ":</b></dt>");
            to.append("<dd>" + KDocRenderer.markdownToHtml$default(this, tag.getContent(), false, 2, null) + "</dd>");
            to.append("</dl>\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String markdownToHtml(@NotNull String markdown, boolean allowSingleParagraph) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
        ASTNode markdownTree = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor()).buildMarkdownTreeFromString(markdown);
        MarkdownNode markdownNode = new MarkdownNode(markdownTree, null, markdown);
        Iterable iterable = markdownNode.getChildren();
        void var7_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MarkdownNode it = (MarkdownNode)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        MarkdownNode maybeSingleParagraph = (MarkdownNode)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (maybeSingleParagraph != null && !allowSingleParagraph) {
            return CollectionsKt.joinToString$default((Iterable)maybeSingleParagraph.getChildren(), (CharSequence)"", null, null, (int)0, null, (Function1)markdownToHtml.1.INSTANCE, (int)30, null);
        }
        return this.toHtml(markdownNode);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String markdownToHtml$default(KDocRenderer kDocRenderer, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: markdownToHtml");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return kDocRenderer.markdownToHtml(string, bl);
    }

    public final void visit(@NotNull MarkdownNode $receiver, @NotNull Function2<? super MarkdownNode, ? super Function0<Unit>, Unit> action2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        action2.invoke((Object)$receiver, (Object)new Function0<Unit>($receiver, action2){
            final /* synthetic */ MarkdownNode receiver$0;
            final /* synthetic */ Function2 $action;

            public final void invoke() {
                for (MarkdownNode child : this.receiver$0.getChildren()) {
                    KDocRenderer.INSTANCE.visit(child, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)this.$action);
                }
            }
            {
                this.receiver$0 = markdownNode;
                this.$action = function2;
                super(0);
            }
        });
    }

    @NotNull
    public final String toHtml(@NotNull MarkdownNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder sb = new StringBuilder();
        this.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@NotNull MarkdownNode node, @NotNull Function0<Unit> processChildren) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull(processChildren, (String)"processChildren");
                Function2<String, Boolean, Unit> wrapChildren$ = new Function2<String, Boolean, Unit>(this, processChildren){
                    final /* synthetic */ toHtml.1 this$0;
                    final /* synthetic */ Function0 $processChildren;

                    public final void invoke(@NotNull String tag, boolean newline) {
                        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                        this.this$0.$sb.append("<" + tag + ">");
                        this.$processChildren.invoke();
                        this.this$0.$sb.append("</" + tag + ">");
                        if (newline) {
                            StringsKt.appendln((StringBuilder)this.this$0.$sb);
                        }
                    }

                    public static /* bridge */ /* synthetic */ void invoke$default(toHtml.1 var0, String string, boolean bl, int n, Object object) {
                        if (object != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invoke");
                        }
                        if ((n & 2) != 0) {
                            bl = false;
                        }
                        var0.invoke(string, bl);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$processChildren = function0;
                        super(2);
                    }
                };
                IElementType nodeType = node.getType();
                String nodeText = node.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    wrapChildren$.invoke("ul", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    wrapChildren$.invoke("ol", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
                    toHtml.1.invoke$default(wrapChildren$, "li", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
                    toHtml.1.invoke$default(wrapChildren$, "em", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
                    toHtml.1.invoke$default(wrapChildren$, "strong", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
                    toHtml.1.invoke$default(wrapChildren$, "h1", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
                    toHtml.1.invoke$default(wrapChildren$, "h2", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
                    toHtml.1.invoke$default(wrapChildren$, "h3", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
                    toHtml.1.invoke$default(wrapChildren$, "h4", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
                    toHtml.1.invoke$default(wrapChildren$, "h5", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
                    toHtml.1.invoke$default(wrapChildren$, "h6", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
                    toHtml.1.invoke$default(wrapChildren$, "blockquote", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
                    KDocRenderer.INSTANCE.trimEnd(this.$sb);
                    wrapChildren$.invoke("p", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
                    toHtml.1.invoke$default(wrapChildren$, "code", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    KDocRenderer.INSTANCE.trimEnd(this.$sb);
                    this.$sb.append("<pre><code>");
                    processChildren.invoke();
                    this.$sb.append("</code><pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK)) {
                    String label;
                    MarkdownNode markdownNode = node.child(MarkdownElementTypes.LINK_LABEL);
                    String string = markdownNode != null && (markdownNode = markdownNode.child(MarkdownTokenTypes.TEXT)) != null ? markdownNode.getText() : (label = null);
                    if (label != null) {
                        Object object = node.child(MarkdownElementTypes.LINK_TEXT);
                        if (object == null || (object = ((MarkdownNode)object).child(MarkdownTokenTypes.TEXT)) == null || (object = ((MarkdownNode)object).getText()) == null) {
                            object = label;
                        }
                        Object linkText = object;
                        DocumentationManagerUtil.createHyperlink((StringBuilder)this.$sb, (String)label, (String)linkText, (boolean)true);
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    String destination;
                    MarkdownNode markdownNode = node.child(MarkdownElementTypes.LINK_TEXT);
                    String label = markdownNode != null && (markdownNode = markdownNode.child(MarkdownTokenTypes.TEXT)) != null ? markdownNode.getText() : null;
                    MarkdownNode markdownNode2 = node.child(MarkdownElementTypes.LINK_DESTINATION);
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label != null && destination != null) {
                        this.$sb.append("<a href=" + "\"" + destination + "\"" + ">" + KDocRenderer.INSTANCE.htmlEscape(label) + "</a>");
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                    this.$sb.append(nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    IElementType parentType;
                    MarkdownNode markdownNode = node.getParent();
                    Object object = parentType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                        this.$sb.append("\n");
                    } else {
                        this.$sb.append(" ");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) {
                    this.$sb.append("&gt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) {
                    this.$sb.append("&lt;");
                } else {
                    processChildren.invoke();
                }
            }
            {
                this.$sb = stringBuilder;
                super(2);
            }
        }));
        String string = sb.toString();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    public final void trimEnd(@NotNull StringBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        while ($receiver.length() > 0 && $receiver.charAt($receiver.length() - 1) == ' ') {
            $receiver.deleteCharAt($receiver.length() - 1);
        }
    }

    @NotNull
    public final String htmlEscape(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    private KDocRenderer() {
        INSTANCE = this;
    }

    static {
        new KDocRenderer();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "parent", "markdown", "", "(Lorg/intellij/markdown/ast/ASTNode;Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;Ljava/lang/String;)V", "children", "", "getChildren", "()Ljava/util/List;", "endOffset", "", "getEndOffset", "()I", "getMarkdown", "()Ljava/lang/String;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getParent", "()Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "startOffset", "getStartOffset", "text", "getText", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "child", "idea"})
    public static final class MarkdownNode {
        @NotNull
        private final List<MarkdownNode> children;
        @NotNull
        private final ASTNode node;
        @Nullable
        private final MarkdownNode parent;
        @NotNull
        private final String markdown;

        @NotNull
        public final List<MarkdownNode> getChildren() {
            return this.children;
        }

        public final int getEndOffset() {
            return this.node.getEndOffset();
        }

        public final int getStartOffset() {
            return this.node.getStartOffset();
        }

        @NotNull
        public final IElementType getType() {
            return this.node.getType();
        }

        @NotNull
        public final String getText() {
            String string = this.markdown;
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        @Nullable
        public final MarkdownNode child(@NotNull IElementType type2) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Iterable $receiver$iv = this.children;
                for (Object element$iv : $receiver$iv) {
                    MarkdownNode it = (MarkdownNode)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)type2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @Nullable
        public final MarkdownNode getParent() {
            return this.parent;
        }

        @NotNull
        public final String getMarkdown() {
            return this.markdown;
        }

        /*
         * WARNING - void declaration
         */
        public MarkdownNode(@NotNull ASTNode node, @Nullable MarkdownNode parent2, @NotNull String markdown) {
            List list2;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            this.node = node;
            this.parent = parent2;
            this.markdown = markdown;
            Iterable iterable = this.node.getChildren();
            MarkdownNode markdownNode = this;
            void var5_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                list2 = destination$iv$iv;
                MarkdownNode markdownNode2 = new MarkdownNode((ASTNode)it, this, this.markdown);
                list2.add(markdownNode2);
            }
            markdownNode.children = list2 = (List)destination$iv$iv;
        }
    }
}

