/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.psi.KtFile;

public class ProjectStructureUtil {
    private static final Key<CachedValue<Boolean>> IS_KOTLIN_JS_MODULE = Key.create((String)"IS_KOTLIN_JS_MODULE");

    private ProjectStructureUtil() {
    }

    public static boolean isJsKotlinModule(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isJsKotlinModule"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module != null && ProjectStructureUtil.isJsKotlinModule(module);
    }

    public static boolean isJsKotlinModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isJsKotlinModule"));
        }
        CachedValue result2 = (CachedValue)module.getUserData(IS_KOTLIN_JS_MODULE);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    return CachedValueProvider.Result.create((Object)(ProjectStructureUtil.getJSStandardLibrary(module) != null ? 1 : 0), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(IS_KOTLIN_JS_MODULE, (Object)result2);
        }
        return (Boolean)result2.getValue();
    }

    @Nullable
    private static Library getJSStandardLibrary(final Module module) {
        return (Library)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Library>(){

            public Library compute() {
                final Ref jsLibrary = Ref.create();
                ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().forEachLibrary((Processor)new Processor<Library>(){

                    public boolean process(Library library) {
                        if (JsLibraryStdDetectionUtil.hasJsStdlibJar(library)) {
                            jsLibrary.set((Object)library);
                            return false;
                        }
                        return true;
                    }
                });
                return (Library)jsLibrary.get();
            }
        });
    }
}

