/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.overrideImplement.ImplementMembersHandler;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeUtilsKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\"\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\n*\u00020\u0006H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/LetImplementInterfaceFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionType", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "expectedTypeName", "", "expectedTypeNameSourceCode", "prefix", "validExpectedType", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "renderShort", "idea"})
public final class LetImplementInterfaceFix
extends KotlinQuickFixAction<KtClassOrObject>
implements LowPriorityAction {
    private final String expectedTypeName;
    private final String expectedTypeNameSourceCode;
    private final String prefix;
    private final boolean validExpectedType;

    private final String renderShort(@NotNull KotlinType $receiver) {
        return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType($receiver);
    }

    @NotNull
    public String getFamilyName() {
        return "Let type implement interface";
    }

    @NotNull
    public String getText() {
        return this.prefix + " interface '" + this.expectedTypeName + "'";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        return this.validExpectedType;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtSuperTypeEntry superTypeEntry = KtPsiFactoryKt.KtPsiFactory(this.getElement()).createSuperTypeEntry(this.expectedTypeNameSourceCode);
        KtSuperTypeListEntry entryElement = ((KtClassOrObject)this.getElement()).addSuperTypeListEntry(superTypeEntry);
        ShortenReferences.process$default(ShortenReferences.DEFAULT, entryElement, null, 2, null);
        ImplementMembersHandler implementMembersHandler = new ImplementMembersHandler();
        if (implementMembersHandler.collectMembersToGenerate((KtClassOrObject)this.getElement()).isEmpty()) {
            return;
        }
        if (editor != null) {
            editor.getCaretModel().moveToOffset(((KtClassOrObject)this.getElement()).getTextRange().getStartOffset());
            PsiFile containingFile = ((KtClassOrObject)this.getElement()).getContainingFile();
            FileEditorManager.getInstance((Project)project).openFile(containingFile.getVirtualFile(), true);
            PsiFile psiFile = containingFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
            implementMembersHandler.invoke(project, editor, psiFile);
        }
    }

    /*
     * Unable to fully structure code
     */
    public LetImplementInterfaceFix(@NotNull KtClassOrObject element, @NotNull KotlinType expectedType, @NotNull KotlinType expressionType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        super((PsiElement)element);
        expectedTypeNotNullable = TypeUtils.makeNotNullable(expectedType);
        this.expectedTypeName = this.renderShort(expectedTypeNotNullable);
        v0 = expectedTypeNotNullable;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"expectedTypeNotNullable");
        this.expectedTypeNameSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(v0);
        verb = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.isInterface(expressionType) != false ? "extend" : "implement";
        typeDescription = KtPsiUtilKt.isObjectLiteral(element) != false ? "the anonymous object" : "'" + this.renderShort(expressionType) + "'";
        this.prefix = "Let " + typeDescription + " " + verb;
        var20_7 = this;
        $receiver = expectedType;
        if (!org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.isInterface($receiver) || TypeUtilsKt.containsStarProjections($receiver)) ** GOTO lbl-1000
        var8_9 = TypeUtils.getAllSupertypes(expressionType);
        var9_10 = $receiver$iv;
        var10_11 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            var13_14 = (KotlinType)item$iv$iv;
            var14_15 = destination$iv$iv;
            var15_16 = p1.getConstructor();
            var14_15.add(var15_16);
        }
        if (((List)destination$iv$iv).contains($receiver.getConstructor()) ^ true) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var20_7.validExpectedType = var21_17 = v1;
    }
}

