/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00050\u0005H\u0016J\u0010\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00050\u0005H\u0016J\u0010\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00050\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticInheritorRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;)V", "entityName", "kotlin.jvm.PlatformType", "getDialogDescription", "getDialogTitle", "idea"})
public final class AutomaticInheritorRenamer
extends AutomaticRenamer {
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.inheritors.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.inheritor");
    }

    public AutomaticInheritorRenamer(@NotNull KtClass klass, @NotNull String newName2) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        KtLightClass lightClass2 = LightClassUtilsKt.toLightClass(klass);
        if (lightClass2 != null) {
            for (PsiClass inheritorLightClass : ClassInheritorsSearch.search((PsiClass)lightClass2, (boolean)true).findAll()) {
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)inheritorLightClass);
                if (!(psiElement instanceof PsiNamedElement)) {
                    psiElement = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                if ((psiNamedElement != null ? psiNamedElement.getName() : null) == null) continue;
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)inheritorLightClass);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                }
                this.myElements.add((PsiNamedElement)psiElement2);
            }
        }
        this.suggestAllNames(klass.getName(), newName2);
    }
}

