/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.AS_KEYWORD, KtTokens.AS_SAFE});

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "<init>"));
        }
        super(facade);
    }

    private static boolean isLValueOrUnsafeReceiver(@NotNull KtSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isLValueOrUnsafeReceiver"));
        }
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{KtParenthesizedExpression.class});
        if (parent2 instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            return qualifiedExpression.getOperationSign() == KtTokens.DOT && qualifiedExpression.getReceiverExpression() == KtPsiUtil.deparenthesize(expression2);
        }
        if (parent2 instanceof KtBinaryExpression) {
            KtBinaryExpression binaryExpression = (KtBinaryExpression)parent2;
            if (!OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)binaryExpression.getOperationToken()) && !KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)binaryExpression.getLeft(), (PsiElement)expression2, (boolean)false);
        }
        return false;
    }

    private static boolean isDangerousWithNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isDangerousWithNull"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isDangerousWithNull"));
        }
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{KtParenthesizedExpression.class});
        if (parent2 instanceof KtUnaryExpression) {
            KtUnaryExpression unaryExpression = (KtUnaryExpression)parent2;
            return unaryExpression.getOperationToken() == KtTokens.EXCLEXCL;
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            KtBinaryExpressionWithTypeRHS binaryExpression = (KtBinaryExpressionWithTypeRHS)parent2;
            KotlinType type2 = context.trace.get(BindingContext.TYPE, binaryExpression.getRight());
            return type2 != null && !type2.isMarkedNullable() && binaryExpression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
        }
        return false;
    }

    private static void checkNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context, @Nullable KotlinType type2) {
        DataFlowValue dataFlowValue;
        Nullability nullability;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkNull"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkNull"));
        }
        if (type2 != null && !type2.isError() && !BasicExpressionTypingVisitor.isLValueOrUnsafeReceiver(expression2) && !(nullability = context.dataFlowInfo.getPredictableNullability(dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, context))).canBeNonNull() && nullability.canBeNull()) {
            if (BasicExpressionTypingVisitor.isDangerousWithNull(expression2, context)) {
                context.trace.report(Errors.ALWAYS_NULL.on(expression2));
            } else {
                context.trace.record(BindingContext.SMARTCAST_NULL, expression2);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSimpleNameExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        KotlinTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression2, null, null, context);
        BasicExpressionTypingVisitor.checkNull(expression2, context, typeInfo.getType());
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (KtExpression)expression2, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitParenthesizedExpression"));
        }
        KtExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KotlinTypeInfo result2 = this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context.replaceScope(context.scope));
        KotlinType resultType = result2.getType();
        if (resultType != null) {
            DataFlowValue innerValue = DataFlowValueFactory.createDataFlowValue(innerExpression, resultType, context);
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(expression2, resultType, context);
            result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(resultValue, innerValue));
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression2, ExpressionTypingContext context) {
        ConstantValue constantValue;
        CompileTimeConstantChecker constantChecker;
        boolean hasError;
        CompileTimeConstant<?> compileTimeConstant;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitConstantExpression"));
        }
        IElementType elementType = expression2.getNode().getElementType();
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT || elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix((PsiElement)expression2, context);
        }
        if (!((compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, context.expectedType)) instanceof IntegerValueTypeConstant) && (hasError = (constantChecker = new CompileTimeConstantChecker(context, this.components.builtIns, false)).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression2, context.expectedType))) {
            return TypeInfoFactoryKt.createTypeInfo(this.getDefaultType(elementType), context);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression2.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression2, context);
    }

    @NotNull
    public KotlinType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == KtNodeTypes.INTEGER_CONSTANT) {
            KotlinType kotlinType = builtIns.getIntType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return kotlinType;
        }
        if (constantType == KtNodeTypes.FLOAT_CONSTANT) {
            KotlinType kotlinType = builtIns.getDoubleType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return kotlinType;
        }
        if (constantType == KtNodeTypes.BOOLEAN_CONSTANT) {
            KotlinType kotlinType = builtIns.getBooleanType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return kotlinType;
        }
        if (constantType == KtNodeTypes.CHARACTER_CONSTANT) {
            KotlinType kotlinType = builtIns.getCharType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return kotlinType;
        }
        if (constantType == KtNodeTypes.NULL) {
            KotlinType kotlinType = builtIns.getNullableNothingType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return kotlinType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression left = expression2.getLeft();
        KtTypeReference right = expression2.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, allowBareTypes, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        KotlinType subjectType = typeInfo.getType();
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression2, contextWithNoExpectedType, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == KtTokens.AS_KEYWORD) {
                DataFlowValue value2 = DataFlowValueFactory.createDataFlowValue(left, subjectType, context);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value2, targetType));
            }
        }
        KotlinType result2 = operationType == KtTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)context);
    }

    private void checkBinaryWithTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @Nullable KotlinType actualType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (actualType == null) {
            return;
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType != KtTokens.AS_KEYWORD && operationType != KtTokens.AS_SAFE) {
            context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression2, actualType, targetType, context);
    }

    private void checkForCastImpossibilityOrRedundancy(KtBinaryExpressionWithTypeRHS expression2, KotlinType actualType, KotlinType targetType, ExpressionTypingContext context) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || targetType.isError()) {
            return;
        }
        DeclarationsCheckerKt.checkNotEnumEntry(expression2.getRight(), context.trace);
        if (DynamicTypesKt.isDynamic(targetType)) {
            KtTypeReference right = expression2.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression2.getOperationReference()));
            return;
        }
        KotlinTypeChecker typeChecker2 = KotlinTypeChecker.DEFAULT;
        if (actualType.equals(targetType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
        Collection<KotlinType> possibleTypes = DataFlowAnalyzer.getAllPossibleTypes(expression2.getLeft(), context.dataFlowInfo, actualType, context);
        boolean checkExactType = BasicExpressionTypingVisitor.checkExactTypeForUselessCast(expression2);
        for (KotlinType possibleType : possibleTypes) {
            boolean castIsUseless = checkExactType ? possibleType.equals(targetType) : typeChecker2.isSubtypeOf(possibleType, targetType);
            if (!castIsUseless) continue;
            context.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker2)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression2, actualType, targetType));
        }
    }

    private static boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression2) {
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof KtValueArgument) {
            return true;
        }
        if (parent2 instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            return PsiTreeUtil.isAncestor((PsiElement)receiver, (PsiElement)expression2, (boolean)false);
        }
        return parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression;
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitThisExpression"));
        }
        KotlinType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression2));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.recordType(expression2.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSuperExpression"));
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, true);
        if (!KtPsiUtil.isLHSOfDot(expression2)) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression2, expression2.getText()));
            return this.errorInSuper(expression2, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression2, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression2));
                return this.errorInSuper(expression2, context);
            }
            case SUCCESS: {
                KotlinType result2 = this.checkPossiblyQualifiedSuper(expression2, context, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context.trace.recordType(expression2.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private KotlinTypeInfo errorInSuper(KtSuperExpression expression2, ExpressionTypingContext context) {
        KtTypeReference superTypeQualifier = expression2.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private KotlinType checkPossiblyQualifiedSuper(KtSuperExpression expression2, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver) {
        KtTypeReference superTypeQualifier;
        KotlinType thisType;
        KotlinType result2;
        block20: {
            TypeSubstitutor substitutor3;
            Collection<KotlinType> supertypes2;
            block17: {
                boolean validType;
                KtTypeArgumentList redundantTypeArguments;
                KotlinType supertype;
                ClassifierDescriptor classifierCandidate;
                block19: {
                    block18: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor3 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression2.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block17;
                        KtTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof KtUserType) {
                            KtUserType userType = (KtUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context.scope, userType, context.trace, context.isDebuggerContext);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (supertype == null) break block18;
                        if (!supertypes2.contains(supertype)) break block19;
                        result2 = supertype;
                        break block19;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (KotlinType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor3.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !supertype.isError();
                if (result2 == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on((PsiElement)redundantTypeArguments));
                }
                break block20;
            }
            if (UnqualifiedSuperKt.isPossiblyAmbiguousUnqualifiedSuper(expression2, supertypes2)) {
                Collection<KotlinType> supertypesResolvedFromContext = UnqualifiedSuperKt.resolveUnqualifiedSuperFromExpressionContext(expression2, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    KotlinType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor3.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression2));
                }
            } else {
                KotlinType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor3.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isInterface(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE.on(expression2));
            }
            context.trace.recordType(expression2.getInstanceReference(), result2);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
            context.trace.record(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2, thisType);
        }
        BindingContextUtilsKt.recordScope(context.trace, context.scope, superTypeQualifier);
        return result2;
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(KtInstanceExpressionWithLabel expression2, ExpressionTypingContext context, boolean onlyClassReceivers) {
        Name labelName = expression2.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression2, context, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context, receiverParameterDescriptor, expression2);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(null);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = ScopeUtilsKt.getImplicitReceiversHierarchy(context.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context, result2, expression2);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
        }
        return labeledReceiverResolutionResult;
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context, ReceiverParameterDescriptor descriptor2, KtExpression expression2) {
        BindingTrace trace = context.trace;
        Call call = CallMaker.makeCall(expression2, null, null, expression2, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call, descriptor2, null, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(context.dataFlowInfo, call));
        resolvedCall2.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call, resolvedCall2);
        trace.record(BindingContext.CALL, expression2, call);
        BasicCallResolutionContext resolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_CALLABLE_TYPE);
        for (CallChecker checker : this.components.callCheckers) {
            checker.check(resolvedCall2, resolutionContext);
        }
        this.components.symbolUsageValidator.validateCall(resolvedCall2, descriptor2, trace, (PsiElement)expression2);
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context, false);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitClassLiteralExpression"));
        }
        return this.components.doubleColonExpressionResolver.visitClassLiteralExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallableReferenceExpression"));
        }
        return this.components.doubleColonExpressionResolver.visitCallableReferenceExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(final @NotNull KtObjectLiteralExpression expression2, final ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitObjectLiteralExpression"));
        }
        final KotlinType[] result2 = new KotlinType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve object literal expression", expression2);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler2 = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor2) {
                if (slice == BindingContext.CLASS && declaration == expression2.getObjectDeclaration()) {
                    DeferredType defaultType2 = DeferredType.createRecursionIntolerant(BasicExpressionTypingVisitor.this.components.globalContext.getStorageManager(), context.trace, new Function0<KotlinType>(){

                        public KotlinType invoke() {
                            return descriptor2.getDefaultType();
                        }
                    });
                    result2[0] = defaultType2;
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler2);
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), expression2.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context.dataFlowInfo;
        for (KtSuperTypeListEntry specifier : expression2.getObjectDeclaration().getSuperTypeListEntries()) {
            KtSuperTypeCallEntry delegator;
            KotlinTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof KtSuperTypeCallEntry) || (delegatorTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (KtSuperTypeCallEntry)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryKt.createTypeInfo(result2[0], resultFlowInfo), (KtExpression)expression2, (ResolutionContext)context);
        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, resultTypeInfo);
        context.trace.record(BindingContext.PROCESSED, expression2);
        return resultTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitQualifiedExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression2, context);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression2, null, null, context);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitUnaryExpression"));
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression2, context);
        }
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context);
        KotlinType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(baseExpression, type2, context.trace.getBindingContext());
        Call call = CallMaker.makeCall((ReceiverValue)receiver, expression2);
        Name name2 = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get((Object)operationType);
        if (name2 == null) {
            context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && baseExpression instanceof KtArrayAccessExpression) {
            KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression2);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(temporaryBindingTrace);
            this.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)baseExpression, stubExpression, newContext, context.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context, call, expression2.getOperationReference(), name2)).isSuccess()) {
            return typeInfo.clearType();
        }
        KotlinType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                KotlinType receiverType = receiver.getType();
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name2.asString(), receiverType, returnType2));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
                    KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
                    this.checkLValue(context.trace, context, baseExpression, stubExpression, expression2);
                }
                DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue((ReceiverValue)call.getExplicitReceiver(), contextWithExpectedType);
                if (expression2 instanceof KtPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = DataFlowValueFactory.createDataFlowValue(expression2, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private KotlinTypeInfo visitExclExclExpression(@NotNull KtUnaryExpression expression2, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == KtTokens.EXCLEXCL);
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Collections.singletonList(baseExpression));
        this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL, Collections.singletonList("baseExpr"), Collections.singletonList(true), context, null);
        KotlinTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context)) {
            context.trace.report(Errors.NOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION.on((PsiElement)operationSign));
            if (baseTypeInfo == null) {
                return TypeInfoFactoryKt.createTypeInfo(ErrorUtils.createErrorType("Unresolved lambda expression"), context);
            }
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression2;
        KotlinType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context) && !baseType.isError()) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)operationSign, TypeUtils.makeNotNullable(baseType)));
        } else {
            DataFlowValue value2 = DataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value2, DataFlowValue.nullValue(this.components.builtIns)));
        }
        KotlinType resultingType = TypeUtils.makeNotNullable(baseType);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (KtExpression)expression2, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return this.visitLabeledExpression(expression2, context, false);
    }

    @NotNull
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull ExpressionTypingContext context, boolean isStatement) {
        KtExpression baseExpression;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        KtSimpleNameExpression labelExpression = expression2.getTargetLabel();
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE.checkIdentifier(labelIdentifier, context.trace);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(baseExpression, context, isStatement);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return kotlinTypeInfo;
    }

    private static boolean isKnownToBeNotNull(KtExpression expression2, ExpressionTypingContext context) {
        KotlinType type2 = context.trace.getType(expression2);
        assert (type2 != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression2, type2, context);
    }

    private static boolean isKnownToBeNotNull(KtExpression expression2, KotlinType jetType, ExpressionTypingContext context) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, jetType, context);
        return !context.dataFlowInfo.getPredictableNullability(dataFlowValue).canBeNull();
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull KtExpression expression2, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (operationExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        return this.checkLValue(trace, context, expression2, rightHandSide, operationExpression, false);
    }

    private boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull KtExpression expressionWithParenthesis, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression, boolean canBeThis) {
        KtExpression selector;
        KtExpression reportOn;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expressionWithParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionWithParenthesis", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (operationExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        KtExpression expression2 = KtPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression2 instanceof KtArrayAccessExpression) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)expression2;
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context.replaceBindingTrace(ignoreReportsTrace);
            KotlinTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
            IElementType operationType = operationExpression.getOperationReference().getReferencedNameElementType();
            if ((KtTokens.AUGMENTED_ASSIGNMENTS.contains(operationType) || operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && (resolvedCall2 = ignoreReportsTrace.get(BindingContext.INDEXED_LVALUE_SET, expression2)) != null) {
                FunctionDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                this.components.symbolUsageValidator.validateCall(resolvedCall2, descriptor2, trace, (PsiElement)expression2);
            }
            return info.getType() != null;
        }
        if (canBeThis && expression2 instanceof KtThisExpression) {
            return true;
        }
        VariableDescriptor variable2 = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression2, true);
        boolean result2 = true;
        KtExpression ktExpression = reportOn = expression2 != null ? expression2 : expressionWithParenthesis;
        if (reportOn instanceof KtQualifiedExpression && (selector = ((KtQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable2;
            PropertySetterDescriptor setter = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter != null) {
                this.components.symbolUsageValidator.validateCall(null, setter, trace, (PsiElement)reportOn);
            }
        }
        if (variable2 == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable2.isVar()) {
            result2 = false;
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo result2;
        Name referencedName;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryExpression"));
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get((Object)operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else {
            if (operationType == KtTokens.ELVIS) {
                return this.visitElvisExpression(expression2, context);
            }
            if (operationType == KtTokens.EQ) {
                result2 = this.visitAssignment(expression2, context);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitAssignmentOperation(expression2, context);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitComparison(expression2, context, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitEquality(expression2, context, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains((Object)operationType)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
                result2 = TypeInfoFactoryKt.createTypeInfo(this.components.builtIns.getBooleanType(), context);
            } else if (OperatorConventions.IN_OPERATIONS.contains((Object)operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression2, operationSign, leftArgument, right, context);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context);
            } else {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private KotlinTypeInfo visitEquality(KtBinaryExpression expression2, ExpressionTypingContext context, KtSimpleNameExpression operationSign, final KtExpression left, final KtExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return TypeInfoFactoryKt.createTypeInfo(this.components.builtIns.getBooleanType(), context);
        }
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        TemporaryBindingTrace traceInterpretingRightAsNullableAny = TemporaryBindingTrace.create(context.trace, "trace to resolve 'equals(Any?)' interpreting as of type Any? an expression:", right);
        traceInterpretingRightAsNullableAny.recordType(right, this.components.builtIns.getNullableAnyType());
        KotlinType leftType = leftTypeInfo.getType();
        if (leftType != null && KotlinBuiltIns.isNothingOrNullableNothing(leftType)) {
            traceInterpretingRightAsNullableAny.recordType(left, this.components.builtIns.getNullableAnyType());
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(traceInterpretingRightAsNullableAny);
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, newContext);
        Call call = CallMaker.makeCallWithExpressions(expression2, receiver, new KtPsiFactory(expression2.getProject()).createSafeCallNode(), operationSign, Collections.singletonList(right));
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveCallWithGivenName(newContext, call, operationSign, OperatorNameConventions.EQUALS);
        traceInterpretingRightAsNullableAny.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                if ((key == right || key == left) && slice == BindingContext.EXPRESSION_TYPE_INFO) {
                    return false;
                }
                return key != left || slice != BindingContext.SMARTCAST;
            }
        }, true);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorNameConventions.EQUALS, equals.getReturnType(), context)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on((PsiElement)operationSign, resolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    @NotNull
    private KotlinTypeInfo visitComparison(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context, @NotNull KtSimpleNameExpression operationSign) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        KotlinTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorNameConventions.COMPARE_TO, context, expression2);
        KotlinType compareToReturnType = typeInfo.getType();
        KotlinType type2 = null;
        if (compareToReturnType != null && !compareToReturnType.isError()) {
            if (KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(type2);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable KtExpression left, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        KotlinType booleanType = this.components.builtIns.getBooleanType();
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.LEFT_BOOLEAN_EXPRESSION);
        boolean isAnd = operationType == KtTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.RIGHT_BOOLEAN_EXPRESSION);
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        KotlinTypeInfo kotlinTypeInfo = leftTypeInfo.replaceType(booleanType);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitElvisExpression(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo rightTypeInfo;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        if (contextWithExpectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextWithExpectedType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return kotlinTypeInfo;
        }
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Lists.newArrayList((Object[])new KtExpression[]{left, right}));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, ControlStructureTypingUtils.ResolveConstruct.ELVIS, Lists.newArrayList((Object[])new String[]{"left", "right"}), Lists.newArrayList((Object[])new Boolean[]{true, false}), contextWithExpectedType, null);
        KotlinTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(left, context)) {
            context.trace.report(Errors.USELESS_ELVIS_ON_LAMBDA_EXPRESSION.on((PsiElement)expression2.getOperationReference()));
            if (leftTypeInfo == null) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (kotlinTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
                }
                return kotlinTypeInfo;
            }
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression2;
        KotlinType leftType = leftTypeInfo.getType();
        if (leftType != null && BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context)) {
            context.trace.report(Errors.USELESS_ELVIS.on(expression2, leftType));
        }
        if ((rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context.trace.getBindingContext())) == null && ArgumentTypeResolver.isFunctionLiteralArgument(right, context)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return kotlinTypeInfo;
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression2;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        KotlinType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getInfo(call.getValueArguments().get(1));
        KotlinType type2 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (type2 == null || rightType == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(dataFlowInfo);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return kotlinTypeInfo;
        }
        if (leftType != null) {
            DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, leftType, context);
            DataFlowInfo rightDataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpInRight = KotlinBuiltIns.isNothing(rightType);
            DataFlowValue nullValue = DataFlowValue.nullValue(this.components.builtIns);
            if (jumpInRight || !rightDataFlowInfo.getPredictableNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, nullValue);
                if (left instanceof KtBinaryExpressionWithTypeRHS) {
                    dataFlowInfo = BasicExpressionTypingVisitor.establishSubtypingForTypeRHS((KtBinaryExpressionWithTypeRHS)left, dataFlowInfo, context);
                }
            }
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, context);
            dataFlowInfo = dataFlowInfo.assign(resultValue, leftValue).disequate(resultValue, nullValue);
            if (!jumpInRight) {
                DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rightType, context);
                rightDataFlowInfo = rightDataFlowInfo.assign(resultValue, rightValue);
                dataFlowInfo = dataFlowInfo.or(rightDataFlowInfo);
            }
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context.dataFlowInfo);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private static DataFlowInfo establishSubtypingForTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS left, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionTypingContext context) {
        KtExpression underSafeAs;
        KotlinType underSafeAsType;
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "establishSubtypingForTypeRHS"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "establishSubtypingForTypeRHS"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "establishSubtypingForTypeRHS"));
        }
        IElementType operationType = left.getOperationReference().getReferencedNameElementType();
        if (operationType == KtTokens.AS_SAFE && (underSafeAsType = context.trace.getType(underSafeAs = left.getLeft())) != null) {
            DataFlowValue underSafeAsValue = DataFlowValueFactory.createDataFlowValue(underSafeAs, underSafeAsType, context);
            KotlinType targetType = context.trace.get(BindingContext.TYPE, left.getRight());
            if (targetType != null) {
                DataFlowInfo dataFlowInfo2 = dataFlowInfo.establishSubtyping(underSafeAsValue, targetType);
                if (dataFlowInfo2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "establishSubtypingForTypeRHS"));
                }
                return dataFlowInfo2;
            }
        }
        DataFlowInfo dataFlowInfo3 = dataFlowInfo;
        if (dataFlowInfo3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "establishSubtypingForTypeRHS"));
        }
        return dataFlowInfo3;
    }

    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement2, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        if (callElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        KtExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement2, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorNameConventions.CONTAINS);
        KotlinType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context.contextDependency);
        this.ensureBooleanResult(operationSign, OperatorNameConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.clearType();
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        return kotlinTypeInfo;
    }

    private boolean ensureBooleanResult(KtExpression operationSign, Name name2, KotlinType resultType, ExpressionTypingContext context) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name2 + "'", context);
    }

    private boolean ensureBooleanResultWithCustomSubject(KtExpression operationSign, KotlinType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression2, final ExpressionTypingContext context) {
        KotlinType rightType;
        KtExpression left = expression2.getLeft();
        if (left == null) {
            return;
        }
        KtExpression right = expression2.getRight();
        KotlinType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression2, expression2.getOperationReference(), leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>(){

                public KotlinType invoke(KtExpression expression2) {
                    return BasicExpressionTypingVisitor.this.facade.getTypeInfo(expression2, context).getType();
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(){

                public Nullability invoke(DataFlowValue value2) {
                    return context.dataFlowInfo.getPredictableNullability(value2);
                }
            });
        }
    }

    @NotNull
    private KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo = this.assignmentIsNotAnExpressionError(expression2, context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignmentOperation"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo = this.assignmentIsNotAnExpressionError(expression2, context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignment"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo assignmentIsNotAnExpressionError(KtBinaryExpression expression2, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression2, context);
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression2));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "assignmentIsNotAnExpressionError"));
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitArrayAccessExpression"));
        }
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression2, context), (KtExpression)expression2, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass, ExpressionTypingContext context) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitClass"));
        }
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), klass);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(klass, context);
    }

    @NotNull
    private static KotlinTypeInfo declarationInIllegalContext(@NotNull KtDeclaration declaration, @NotNull ExpressionTypingContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "declarationInIllegalContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "declarationInIllegalContext"));
        }
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(declaration));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "declarationInIllegalContext"));
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property2, ExpressionTypingContext context) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitProperty"));
        }
        this.components.localVariableResolver.process(property2, context, context.scope, this.facade);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(property2, context);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfoForBinaryCall(@NotNull Name name2, @NotNull ExpressionTypingContext context, @NotNull KtBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        KtExpression left = binaryExpression.getLeft();
        KotlinTypeInfo typeInfo = left != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryKt.noTypeInfo(context);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)contextWithDataFlow.replaceScope(context.scope), receiver, binaryExpression, name2);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context.contextDependency));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitDeclaration"));
        }
        return BasicExpressionTypingVisitor.declarationInIllegalContext(dcl, context);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitStringTemplateExpression"));
        }
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix((PsiElement)expression2, context);
        class StringTemplateVisitor
        extends KtVisitorVoid {
            private KotlinTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitStringTemplateEntryWithExpression"));
                }
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitEscapeStringTemplateEntry"));
                }
                CompileTimeConstantChecker.CharacterWithDiagnostic value2 = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                Diagnostic diagnostic = value2.getDiagnostic();
                if (diagnostic != null) {
                    context.trace.report(diagnostic);
                }
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (KtStringTemplateEntry entry : expression2.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkLiteralPrefixAndSuffix(@NotNull PsiElement expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLiteralPrefixAndSuffix"));
        }
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.prevLeaf((PsiElement)expression2), context);
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.nextLeaf((PsiElement)expression2), context);
    }

    private static void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, ExpressionTypingContext context) {
        if (BasicExpressionTypingVisitor.illegalLiteralPrefixOrSuffix(prefixOrSuffix)) {
            context.trace.report(Errors.UNSUPPORTED.on(prefixOrSuffix, "literal prefixes and suffixes"));
        }
    }

    private static boolean illegalLiteralPrefixOrSuffix(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        IElementType elementType = element2.getNode().getElementType();
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAnnotatedExpression"));
        }
        return this.visitAnnotatedExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitAnnotatedExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        KtExpression baseExpression;
        if (!(expression2.getBaseExpression() instanceof KtObjectLiteralExpression)) {
            this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, expression2.getAnnotationEntries(), context.trace);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(baseExpression, context, isStatement);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element2, ExpressionTypingContext context) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitKtElement"));
        }
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element2, ((Object)((Object)this)).getClass().getCanonicalName()));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, false);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    KotlinTypeInfo resolveImplicitArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveImplicitArrayAccessSetMethod"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveImplicitArrayAccessSetMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveImplicitArrayAccessSetMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveImplicitArrayAccessSetMethod"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, true);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveImplicitArrayAccessSetMethod"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessGetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true, false);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo resolveArrayAccessSpecialMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @Nullable KtExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet, boolean isImplicit) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (oldContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContext", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(oldContext);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        KotlinType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(arrayExpression, arrayType, context.trace.getBindingContext());
        if (!isGet) assert (rightHandSide != null);
        Call call = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context, call, arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<KtExpression> indices = arrayAccessExpression.getIndexExpressions();
        KotlinTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context);
        }
        if (isImplicit && !functionResults.isSuccess() || !functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.clearType();
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return kotlinTypeInfo;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        return kotlinTypeInfo;
    }
}

