/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.edges.CdiInjectionPointEdge;
import com.intellij.cdi.dependencies.edges.CdiProducerEdge;
import com.intellij.cdi.dependencies.nodes.CdiDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiManagedBeanDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.cdi.dependencies.nodes.CdiProducerDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiProductTypeDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiPsiClassNode;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CdiDependenciesDataModel
extends GraphDataModel<CdiNode, CdiEdge> {
    private final Collection<CdiNode> myNodes;
    private final Collection<CdiEdge> myEdges;
    private final PsiClass myPsiClass;

    public CdiDependenciesDataModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "<init>"));
        }
        this.myNodes = new HashSet();
        this.myEdges = new HashSet();
        this.myPsiClass = psiClass;
    }

    @NotNull
    public Collection<CdiNode> getNodes() {
        Collection<CdiNode> collection = this.getNodes(true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<CdiNode> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<CdiNode> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<CdiEdge> getEdges() {
        Collection<CdiEdge> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public CdiNode getSourceNode(CdiEdge dependencyInfo) {
        CdiNode cdiNode = dependencyInfo.getSource();
        if (cdiNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getSourceNode"));
        }
        return cdiNode;
    }

    @NotNull
    public CdiNode getTargetNode(CdiEdge dependencyInfo) {
        CdiNode cdiNode = dependencyInfo.getTarget();
        if (cdiNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getTargetNode"));
        }
        return cdiNode;
    }

    @NotNull
    public String getNodeName(CdiNode node) {
        String name = node.getName();
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(CdiEdge pageflowBasicEdge) {
        String string = pageflowBasicEdge.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getEdgeName"));
        }
        return string;
    }

    public CdiEdge createEdge(@NotNull CdiNode from, @NotNull CdiNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "createEdge"));
        }
        return null;
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        CdiPsiClassNode classNode = new CdiPsiClassNode(this.myPsiClass);
        this.myNodes.add(classNode);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPsiClass);
        if (module != null) {
            this.addInjectedNodes(module, classNode);
            this.addOutjectedNodes(module, classNode);
            this.addProduces(this.myPsiClass, classNode);
            this.addFactories(module, this.myPsiClass, classNode);
        }
    }

    private void addFactories(Module module, PsiClass psiClass, CdiPsiClassNode targetNode) {
        PsiClassType type = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
        List<PsiMember> producers = CdiCommonUtils.getPsiTypeProducers(module, (PsiType)type);
        for (PsiMember producer : producers) {
            ProducerBeanDescriptor<? extends PsiMember> producerDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(producer);
            assert (producerDescriptor != null);
            CdiProducerDescriptorNode sourceNode = new CdiProducerDescriptorNode(producerDescriptor);
            this.myNodes.add(targetNode);
            this.myEdges.add(new CdiProducerEdge(sourceNode, targetNode, producer));
        }
    }

    private void addProduces(@NotNull PsiClass psiClass, @NotNull CdiNode sourceNode) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "addProduces"));
        }
        if (sourceNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "addProduces"));
        }
        for (PsiField psiField : CdiCommonUtils.getProducerFields(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiField);
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiMethod);
        }
    }

    private void addProducesNode(CdiNode sourceNode, PsiMember psiField) {
        ProducerBeanDescriptor<? extends PsiMember> producerDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiField);
        assert (producerDescriptor != null);
        CdiProductTypeDescriptorNode targetNode = new CdiProductTypeDescriptorNode(producerDescriptor);
        this.myNodes.add(targetNode);
        this.myEdges.add(new CdiProducerEdge(sourceNode, targetNode, psiField));
    }

    private void addOutjectedNodes(Module module, CdiNode sourceNode) {
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(this.myPsiClass);
        Set<InjectionPointDescriptor> allInjectionPoints = CdiInjectionUtils.getInjectionPoints(module);
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints((PsiType)psiClassType, allInjectionPoints);
        for (InjectionPointDescriptor injectionPointDescriptor : injectionPoints) {
            PsiModifierListOwner owner = injectionPointDescriptor.getOwner();
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class);
            if (containingClass == null) continue;
            CdiPsiClassNode targetNode = new CdiPsiClassNode(containingClass);
            this.myNodes.add(targetNode);
            this.myEdges.add(new CdiInjectionPointEdge(sourceNode, targetNode, injectionPointDescriptor));
        }
    }

    private void addInjectedNodes(Module module, CdiNode targetNode) {
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(this.myPsiClass);
        for (InjectionPointDescriptor descriptor : injectionPoints) {
            if ("javax.enterprise.inject.spi.InjectionPoint".equals(descriptor.getType().getCanonicalText()) && descriptor.getQualifierAnnotations().length == 0) continue;
            Set<CdiBeanDescriptor> beanDescriptors = CdiInjectionUtils.getInjectedBeans(descriptor);
            if (beanDescriptors.size() > 0) {
                for (CdiBeanDescriptor beanDescriptor : beanDescriptors) {
                    CdiDescriptorNode sourceNode = null;
                    if (beanDescriptor instanceof ManagedBeanDescriptor) {
                        sourceNode = new CdiManagedBeanDescriptorNode((ManagedBeanDescriptor)beanDescriptor);
                    } else if (beanDescriptor instanceof ProducerBeanDescriptor) {
                        sourceNode = new CdiProducerDescriptorNode((ProducerBeanDescriptor)beanDescriptor);
                    }
                    if (sourceNode == null) continue;
                    this.myNodes.add(targetNode);
                    this.myEdges.add(new CdiInjectionPointEdge(sourceNode, targetNode, descriptor));
                }
                continue;
            }
            this.addInjectionPointEdge(module, targetNode, descriptor, descriptor.getType());
        }
    }

    private void addInjectionPointEdge(Module module, CdiNode targetNode, InjectionPointDescriptor descriptor, final PsiType type) {
        PsiClass sourcePsiClass = CdiCommonUtils.getOriginalPsiClass(type, module);
        if (sourcePsiClass != null) {
            CdiPsiClassNode sourceNode = new CdiPsiClassNode(sourcePsiClass){

                @Override
                public String getName() {
                    if (CdiDependenciesDataModel.isPsiClassTypeWithGenerics(type)) {
                        return type.getPresentableText();
                    }
                    return super.getName();
                }
            };
            this.myNodes.add(targetNode);
            this.myEdges.add(new CdiInjectionPointEdge(sourceNode, targetNode, descriptor, !CdiDependenciesDataModel.isContainerSpecificInjection(sourcePsiClass)));
        }
    }

    private static boolean isContainerSpecificInjection(PsiClass sourcePsiClass) {
        return "javax.enterprise.event.Event".equals(sourcePsiClass.getQualifiedName());
    }

    private static boolean isPsiClassTypeWithGenerics(PsiType type) {
        if (type instanceof PsiClassType) {
            return CdiCommonUtils.resolveGenerics((PsiClassType)type).size() > 0;
        }
        return false;
    }

    public void dispose() {
    }

    @NotNull
    public PsiClass getPsiClass() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/CdiDependenciesDataModel", "getPsiClass"));
        }
        return psiClass;
    }
}

