/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiCommonUtils {
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS = new Key("MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_SCOPE_TYPES_ANNOTATIONS = new Key("MODULE_SCOPE_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_DEPLOYMENT_TYPES_ANNOTATIONS = new Key("MODULE_DEPLOYMENT_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_STEREOTYPES_ANNOTATIONS = new Key("MODULE_STEREOTYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiPackage>>> VETOED_PACKAGES = new Key("VETOED_PACKAGES");
    private static final Key<CachedValue<Boolean>> MANAGED_BEAN = new Key("SIMPLE_WEB_BEAN");

    private CdiCommonUtils() {
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner) {
        Set<PsiClass> set = CdiCommonUtils.getQualifierClasses(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getQualifierClasses"));
        }
        return set;
    }

    @NotNull
    public static Set<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        HashSet bindingTypes = new HashSet();
        for (PsiClass anno : CdiCommonUtils.getQualifierClasses(module)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)anno.getQualifiedName(), (boolean)true)) continue;
            bindingTypes.add(anno);
        }
        HashSet hashSet = bindingTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getQualifierClasses"));
        }
        return hashSet;
    }

    @NotNull
    public static PsiAnnotation[] getQualifierAnnotations(PsiModifierListOwner psiModifierListOwner) {
        Collection<String> strings = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(psiModifierListOwner));
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiModifierListOwner, strings);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getQualifierAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static Set<PsiClass> getInterceptorBindingTypesClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        HashSet bindingTypes = new HashSet();
        for (PsiClass anno : CdiCommonUtils.getInterceptorBindingTypesClasses(module)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)anno.getQualifiedName(), (boolean)true)) continue;
            bindingTypes.add(anno);
        }
        HashSet hashSet = bindingTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getInterceptorBindingTypesClasses"));
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : JamCommonUtil.getAnnotationTypesWithChildren((Module)module, (String)"javax.inject.Qualifier", (boolean)false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getQualifierClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getInterceptorBindingTypesClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : JamCommonUtil.getAnnotationTypesWithChildren((Module)module, (String)"javax.interceptor.InterceptorBinding", (boolean)false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getInterceptorBindingTypesClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getBindingTypesQualifiedNames(Module module) {
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(module));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getBindingTypesQualifiedNames"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getNormalScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getNormalScopeTypesClasses"));
        }
        Collection collection = JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS, (String)"javax.enterprise.context.NormalScope");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getNormalScopeTypesClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getNormalScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getNormalScopeQualifiedNames"));
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getNormalScopeQualifiedNames"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getScopeTypesClasses"));
        }
        Collection collection = JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_SCOPE_TYPES_ANNOTATIONS, (String)"javax.inject.Scope");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getScopeTypesClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getScopeQualifiedNames"));
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getScopeQualifiedNames"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getDeploymentTypesClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getDeploymentTypesClasses"));
        }
        Collection collection = JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_DEPLOYMENT_TYPES_ANNOTATIONS, (String)"javax.enterprise.inject.deployment.DeploymentType");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getDeploymentTypesClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getStereotypeAnnotationNames(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationNames"));
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationNames"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationClasses"));
        }
        Collection collection = JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_STEREOTYPES_ANNOTATIONS, (String)"javax.enterprise.inject.Stereotype");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiPackage> getVetoedPackages(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getVetoedPackages"));
        }
        CachedValue cachedValue = (CachedValue)module.getUserData(VETOED_PACKAGES);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "lambda$getVetoedPackages$0"));
                }
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.enterprise.inject.Vetoed", scope);
                Set packages = psiClass == null ? Collections.emptySet() : AnnotatedPackagesSearch.search((PsiClass)psiClass, (SearchScope)scope).findAll();
                return CachedValueProvider.Result.create(packages, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            module.putUserData(VETOED_PACKAGES, (Object)cachedValue);
        }
        Collection collection = (Collection)cachedValue.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getVetoedPackages"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getAlternativeStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getAlternativeStereotypeAnnotationClasses"));
        }
        com.intellij.util.containers.hash.HashSet alternativeStereotypeAnnotations = new com.intellij.util.containers.hash.HashSet();
        for (PsiClass psiClass : JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_STEREOTYPES_ANNOTATIONS, (String)"javax.enterprise.inject.Stereotype")) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.enterprise.inject.Alternative", (boolean)true)) continue;
            alternativeStereotypeAnnotations.add(psiClass);
        }
        com.intellij.util.containers.hash.HashSet hashSet = alternativeStereotypeAnnotations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getAlternativeStereotypeAnnotationClasses"));
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(Module module, String ... encapsulatedClasses) {
        if (encapsulatedClasses.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationClasses"));
            }
            return list;
        }
        ArrayList<PsiClass> stereotypes = new ArrayList<PsiClass>();
        for (PsiClass stereotypeAnnoPsiClass : CdiCommonUtils.getStereotypeAnnotationClasses(module)) {
            if (!stereotypeAnnoPsiClass.isAnnotationType() || !AnnotationUtil.isAnnotated((PsiModifierListOwner)stereotypeAnnoPsiClass, Arrays.asList(encapsulatedClasses))) continue;
            stereotypes.add(stereotypeAnnoPsiClass);
        }
        ArrayList<PsiClass> arrayList = stereotypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getStereotypeAnnotationClasses"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getQualifiedNames(Iterable<PsiClass> annotations) {
        List list = ContainerUtil.mapNotNull(annotations, psiClass -> psiClass.getQualifiedName());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getQualifiedNames"));
        }
        return list;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        Boolean value;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "isManagedBean"));
        }
        CachedValue cachedValue = (CachedValue)psiClass.getUserData(MANAGED_BEAN);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "lambda$isManagedBean$2"));
                }
                return new CachedValueProvider.Result((Object)CdiManagedBeanValidationUtils.isManagedBean(psiClass), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            psiClass.putUserData(MANAGED_BEAN, (Object)cachedValue);
        }
        return (value = (Boolean)cachedValue.getValue()) != null && value != false;
    }

    public static boolean isCdiInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.enterprise.inject.Instance", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    public static boolean isCdiInstalled(@Nullable Module module, @NotNull CdiVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/cdi/utils/CdiCommonUtils", "isCdiInstalled"));
        }
        if (module == null || module.isDisposed()) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (version == CdiVersion.CDI_1_1) {
            return facade.findClass("javax.enterprise.inject.Vetoed", scope) != null;
        }
        if (version == CdiVersion.CDI_1_0) {
            return facade.findClass("javax.enterprise.inject.Instance", scope) != null;
        }
        return false;
    }

    public static boolean isEnterpraiseCdiBean(PsiClass aClass) {
        return false;
    }

    public static List<String> getAnnotations(Class clazz) {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            for (Field field : clazz.getFields()) {
                Object value = field.get(null);
                if (!(value instanceof String)) continue;
                annotations.add((String)value);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return annotations;
    }

    public static boolean isDecorator(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "isDecorator"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.decorator.Decorator", (boolean)false);
    }

    public static boolean isInterceptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "isInterceptor"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.interceptor.Interceptor", (boolean)false);
    }

    public static boolean isAlternative(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/cdi/utils/CdiCommonUtils", "isAlternative"));
        }
        if (CdiCommonUtils.isAlternativeAnnotated(psiMember)) {
            return true;
        }
        return psiMember instanceof PsiClass && CdiCommonUtils.hasAlternativeProducers((PsiClass)psiMember);
    }

    public static boolean isAlternativeAnnotated(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/cdi/utils/CdiCommonUtils", "isAlternativeAnnotated"));
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.enterprise.inject.Alternative", (boolean)false)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
        return module != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)));
    }

    public static boolean hasAlternativeProducers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "hasAlternativeProducers"));
        }
        for (PsiField field : CdiCommonUtils.getProducerFields(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)field)) continue;
            return true;
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)psiMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass getOriginalPsiClass(PsiType type, @NotNull Module module) {
        String name;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getOriginalPsiClass"));
        }
        if (type instanceof PsiClassType) {
            PsiType genericPsiType;
            List<PsiType> psiTypes;
            PsiClassType psiClassType = (PsiClassType)type;
            PsiClassType providerClass = CdiCommonUtils.getProviderClass(psiClassType);
            if (providerClass != null && (psiTypes = CdiCommonUtils.resolveGenerics(providerClass)).size() == 1 && (genericPsiType = psiTypes.get(0)) instanceof PsiClassType) {
                return ((PsiClassType)genericPsiType).resolve();
            }
            return psiClassType.resolve();
        }
        if (type instanceof PsiPrimitiveType && !StringUtil.isEmptyOrSpaces((String)(name = ((PsiPrimitiveType)type).getBoxedTypeName()))) {
            return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(name, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        }
        return null;
    }

    @Nullable
    private static PsiClassType getProviderClass(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "com/intellij/cdi/utils/CdiCommonUtils", "getProviderClass"));
        }
        PsiClass psiClass = psiClassType.resolve();
        if (psiClass == null) {
            return null;
        }
        if ("javax.inject.Provider".equals(psiClass.getQualifiedName())) {
            return psiClassType;
        }
        for (PsiType type : psiClassType.getSuperTypes()) {
            PsiClass superClass;
            if (!(type instanceof PsiClassType) || (superClass = ((PsiClassType)type).resolve()) == null || !"javax.inject.Provider".equals(superClass.getQualifiedName())) continue;
            return (PsiClassType)type;
        }
        return null;
    }

    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        ArrayList<PsiType> generics = new ArrayList<PsiType>();
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass != null && substitutor != null) {
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
        }
        return generics;
    }

    public static boolean isProxyable(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/cdi/utils/CdiCommonUtils", "isProxyable"));
        }
        if (psiType instanceof PsiPrimitiveType) {
            return false;
        }
        if (psiType instanceof PsiArrayType) {
            return false;
        }
        if (psiType instanceof PsiClassType) {
            return CdiCommonUtils.isClassProxyable(((PsiClassType)psiType).resolve());
        }
        return false;
    }

    public static boolean isClassProxyable(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return true;
        }
        if (!CdiCommonUtils.hasAppropriateConstructor(psiClass)) {
            return false;
        }
        PsiModifierList list = psiClass.getModifierList();
        if (list != null && (list.hasModifierProperty("private") || list.hasModifierProperty("final"))) {
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getModifierList().hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAppropriateConstructor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "hasAppropriateConstructor"));
        }
        PsiMethod[] methods = psiClass.getConstructors();
        if (methods.length == 0) {
            return true;
        }
        for (PsiMethod psiMethod : methods) {
            if (psiMethod.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerMethods"));
        }
        List<PsiMethod> list = CdiCommonUtils.getProducerMethods(psiClass, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerMethods"));
        }
        return list;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerFields"));
        }
        List<PsiField> list = CdiCommonUtils.getProducerFields(psiClass, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerFields"));
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass, boolean withSupers) {
        PsiMethod[] methods;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerMethods"));
        }
        ArrayList<PsiMethod> producers = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = withSupers ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.enterprise.inject.Produces", (boolean)true)) continue;
            producers.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = producers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerMethods"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass, boolean withSupers) {
        PsiField[] fields;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerFields"));
        }
        ArrayList<PsiField> producers = new ArrayList<PsiField>();
        for (PsiField psiField : fields = withSupers ? psiClass.getAllFields() : psiClass.getFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, (String)"javax.enterprise.inject.Produces", (boolean)true)) continue;
            producers.add(psiField);
        }
        ArrayList<PsiField> arrayList = producers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getProducerFields"));
        }
        return arrayList;
    }

    public static List<PsiMember> getPsiTypeProducers(@NotNull Module module, @NotNull PsiType psiType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/utils/CdiCommonUtils", "getPsiTypeProducers"));
        }
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/cdi/utils/CdiCommonUtils", "getPsiTypeProducers"));
        }
        ArrayList<PsiMember> producers = new ArrayList<PsiMember>();
        for (CdiProduces jamProduces : CdiJamModel.getModel(module).getProduces()) {
            PsiType productType = jamProduces.getProductType();
            if (productType == null || !productType.isAssignableFrom(psiType)) continue;
            producers.add((PsiMember)jamProduces.getPsiElement());
        }
        return producers;
    }

    @NotNull
    public static List<PsiMethod> getDisposerMethods(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getDisposerMethods"));
        }
        ArrayList<PsiMethod> disposerMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = psiClass.getAllMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.inject.Disposes", (boolean)true)) continue;
                disposerMethods.add(psiMethod);
            }
        }
        ArrayList<PsiMethod> arrayList = disposerMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getDisposerMethods"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getObservesMethods(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "getObservesMethods"));
        }
        ArrayList<PsiMethod> observesMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = psiClass.getAllMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.Observes", (boolean)true)) continue;
                observesMethods.add(psiMethod);
            }
        }
        ArrayList<PsiMethod> arrayList = observesMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/utils/CdiCommonUtils", "getObservesMethods"));
        }
        return arrayList;
    }

    public static boolean isClassContainsCdiAnnotations(PsiClass psiClass, Module module) {
        List<String> annos = CdiCommonUtils.collectCdiBeansAnnotations(module);
        return CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, annos);
    }

    public static boolean isClassContainsCdiAnnotations(@NotNull PsiClass psiClass, @NotNull List<String> annos) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/utils/CdiCommonUtils", "isClassContainsCdiAnnotations"));
        }
        if (annos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annos", "com/intellij/cdi/utils/CdiCommonUtils", "isClassContainsCdiAnnotations"));
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, annos) != null) {
            return true;
        }
        for (PsiField psiField : psiClass.getFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) == null) continue;
            return true;
        }
        for (PsiField psiField : psiClass.getMethods()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) != null) {
                return true;
            }
            for (PsiParameter parameter : psiField.getParameterList().getParameters()) {
                if (AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annos) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> collectCdiBeansAnnotations(Module module) {
        List<String> annotations = CdiCommonUtils.getAnnotations(CdiAnnoConstants.class);
        annotations.addAll(CdiCommonUtils.getBindingTypesQualifiedNames(module));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module)));
        return annotations;
    }
}

