/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.DataProvider;

public class DataProviderSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public DataProviderSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/theoryinpractice/testng/DataProviderSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/theoryinpractice/testng/DataProviderSearcher", "processQuery"));
        }
        PsiMethod method = queryParameters.getMethod();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{DataProvider.class.getName()});
        if (annotation == null) {
            return;
        }
        PsiAnnotationMemberValue dataProviderMethodName = annotation.findDeclaredAttributeValue("name");
        if (dataProviderMethodName != null) {
            String providerName = StringUtil.unquoteString((String)dataProviderMethodName.getText());
            queryParameters.getOptimizer().searchWord(providerName, queryParameters.getEffectiveSearchScope(), (short)4, true, (PsiElement)method);
        }
    }
}

