/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Navigation;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AvdWizardConstants {
    public static final String WIZARD_ONLY = "AvdManager.WizardOnly.";
    public static final ScopedStateStore.Key<Device> DEVICE_DEFINITION_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.DeviceDefinition", ScopedStateStore.Scope.WIZARD, Device.class);
    public static final ScopedStateStore.Key<SystemImageDescription> SYSTEM_IMAGE_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.SystemImage", ScopedStateStore.Scope.WIZARD, SystemImageDescription.class);
    public static final ScopedStateStore.Key<Storage> RAM_STORAGE_KEY = ScopedStateStore.createKey("hw.ramSize", ScopedStateStore.Scope.WIZARD, Storage.class);
    public static final ScopedStateStore.Key<Storage> VM_HEAP_STORAGE_KEY = ScopedStateStore.createKey("vm.heapSize", ScopedStateStore.Scope.WIZARD, Storage.class);
    public static final ScopedStateStore.Key<Storage> INTERNAL_STORAGE_KEY = ScopedStateStore.createKey("disk.dataPartition.size", ScopedStateStore.Scope.WIZARD, Storage.class);
    public static final ScopedStateStore.Key<Storage> SD_CARD_STORAGE_KEY = ScopedStateStore.createKey("sdcard.size", ScopedStateStore.Scope.WIZARD, Storage.class);
    public static final ScopedStateStore.Key<String> EXISTING_SD_LOCATION = ScopedStateStore.createKey("sdcard.path", ScopedStateStore.Scope.WIZARD, String.class);
    public static final ScopedStateStore.Key<Storage> DISPLAY_SD_SIZE_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.displaySdCardSize", ScopedStateStore.Scope.WIZARD, Storage.class);
    public static final ScopedStateStore.Key<String> DISPLAY_SD_LOCATION_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.displaySdLocation", ScopedStateStore.Scope.WIZARD, String.class);
    public static final ScopedStateStore.Key<Boolean> DISPLAY_USE_EXTERNAL_SD_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.displayUseExistingSd", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final String AVD_INI_SCALE_FACTOR = "runtime.scalefactor";
    public static final ScopedStateStore.Key<AvdScaleFactor> SCALE_SELECTION_KEY = ScopedStateStore.createKey("runtime.scalefactor", ScopedStateStore.Scope.WIZARD, AvdScaleFactor.class);
    public static final ScopedStateStore.Key<ScreenOrientation> DEFAULT_ORIENTATION_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.DefaultOrientation", ScopedStateStore.Scope.WIZARD, ScreenOrientation.class);
    public static final String AVD_INI_NETWORK_SPEED = "runtime.network.speed";
    public static final ScopedStateStore.Key<String> NETWORK_SPEED_KEY = ScopedStateStore.createKey("runtime.network.speed", ScopedStateStore.Scope.WIZARD, String.class);
    public static final String AVD_INI_NETWORK_LATENCY = "runtime.network.latency";
    public static final ScopedStateStore.Key<String> NETWORK_LATENCY_KEY = ScopedStateStore.createKey("runtime.network.latency", ScopedStateStore.Scope.WIZARD, String.class);
    public static final ScopedStateStore.Key<String> FRONT_CAMERA_KEY = ScopedStateStore.createKey("hw.camera.front", ScopedStateStore.Scope.WIZARD, String.class);
    public static final ScopedStateStore.Key<String> BACK_CAMERA_KEY = ScopedStateStore.createKey("hw.camera.back", ScopedStateStore.Scope.WIZARD, String.class);
    public static final String CHOOSE_DEVICE_DEFINITION_STEP = "Choose Device Definition Step";
    public static final String CHOOSE_SYSTEM_IMAGE_STEP = "Choose System Image Step";
    public static final ScopedStateStore.Key<Boolean> USE_HOST_GPU_KEY = ScopedStateStore.createKey("hw.gpu.enabled", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final ScopedStateStore.Key<GpuMode> HOST_GPU_MODE_KEY = ScopedStateStore.createKey("hw.gpu.mode", ScopedStateStore.Scope.WIZARD, GpuMode.class);
    public static final ScopedStateStore.Key<Boolean> IS_IN_EDIT_MODE_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.isInEditMode", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final ScopedStateStore.Key<File> DISPLAY_SKIN_FILE_KEY = ScopedStateStore.createKey("displaySkinPath", ScopedStateStore.Scope.STEP, File.class);
    public static final ScopedStateStore.Key<File> CUSTOM_SKIN_FILE_KEY = ScopedStateStore.createKey("skin.path", ScopedStateStore.Scope.WIZARD, File.class);
    public static final ScopedStateStore.Key<File> BACKUP_SKIN_FILE_KEY = ScopedStateStore.createKey("skin.path.backup", ScopedStateStore.Scope.WIZARD, File.class);
    public static final ScopedStateStore.Key<Boolean> DEVICE_FRAME_KEY = ScopedStateStore.createKey("showDeviceFrame", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<String> DISPLAY_NAME_KEY = ScopedStateStore.createKey("avd.ini.displayname", ScopedStateStore.Scope.WIZARD, String.class);
    public static final String AVD_INI_AVD_ID = "AvdId";
    public static final ScopedStateStore.Key<String> AVD_ID_KEY = ScopedStateStore.createKey("AvdId", ScopedStateStore.Scope.WIZARD, String.class);
    public static final ScopedStateStore.Key<Boolean> RANCHU_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.ranchu.emulator", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final ScopedStateStore.Key<Integer> CPU_CORES_KEY = ScopedStateStore.createKey("hw.cpu.ncore", ScopedStateStore.Scope.WIZARD, Integer.class);
    public static final ScopedStateStore.Key<String> DEVICE_NAME_KEY = ScopedStateStore.createKey("DeviceName", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<Double> DIAGONAL_SCREENSIZE_KEY = ScopedStateStore.createKey("DiagonalScreenSize", ScopedStateStore.Scope.STEP, Double.class);
    public static final ScopedStateStore.Key<Integer> RESOLUTION_WIDTH_KEY = ScopedStateStore.createKey("ResolutionWidth", ScopedStateStore.Scope.STEP, Integer.class);
    public static final ScopedStateStore.Key<Integer> RESOLUTION_HEIGHT_KEY = ScopedStateStore.createKey("ResolutionHeight", ScopedStateStore.Scope.STEP, Integer.class);
    public static final ScopedStateStore.Key<Boolean> HAS_HARDWARE_BUTTONS_KEY = ScopedStateStore.createKey("HasHardwareButtons", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_HARDWARE_KEYBOARD_KEY = ScopedStateStore.createKey("hw.keyboard", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final ScopedStateStore.Key<Navigation> NAVIGATION_KEY = ScopedStateStore.createKey("Navigation", ScopedStateStore.Scope.STEP, Navigation.class);
    public static final ScopedStateStore.Key<Boolean> SUPPORTS_LANDSCAPE_KEY = ScopedStateStore.createKey("SupportsLandscape", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> SUPPORTS_PORTRAIT_KEY = ScopedStateStore.createKey("SupportsPortrait", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_BACK_CAMERA_KEY = ScopedStateStore.createKey("HasBackCamera", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_FRONT_CAMERA_KEY = ScopedStateStore.createKey("HasFrontCamera", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_ACCELEROMETER_KEY = ScopedStateStore.createKey("HasAccelerometer", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_GYROSCOPE_KEY = ScopedStateStore.createKey("HasGyroscope", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_GPS_KEY = ScopedStateStore.createKey("HasGPS", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> HAS_PROXIMITY_SENSOR_KEY = ScopedStateStore.createKey("HasProximitySensor", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Screen> WIP_SCREEN_KEY = ScopedStateStore.createKey("ScreenUnderConstruction", ScopedStateStore.Scope.STEP, Screen.class);
    public static final ScopedStateStore.Key<Hardware> WIP_HARDWARE_KEY = ScopedStateStore.createKey("HardwareUnderConstruction", ScopedStateStore.Scope.STEP, Hardware.class);
    public static final ScopedStateStore.Key<Double> WIP_SCREEN_DPI_KEY = ScopedStateStore.createKey("ScreenDPI", ScopedStateStore.Scope.STEP, Double.class);
    public static final ScopedStateStore.Key<IdDisplay> TAG_ID_KEY = ScopedStateStore.createKey("TagId", ScopedStateStore.Scope.STEP, IdDisplay.class);
    public static final AvdScaleFactor DEFAULT_SCALE = AvdScaleFactor.AUTO;
    public static final String DEFAULT_NETWORK_SPEED = "full";
    public static final String DEFAULT_NETWORK_LATENCY = "none";
    public static final String DEFAULT_CAMERA = "none";
    public static final Storage DEFAULT_INTERNAL_STORAGE = new Storage(800L, Storage.Unit.MiB);
    public static final Font STANDARD_FONT = JBFont.create((Font)new Font("Sans", 0, 12));
    public static final Font FIGURE_FONT = JBFont.create((Font)new Font("Sans", 0, 10));
    public static final Font TITLE_FONT = JBFont.create((Font)new Font("Sans", 1, 16));
    public static final IdDisplay WEAR_TAG = IdDisplay.create((String)"android-wear", (String)"Android Wear");
    public static final IdDisplay TV_TAG = IdDisplay.create((String)"android-tv", (String)"Android TV");
    public static final IdDisplay GOOGLE_APIS_TAG = IdDisplay.create((String)"google_apis", (String)"Google APIs");
    public static final List<IdDisplay> ALL_TAGS = ImmutableList.of((Object)SystemImage.DEFAULT_TAG, (Object)WEAR_TAG, (Object)TV_TAG);
    public static final List<IdDisplay> TAGS_WITH_GOOGLE_API = ImmutableList.of((Object)GOOGLE_APIS_TAG, (Object)WEAR_TAG, (Object)TV_TAG);
    public static final String CREATE_SKIN_HELP_LINK = "http://developer.android.com/tools/devices/managing-avds.html#skins";
    public static final File NO_SKIN = new File("_no_skin");
    private static final int MAX_RAM_MB = 1536;

    @NotNull
    public static Storage getDefaultRam(@NotNull Hardware hardware) {
        if (hardware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardware", "com/android/tools/idea/avdmanager/AvdWizardConstants", "getDefaultRam"));
        }
        Storage ram = hardware.getRam();
        if (ram.getSizeAsUnit(Storage.Unit.MiB) >= 1536L) {
            Storage storage = new Storage(1536L, Storage.Unit.MiB);
            if (storage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardConstants", "getDefaultRam"));
            }
            return storage;
        }
        Storage storage = ram;
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdWizardConstants", "getDefaultRam"));
        }
        return storage;
    }

    public static int getMaxCpuCores() {
        return Runtime.getRuntime().availableProcessors() / 2;
    }
}

