/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Navigation;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureDeviceModel;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.ui.TooltipLabel;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.adapters.StringToDoubleAdapterProperty;
import com.android.tools.idea.ui.properties.adapters.StringToIntAdapterProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.PositiveDoubleValidator;
import com.android.tools.idea.ui.validation.validators.PositiveIntValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.base.Optional;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureDeviceOptionsStep
extends ModelWizardStep<ConfigureDeviceModel> {
    private static final String DEFAULT_DEVICE_TYPE_LABEL = "Phone/Tablet";
    private JPanel myRootPanel;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JCheckBox myHasBackFacingCamera;
    private JCheckBox myHasFrontFacingCamera;
    private JCheckBox myHasAccelerometer;
    private JCheckBox myHasGyroscope;
    private JCheckBox myHasGps;
    private JCheckBox myHasProximitySensor;
    private JCheckBox mySupportsLandscape;
    private JCheckBox mySupportsPortrait;
    private JCheckBox myHasHardwareKeyboard;
    private JCheckBox myHasHardwareButtons;
    private JTextField myDeviceName;
    private JTextField myScreenResolutionWidth;
    private JTextField myScreenResolutionHeight;
    private SkinChooser myCustomSkinPath;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private ComboBox myDeviceTypeComboBox;
    private JTextField myDiagonalScreenSize;
    private StorageField myRamField;
    private JComboBox myNavigationControlsCombo;
    private TooltipLabel myHelpAndErrorLabel;
    private JCheckBox myIsScreenRound;
    private JBScrollPane myScrollPane;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final Project myProject;
    private BindingsManager myBindings;
    private ListenerManager myListeners;

    public ConfigureDeviceOptionsStep(@NotNull ConfigureDeviceModel model, @Nullable Project project) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "<init>"));
        }
        super(model, "Configure Hardware Profile");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        FormScalingUtil.scaleComponentTree(this.getClass(), UIUtil.getRootPane((Component)this.myRootPanel));
        this.myValidatorPanel = new ValidatorPanel(this, this.myRootPanel);
        this.myStudioPanel = new StudioWizardStepPanel(this.myValidatorPanel, (String)((ConfigureDeviceModel)this.getModel()).wizardPanelDescription().get());
        this.myProject = project;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "onWizardStarting"));
        }
        this.myDeviceTypeComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(AvdWizardConstants.ALL_TAGS));
        this.myDeviceTypeComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<IdDisplay>(){

            public void customize(JList list, IdDisplay value, int index, boolean selected, boolean hasFocus) {
                if (value == null || SystemImage.DEFAULT_TAG.equals((Object)value)) {
                    this.setText(ConfigureDeviceOptionsStep.DEFAULT_DEVICE_TYPE_LABEL);
                } else {
                    this.setText(value.getDisplay());
                }
            }
        });
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myHelpAndErrorLabel.setBackground(JBColor.background());
        this.myHelpAndErrorLabel.setForeground(JBColor.foreground());
        this.myHelpAndErrorLabel.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 10));
        this.bindUi();
        this.attachValidators();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "canGoForward"));
        }
        return observableBool;
    }

    private void bindUi() {
        this.myBindings.bindTwoWay(new TextProperty(this.myDeviceName), ((ConfigureDeviceModel)this.getModel()).getDeviceData().name());
        this.myBindings.bindTwoWay(new StringToDoubleAdapterProperty(new TextProperty(this.myDiagonalScreenSize)), ((ConfigureDeviceModel)this.getModel()).getDeviceData().diagonalScreenSize());
        this.myBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionWidth)), ((ConfigureDeviceModel)this.getModel()).getDeviceData().screenResolutionWidth());
        this.myBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionHeight)), ((ConfigureDeviceModel)this.getModel()).getDeviceData().screenResolutionHeight());
        this.myBindings.bindTwoWay(this.myRamField.storage(), ((ConfigureDeviceModel)this.getModel()).getDeviceData().ramStorage());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareButtons), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasHardwareButtons());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareKeyboard), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasHardwareKeyboard());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myNavigationControlsCombo), ((ConfigureDeviceModel)this.getModel()).getDeviceData().navigation());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myIsScreenRound), ((ConfigureDeviceModel)this.getModel()).getDeviceData().isScreenRound());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsLandscape), ((ConfigureDeviceModel)this.getModel()).getDeviceData().supportsLandscape());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsPortrait), ((ConfigureDeviceModel)this.getModel()).getDeviceData().supportsPortrait());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasBackFacingCamera), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasBackCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasFrontFacingCamera), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasFrontCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasAccelerometer), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasAccelerometer());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGyroscope), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasGyroscope());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGps), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasGps());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasProximitySensor), ((ConfigureDeviceModel)this.getModel()).getDeviceData().hasProximitySensor());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myCustomSkinPath.getComboBox()), ((ConfigureDeviceModel)this.getModel()).getDeviceData().customSkinFile());
        SelectedItemProperty selectedDeviceType = new SelectedItemProperty((JComboBox)this.myDeviceTypeComboBox);
        this.myBindings.bindTwoWay(selectedDeviceType, ((ConfigureDeviceModel)this.getModel()).getDeviceData().deviceType());
        this.myListeners.listen(selectedDeviceType, new Consumer<Optional<IdDisplay>>(){

            public void consume(Optional<IdDisplay> idDisplayOptional) {
                IdDisplay selectedType = (IdDisplay)idDisplayOptional.orNull();
                if (selectedType != null) {
                    ((ConfigureDeviceModel)ConfigureDeviceOptionsStep.this.getModel()).getDeviceData().isWear().set(selectedType.equals((Object)AvdWizardConstants.WEAR_TAG));
                    ((ConfigureDeviceModel)ConfigureDeviceOptionsStep.this.getModel()).getDeviceData().isTv().set(selectedType.equals((Object)AvdWizardConstants.TV_TAG));
                    ConfigureDeviceOptionsStep.this.myIsScreenRound.setEnabled(selectedType.equals((Object)AvdWizardConstants.WEAR_TAG));
                    ConfigureDeviceOptionsStep.this.myIsScreenRound.setSelected((Boolean)((ConfigureDeviceModel)ConfigureDeviceOptionsStep.this.getModel()).getDeviceData().isScreenRound().get());
                }
            }
        });
    }

    private void createUIComponents() {
        this.myNavigationControlsCombo = new ComboBox((ComboBoxModel)new EnumComboBoxModel(Navigation.class)){

            public ListCellRenderer getRenderer() {
                return new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        if (list == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$3$1", "customizeCellRenderer"));
                        }
                        this.append(((Navigation)value).getShortDisplayValue());
                    }
                };
            }
        };
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.myCustomSkinPath = new SkinChooser(this.myProject);
        this.myDeviceDefinitionPreview = new DeviceDefinitionPreview(((ConfigureDeviceModel)this.getModel()).getDeviceData());
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    private void attachValidators() {
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().name(), new Validator<String>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull String value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$4", "validate"));
                }
                Validator.Result result = StringUtil.isNotEmpty((String)value) ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, "Please write a name for the new device.");
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$4", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().diagonalScreenSize(), new PositiveDoubleValidator("Please enter a non-zero positive floating point value for the screen size."));
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().screenResolutionWidth(), new PositiveIntValidator("Please enter non-zero positive integer values for the screen resolution width."));
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().screenResolutionHeight(), new PositiveIntValidator("Please enter non-zero positive integer values for the screen resolution height."));
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().ramStorage(), new Validator<Storage>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Storage value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$5", "validate"));
                }
                Validator.Result result = value.getSize() > 0L ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, "Please specify a non-zero amount of RAM.");
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$5", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().screenDpi(), new Validator<Double>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Double value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$6", "validate"));
                }
                Validator.Result result = value < 0.0 ? new Validator.Result(Validator.Severity.ERROR, "The given resolution and screen size specified have a DPI that is too low.") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$6", "validate"));
                }
                return result;
            }
        });
        Validator<Boolean> orientationValidator = new Validator<Boolean>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Boolean value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "validate"));
                }
                Validator.Result result = (Boolean)((ConfigureDeviceModel)ConfigureDeviceOptionsStep.this.getModel()).getDeviceData().supportsLandscape().or(((ConfigureDeviceModel)ConfigureDeviceOptionsStep.this.getModel()).getDeviceData().supportsPortrait()).not().get() != false ? new Validator.Result(Validator.Severity.ERROR, "A device must support at least one orientation (Portrait or Landscape).") : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "validate"));
                }
                return result;
            }
        };
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().supportsLandscape(), orientationValidator);
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().supportsPortrait(), orientationValidator);
        this.myValidatorPanel.registerValidator(((ConfigureDeviceModel)this.getModel()).getDeviceData().customSkinFile(), new Validator<Optional<File>>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Optional<File> value) {
                File layoutFile;
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$8", "validate"));
                }
                File skinPath = (File)value.orNull();
                if (skinPath != null && !FileUtil.filesEqual((File)skinPath, (File)AvdWizardConstants.NO_SKIN) && !(layoutFile = new File(skinPath, "layout")).isFile()) {
                    Validator.Result result = new Validator.Result(Validator.Severity.ERROR, "The skin directory does not point to a valid skin.");
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$8", "validate"));
                    }
                    return result;
                }
                Validator.Result result = Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$8", "validate"));
                }
                return result;
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TooltipLabel tooltipLabel;
        JCheckBox jCheckBox;
        StorageField storageField;
        JTextField jTextField;
        ComboBox comboBox;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.setMaximumSize(new Dimension(1280, 768));
        DeviceDefinitionPreview deviceDefinitionPreview = this.myDeviceDefinitionPreview;
        jPanel.add((Component)deviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(360, -1), null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(28, 3, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jBScrollPane.setViewportView(jPanel2);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Screen");
        jPanel2.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Memory");
        jPanel2.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Cameras");
        jPanel2.add((Component)jBLabel3, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Sensors");
        jPanel2.add((Component)jBLabel4, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHasBackFacingCamera = jCheckBox11 = new JCheckBox();
        jCheckBox11.setText("Back-facing camera");
        jCheckBox11.setToolTipText("<html>Enables back-facing camera support in emulator</html>");
        jCheckBox11.setSelected(true);
        jPanel2.add((Component)jCheckBox11, new GridConstraints(17, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasFrontFacingCamera = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Front-facing camera");
        jCheckBox10.setToolTipText("<html>Enables front-facing camera support in emulator</html>");
        jCheckBox10.setSelected(true);
        jPanel2.add((Component)jCheckBox10, new GridConstraints(18, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasAccelerometer = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Accelerometer");
        jCheckBox9.setToolTipText("<html>Enables accelerometer support in emulator.</html>");
        jCheckBox9.setSelected(true);
        jPanel2.add((Component)jCheckBox9, new GridConstraints(20, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasGyroscope = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Gyroscope");
        jCheckBox8.setToolTipText("<html>Enables gyroscope support in emulator.</html>");
        jCheckBox8.setSelected(true);
        jPanel2.add((Component)jCheckBox8, new GridConstraints(21, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasGps = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("GPS");
        jCheckBox7.setToolTipText("<html>Enables GPS (global positioning support) support in emulator.</html>");
        jCheckBox7.setSelected(true);
        jPanel2.add((Component)jCheckBox7, new GridConstraints(22, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasProximitySensor = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Proximity Sensor");
        jCheckBox6.setToolTipText("<html>Enables proximity sensor support in emulator</html>");
        jCheckBox6.setSelected(true);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(23, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySupportsLandscape = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Landscape");
        jCheckBox5.setToolTipText("<html>Enables the landscape device screen state in emulator</html>");
        jCheckBox5.setSelected(true);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(15, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySupportsPortrait = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Portrait");
        jCheckBox4.setToolTipText("<html>Enables the portrait device screen state in emulator.</html>");
        jCheckBox4.setSelected(true);
        jPanel2.add((Component)jCheckBox4, new GridConstraints(14, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html>Supported<br>device states</html>");
        jPanel2.add((Component)jBLabel5, new GridConstraints(14, 0, 2, 1, 9, 0, 0, 0, null, null, null));
        this.myHasHardwareKeyboard = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Has Hardware Keyboard");
        jCheckBox3.setToolTipText("<html>Enables hardware keyboard  support in Android Virtual Device.</html>");
        jCheckBox3.setSelected(true);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(11, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasHardwareButtons = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Has Hardware Buttons (Back/Home/Menu)");
        jCheckBox2.setToolTipText("<html>Enables hardware navigation button support in Android Virtual Device</html>");
        jCheckBox2.setSelected(true);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(10, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Input");
        jPanel2.add((Component)jBLabel6, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceName = jTextField4 = new JTextField();
        jTextField4.setToolTipText("<html>Name of the Device Profile</html>");
        jPanel2.add((Component)jTextField4, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Device Name");
        jPanel2.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(5, 1, 1, 2, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Resolution:");
        jPanel3.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myScreenResolutionWidth = jTextField3 = new JTextField();
        jTextField3.setColumns(5);
        jTextField3.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Width in pixels </html>");
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("x");
        jPanel3.add((Component)jBLabel9, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myScreenResolutionHeight = jTextField2 = new JTextField();
        jTextField2.setColumns(5);
        jTextField2.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Height in pixels </html>");
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("px");
        jPanel3.add((Component)jBLabel10, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(24, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Default Skin");
        jPanel2.add((Component)jBLabel11, new GridConstraints(26, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SkinChooser skinChooser = this.myCustomSkinPath;
        ((JComponent)((Object)skinChooser)).setToolTipText("<html>Path to a directory containing a custom skin</html>");
        jPanel2.add((Component)((Object)skinChooser), new GridConstraints(26, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(27, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("Device Type");
        jPanel2.add((Component)jBLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceTypeComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("inch");
        jPanel4.add((Component)jBLabel13, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDiagonalScreenSize = jTextField = new JTextField();
        jTextField.setColumns(10);
        jTextField.setToolTipText("<html>Actual Android Virtual Device size of the screen, measured as the screen's diagonal</html>");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setText("Screensize:");
        jPanel4.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setText("RAM:");
        jPanel5.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRamField = storageField = new StorageField();
        storageField.setToolTipText("<html>The amount of physical RAM on the device.</html>");
        jPanel5.add((Component)storageField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setText("Navigation Style:");
        jPanel6.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myNavigationControlsCombo;
        jComboBox.setToolTipText("<html>No Navigation - No navigational controls  <br>Directional Pad - Enables direction pad support in emulator <br>Trackball - Enables trackball support in emulator</html>");
        jPanel6.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new GridConstraints(3, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel2.add((Component)jSeparator3, new GridConstraints(7, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel2.add((Component)jSeparator4, new GridConstraints(9, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel2.add((Component)jSeparator5, new GridConstraints(13, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel2.add((Component)jSeparator6, new GridConstraints(16, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel2.add((Component)jSeparator7, new GridConstraints(19, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel2.add((Component)jSeparator8, new GridConstraints(25, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        this.myIsScreenRound = jCheckBox = new JCheckBox();
        jCheckBox.setText("Round");
        jCheckBox.setToolTipText("<html>Useful for wear devices with screens that can be round</html>");
        jCheckBox.setSelected(true);
        ((Component)jCheckBox).setEnabled(false);
        jPanel2.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHelpAndErrorLabel = tooltipLabel = new TooltipLabel();
        ((JComponent)((Object)tooltipLabel)).setOpaque(true);
        ((JLabel)((Object)tooltipLabel)).setVerticalTextPosition(1);
        jPanel.add((Component)((Object)tooltipLabel), new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, new Dimension(-1, 100), new Dimension(360, 100), null));
        jBLabel7.setLabelFor(jTextField4);
        jBLabel8.setLabelFor(jTextField3);
        jBLabel9.setLabelFor(jTextField2);
        jBLabel14.setLabelFor(jTextField);
        jBLabel16.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

