/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.ConnectJavaDebuggerTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JFrame;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidJavaDebugger
extends AndroidDebuggerImplBase<AndroidDebuggerState> {
    public static final String ID = "Java";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android Debugger (%s)";
    public static final Set<Class<? extends XBreakpointType<?, ?>>> JAVA_BREAKPOINT_TYPES = ImmutableSet.of(JavaLineBreakpointType.class, JavaMethodBreakpointType.class, JavaFieldBreakpointType.class);

    public AndroidJavaDebugger() {
        super(JAVA_BREAKPOINT_TYPES);
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getId"));
        }
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public AndroidDebuggerState createState() {
        AndroidDebuggerState androidDebuggerState = new AndroidDebuggerState();
        if (androidDebuggerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "createState"));
        }
        return androidDebuggerState;
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<AndroidDebuggerState> createConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "createConfigurable"));
        }
        AndroidDebuggerConfigurable<AndroidDebuggerState> androidDebuggerConfigurable = new AndroidDebuggerConfigurable<AndroidDebuggerState>();
        if (androidDebuggerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "createConfigurable"));
        }
        return androidDebuggerConfigurable;
    }

    @Override
    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull AndroidDebuggerState state, @NotNull String runConfigTypeId) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        if (applicationIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIds", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        if (runConfigTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigTypeId", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        ConnectJavaDebuggerTask connectJavaDebuggerTask = new ConnectJavaDebuggerTask(applicationIds, this, env.getProject());
        if (connectJavaDebuggerTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "getConnectDebuggerTask"));
        }
        return connectJavaDebuggerTask;
    }

    @Override
    public boolean supportsProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "supportsProject"));
        }
        return true;
    }

    @Override
    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "attachToClient"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "attachToClient"));
        }
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        String runConfigName = String.format(RUN_CONFIGURATION_NAME_PATTERN, debugPort);
        if (AndroidJavaDebugger.findExistingDebugSession(project, debugPort, runConfigName)) {
            return;
        }
        RemoteConfigurationType remoteConfigurationType = RemoteConfigurationType.getInstance();
        ConfigurationFactory factory = remoteConfigurationType.getFactory();
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(runConfigName, factory);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = false;
        ProgramRunnerUtil.executeConfiguration((Project)project, (RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    private static boolean findExistingDebugSession(@NotNull Project project, @NotNull String debugPort, final @NotNull String runConfigName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "findExistingDebugSession"));
        }
        if (debugPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugPort", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "findExistingDebugSession"));
        }
        if (runConfigName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigName", "com/android/tools/idea/run/editor/AndroidJavaDebugger", "findExistingDebugSession"));
        }
        Collection<Object> descriptors = null;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Project targetProject = null;
        for (Project openProject : openProjects) {
            targetProject = openProject;
            descriptors = ExecutionHelper.findRunningConsoleByTitle((Project)targetProject, (NotNullFunction)new NotNullFunction<String, Boolean>(){

                @NotNull
                public Boolean fun(String title) {
                    Boolean bl = runConfigName.equals(title);
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidJavaDebugger$1", "fun"));
                    }
                    return bl;
                }
            });
            if (descriptors.isEmpty()) {
                for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)targetProject).getSessions()) {
                    if (!debugPort.trim().equals(session.getProcess().getConnection().getAddress().trim()) || session.getXDebugSession() == null) continue;
                    descriptors = Collections.singletonList(session.getXDebugSession().getRunContentDescriptor());
                    break;
                }
            }
            if (!descriptors.isEmpty()) break;
        }
        if (descriptors != null && !descriptors.isEmpty()) {
            RunContentDescriptor descriptor = (RunContentDescriptor)descriptors.iterator().next();
            ProcessHandler processHandler = descriptor.getProcessHandler();
            Content content = descriptor.getAttachedContent();
            if (processHandler != null && content != null) {
                Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
                if (processHandler.isProcessTerminated()) {
                    ExecutionManager.getInstance((Project)targetProject).getContentManager().removeRunContent(executor, descriptor);
                } else {
                    if (targetProject != project) {
                        JFrame targetFrame = WindowManager.getInstance().getFrame(targetProject);
                        boolean alwaysOnTop = targetFrame.isAlwaysOnTop();
                        targetFrame.setExtendedState(0);
                        targetFrame.setAlwaysOnTop(true);
                        targetFrame.toFront();
                        targetFrame.requestFocus();
                        targetFrame.setAlwaysOnTop(alwaysOnTop);
                    }
                    content.getManager().setSelectedContent(content);
                    ToolWindow window = ToolWindowManager.getInstance((Project)targetProject).getToolWindow(executor.getToolWindowId());
                    window.activate(null, false, true);
                    return true;
                }
            }
        }
        return false;
    }
}

