/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDirectoryAction;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourcePanel {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private JTextField myValueField;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel myFileNameLabel;
    @Nullable
    private final Module myModule;
    @NotNull
    private final ResourceType myResourceType;
    private Map<String, JCheckBox> myCheckBoxes;
    private String[] myDirNames;
    private final CheckBoxList myDirectoriesList;
    private VirtualFile myResourceDir;
    private ResourceFolderType myFolderType;

    public CreateXmlResourcePanel(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName, @Nullable VirtualFile defaultFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateXmlResourcePanel", "<init>"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourcePanel", "<init>"));
        }
        this(module, resourceType, defaultFile, ResourceFolderType.VALUES);
        if (chooseName) {
            predefinedName = ResourceHelper.prependResourcePrefix(module, predefinedName);
        }
        if (!StringUtil.isEmpty((String)predefinedName)) {
            if (chooseName) {
                this.setChangeNameVisible(true);
            }
            this.myNameField.setText(predefinedName);
        } else {
            this.setChangeNameVisible(true);
        }
        if (!StringUtil.isEmpty((String)predefinedValue)) {
            this.myValueField.setText(predefinedValue);
        } else {
            this.setChangeValueVisible(true);
        }
    }

    public CreateXmlResourcePanel(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable VirtualFile defaultFile, @NotNull ResourceFolderType folderType) {
        String defaultFileName;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateXmlResourcePanel", "<init>"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourcePanel", "<init>"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/actions/CreateXmlResourcePanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myCheckBoxes = Collections.emptyMap();
        this.myDirNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.setChangeNameVisible(false);
        this.setChangeValueVisible(false);
        this.myResourceType = resourceType;
        this.myFolderType = folderType;
        HashSet modulesSet = new HashSet();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (modulesSet.size() > 0);
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.setChangeModuleVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules((Collection)modulesSet);
            this.myModuleCombo.setSelectedModule(module);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceActionBase.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, modulesSet.size() == 1 ? AndroidFacet.getInstance((Module)modulesSet.iterator().next()) : null, this.myResourceDir != null ? PsiManager.getInstance((Project)module.getProject()).findDirectory(this.myResourceDir) : null);
        if (defaultFile == null && (defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(resourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesList = new CheckBoxList();
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesList);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myDirectoriesList);
        decorator.setEditAction(null);
        decorator.disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CreateXmlResourcePanel.this.doAddNewDirectory();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CreateXmlResourcePanel.this.doDeleteDirectory();
            }
        });
        AnActionButton selectAll = new AnActionButton("Select All", null, PlatformIcons.SELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                CreateXmlResourcePanel.this.doSelectAllDirs();
            }
        };
        decorator.addExtraAction(selectAll);
        AnActionButton unselectAll = new AnActionButton("Unselect All", null, PlatformIcons.UNSELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                CreateXmlResourcePanel.this.doUnselectAllDirs();
            }
        };
        decorator.addExtraAction(unselectAll);
        this.myDirectoriesPanel.add(decorator.createPanel());
        this.updateDirectories(true);
        this.addModuleComboActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateXmlResourcePanel.this.updateDirectories(true);
            }
        });
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module.getProject());
        }
    }

    public void addModuleComboActionListener(@NotNull ActionListener actionListener) {
        if (actionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionListener", "org/jetbrains/android/actions/CreateXmlResourcePanel", "addModuleComboActionListener"));
        }
        this.myModuleCombo.addActionListener(actionListener);
    }

    public void resetFromFile(@NotNull VirtualFile file, @NotNull Project project) {
        JCheckBox checkBox;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/actions/CreateXmlResourcePanel", "resetFromFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateXmlResourcePanel", "resetFromFile"));
        }
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (moduleForFile == null) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        if ((checkBox = this.myCheckBoxes.get(parent.getName())) == null) {
            return;
        }
        for (JCheckBox checkBox1 : this.myCheckBoxes.values()) {
            checkBox1.setSelected(false);
        }
        checkBox.setSelected(true);
        this.myFileNameCombo.getEditor().setItem(file.getName());
        this.myPanel.repaint();
    }

    private void doDeleteDirectory() {
        if (this.myResourceDir == null) {
            return;
        }
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        String selectedDirName = this.myDirNames[selectedIndex];
        final VirtualFile selectedDir = this.myResourceDir.findChild(selectedDirName);
        if (selectedDir == null) {
            return;
        }
        VirtualFileDeleteProvider provider = new VirtualFileDeleteProvider();
        provider.deleteElement(new DataContext(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.VIRTUAL_FILE_ARRAY.getName().equals(dataId)) {
                    return new VirtualFile[]{selectedDir};
                }
                return null;
            }
        });
        this.updateDirectories(false);
    }

    private void doSelectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(true);
        }
        this.myDirectoriesList.repaint();
    }

    private void doUnselectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        this.myDirectoriesList.repaint();
    }

    private void doAddNewDirectory() {
        PsiElement[] createdElements;
        if (this.myResourceDir == null) {
            return;
        }
        Module module = this.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        PsiDirectory psiResDir = PsiManager.getInstance((Project)project).findDirectory(this.myResourceDir);
        if (psiResDir != null && (createdElements = new CreateResourceDirectoryAction(this.myFolderType).invokeDialog(project, psiResDir)).length > 0) {
            this.updateDirectories(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDirectories(boolean updateFileCombo) {
        void var11_14;
        AndroidFacet facet;
        Module module = this.getModule();
        List<Object> directories = Collections.emptyList();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            this.myResourceDir = facet.getPrimaryResourceDir();
            if (this.myResourceDir != null) {
                directories = AndroidResourceUtil.getResourceSubdirs(this.myFolderType.getName(), new VirtualFile[]{this.myResourceDir});
            }
        }
        Collections.sort(directories, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile f1, VirtualFile f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        Map<String, JCheckBox> oldCheckBoxes = this.myCheckBoxes;
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        String selectedDirName = selectedIndex >= 0 ? this.myDirNames[selectedIndex] : null;
        ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
        this.myCheckBoxes = new HashMap();
        this.myDirNames = new String[directories.size()];
        int newSelectedIndex = -1;
        int i = 0;
        for (VirtualFile virtualFile : directories) {
            String dirName = virtualFile.getName();
            JCheckBox oldCheckBox = oldCheckBoxes.get(dirName);
            boolean selected = oldCheckBox != null && oldCheckBox.isSelected();
            JCheckBox jCheckBox = new JCheckBox(dirName, selected);
            checkBoxList.add(jCheckBox);
            this.myCheckBoxes.put(dirName, jCheckBox);
            this.myDirNames[i] = dirName;
            if (dirName.equals(selectedDirName)) {
                newSelectedIndex = i;
            }
            ++i;
        }
        String defaultFolderName = this.myFolderType.getName();
        JCheckBox jCheckBox = this.myCheckBoxes.get(defaultFolderName);
        if (jCheckBox == null) {
            JCheckBox jCheckBox2 = new JCheckBox(defaultFolderName);
            checkBoxList.add(0, jCheckBox2);
            this.myCheckBoxes.put(defaultFolderName, jCheckBox2);
            String[] newDirNames = new String[this.myDirNames.length + 1];
            newDirNames[0] = defaultFolderName;
            System.arraycopy(this.myDirNames, 0, newDirNames, 1, this.myDirNames.length);
            this.myDirNames = newDirNames;
        }
        var11_14.setSelected(true);
        this.myDirectoriesList.setModel((ListModel)new CollectionListModel(checkBoxList));
        if (newSelectedIndex >= 0) {
            this.myDirectoriesList.setSelectedIndex(newSelectedIndex);
        }
        if (updateFileCombo) {
            Object oldItem = this.myFileNameCombo.getEditor().getItem();
            HashSet fileNameSet = new HashSet();
            for (VirtualFile virtualFile : directories) {
                for (VirtualFile file : virtualFile.getChildren()) {
                    fileNameSet.add(file.getName());
                }
            }
            ArrayList fileNames = new ArrayList(fileNameSet);
            Collections.sort(fileNames);
            this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
            this.myFileNameCombo.getEditor().setItem(oldItem);
        }
    }

    public ValidationInfo doValidate() {
        String resourceName = this.getResourceName();
        Module selectedModule = this.getModule();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (this.myNameField.isVisible() && resourceName.isEmpty()) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (this.myNameField.isVisible() && !AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.isEmpty()) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.isEmpty()) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesList);
        }
        if (resourceName.equals(ResourceHelper.prependResourcePrefix(this.myModule, null))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule, resourceName, this.myResourceType, directoryNames, fileName);
    }

    public JComponent getPreferredFocusedComponent() {
        String name = this.myNameField.getText();
        if (name.isEmpty() || name.equals(ResourceHelper.prependResourcePrefix(this.myModule, null))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    @NotNull
    public String getResourceName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myResourceType;
        if (resourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getType"));
        }
        return resourceType;
    }

    @NotNull
    public List<String> getDirNames() {
        ArrayList<String> selectedDirs = new ArrayList<String>();
        for (Map.Entry<String, JCheckBox> entry : this.myCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            selectedDirs.add(entry.getKey());
        }
        ArrayList<String> arrayList = selectedDirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getDirNames"));
        }
        return arrayList;
    }

    @NotNull
    public String getFileName() {
        String string = ((String)this.myFileNameCombo.getEditor().getItem()).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getFileName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getName"));
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myValueField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourcePanel", "getValue"));
        }
        return string;
    }

    @Nullable
    public SourceProvider getSourceProvider() {
        return CreateResourceActionBase.getSourceProvider(this.mySourceSetCombo);
    }

    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void setChangeFileNameVisible(boolean isVisible) {
        this.myFileNameLabel.setVisible(isVisible);
        this.myFileNameCombo.setVisible(isVisible);
    }

    private void setChangeValueVisible(boolean isVisible) {
        this.myValueField.setVisible(isVisible);
        this.myValueLabel.setVisible(isVisible);
    }

    private void setChangeNameVisible(boolean isVisible) {
        this.myNameField.setVisible(isVisible);
        this.myNameLabel.setVisible(isVisible);
    }

    private void setChangeModuleVisible(boolean isVisible) {
        this.myModuleLabel.setVisible(isVisible);
        this.myModuleCombo.setVisible(isVisible);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JTextField jTextField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        ModulesComboBox modulesComboBox;
        JTextField jTextField2;
        JBLabel jBLabel6;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        this.myNameLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resource name:");
        jBLabel6.setDisplayedMnemonic('N');
        jBLabel6.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Module:");
        jBLabel5.setDisplayedMnemonic('M');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("File name:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoriesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoriesLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Create the resource in directories:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource value:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValueField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFileNameCombo = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel6.setLabelFor(jTextField2);
        jBLabel5.setLabelFor((Component)modulesComboBox);
        jBLabel4.setLabelFor(jComboBox2);
        jBLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

