/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import icons.GroovyMvcIcons;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.ui.GrailsConfigureSDKDialog;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsConfigureSDKAction
extends DumbAwareAction {
    public GrailsConfigureSDKAction() {
        super(GrailsBundle.message("grails.configure.sdk", new Object[0]), null, GroovyMvcIcons.Grails);
    }

    public void update(AnActionEvent e) {
        if (e.getProject() != null) {
            for (GrailsApplication application : GrailsApplicationManager.getInstance(e.getProject()).getApplications()) {
                if (!application.getVersion().isLessThan(Version.GRAILS_3_0) && GrailsCommandExecutor.getGrailsExecutor(application) != null) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        new GrailsConfigureSDKDialog(project).setGrailsApplication(application).show();
    }
}

