/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.formatter.AbstractGspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspFormattingHelper;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspSpacingProcessor;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;

public class GspBlock
extends AbstractXmlBlock
implements AbstractGspBlock,
GspElementTypes {
    private static final Logger LOG = Logger.getInstance(GspBlock.class);
    private final Indent myIndent;
    private final TextRange myTextRange;
    private final GspFormattingHelper myFormattingHelper;

    public GspBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy);
        this.myTextRange = textRange != null ? textRange : super.getTextRange();
        this.myIndent = indent;
        this.myFormattingHelper = new GspFormattingHelper(this.myXmlFormattingPolicy, this.myNode, this.myTextRange);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "getTextRange"));
        }
        return textRange;
    }

    protected List<Block> buildChildren() {
        if (this.myNode.getElementType() == GSP_DIRECTIVE_ATTRIBUTE_VALUE || this.myNode.getElementType() == JSP_STYLE_COMMENT || this.myNode.getElementType() == GSP_STYLE_COMMENT) {
            return EMPTY;
        }
        if (this.myNode.getFirstChildNode() == null) {
            return EMPTY;
        }
        ArrayList<Block> result = new ArrayList<Block>();
        Wrap attrWrap = Wrap.createWrap((WrapType)GspBlock.getWrapType((int)this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Alignment attrAlignment = Alignment.createAlignment();
        ASTNode child = this.myNode.getFirstChildNode();
        while (child != null) {
            Alignment alignment;
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) || child.getTextLength() == 0) {
                child = child.getTreeNext();
                continue;
            }
            IElementType elementType = child.getElementType();
            Object wrap = elementType == GspElementTypes.GRAILS_TAG_ATTRIBUTE ? attrWrap : null;
            if ((child = this.myFormattingHelper.processChild((List<Block>)result, child, (Wrap)wrap, alignment = elementType == GspElementTypes.GRAILS_TAG_ATTRIBUTE && this.myXmlFormattingPolicy.getShouldAlignAttributes() ? attrAlignment : null, Indent.getNoneIndent())) == null) continue;
            LOG.assertTrue(child.getTreeParent() == this.myNode);
        }
        return result;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "getSpacing"));
        }
        if (child1 instanceof AbstractGspBlock && child2 instanceof AbstractGspBlock) {
            return GspSpacingProcessor.getSpacing(this.myXmlFormattingPolicy, (AbstractGspBlock)child1, (AbstractGspBlock)child2);
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GspXmlRootTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (psiParent instanceof GspTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return false;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean isIncomplete() {
        return this.isIncomplete(this.myNode);
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock", "isIncomplete"));
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || this.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }
}

