/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.java.ReadonlyWhitespaceBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.formatter.AbstractGspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspTextSyntheticBlock;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class GspGroovyBlock
extends AbstractXmlBlock
implements AbstractGspBlock {
    @Nullable
    private final Block myBaseLanguageBlock;
    private final Indent myParentIndent;

    public GspGroovyBlock(ASTNode node, XmlFormattingPolicy policy, Pair<PsiElement, Language> rootBlockInfo, Indent indent) {
        super(node, null, null, policy);
        this.myParentIndent = indent;
        this.myBaseLanguageBlock = policy.getOrCreateBlockFor(rootBlockInfo);
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return true;
    }

    protected List<Block> buildChildren() {
        if (this.myBaseLanguageBlock == null) {
            return Collections.emptyList();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        GspGroovyBlock.extractBlocks(this.myBaseLanguageBlock, this.myNode.getTextRange(), result);
        for (Block block : result) {
            if (!(block instanceof GspTextSyntheticBlock)) continue;
            ((GspTextSyntheticBlock)block).setIndent(this.myParentIndent);
        }
        return result;
    }

    private static boolean extractBlocks(Block parentBlock, TextRange textRange, ArrayList<Block> result) {
        if (textRange.getStartOffset() >= textRange.getEndOffset()) {
            return false;
        }
        TextRange blockRange = parentBlock.getTextRange();
        if (blockRange.getStartOffset() >= textRange.getStartOffset() && blockRange.getEndOffset() <= textRange.getEndOffset()) {
            result.add(parentBlock);
            return true;
        }
        if (blockRange.getEndOffset() < textRange.getStartOffset()) {
            return false;
        }
        if (blockRange.getStartOffset() >= textRange.getEndOffset()) {
            return false;
        }
        List subBlocks = parentBlock.getSubBlocks();
        ArrayList<Block> localResult = new ArrayList<Block>();
        int fromIndex = -1;
        for (int i = 0; i < subBlocks.size(); ++i) {
            Block block = (Block)subBlocks.get(i);
            TextRange subRange = block.getTextRange();
            UnfairTextRange range = new UnfairTextRange(Math.max(textRange.getStartOffset(), subRange.getStartOffset()), Math.min(textRange.getEndOffset(), subRange.getEndOffset()));
            boolean added = GspGroovyBlock.extractBlocks(block, (TextRange)range, localResult);
            if (fromIndex != -1 || !added) continue;
            fromIndex = i;
        }
        if (!localResult.isEmpty()) {
            int firstBlockStartOffset = ((Block)localResult.get(0)).getTextRange().getStartOffset();
            int lastBlockEndOffset = ((Block)localResult.get(localResult.size() - 1)).getTextRange().getEndOffset();
            Indent parentIndent = firstBlockStartOffset > blockRange.getStartOffset() && lastBlockEndOffset < blockRange.getEndOffset() ? Indent.getNoneIndent() : parentBlock.getIndent();
            result.add(new GspTextSyntheticBlock(parentBlock, fromIndex, parentIndent, localResult));
        } else {
            TextRange intersection = blockRange.intersection(textRange);
            if (intersection != null) {
                result.add((Block)new ReadonlyWhitespaceBlock(intersection, null, null, Indent.getNoneIndent()));
            }
        }
        return true;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getSpacing"));
        }
        if (this.myBaseLanguageBlock != null) {
            return this.myBaseLanguageBlock.getSpacing(child1, child2);
        }
        return null;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = super.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getTextRange"));
        }
        return textRange;
    }

    public Indent getIndent() {
        return Indent.getNoneIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex > 0 && this.getSubBlocks().get(newChildIndex - 1) instanceof GspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (newChildIndex == 0 && this.getSubBlocks().get(0) instanceof GspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myBaseLanguageBlock != null) {
            ChildAttributes childAttributes = this.myBaseLanguageBlock.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspGroovyBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public String toString() {
        return this.myNode.getText();
    }

    public static Pair<PsiElement, Language> findPsiRootAt(ASTNode child) {
        FileViewProvider viewProvider = child.getPsi().getContainingFile().getViewProvider();
        PsiFile file = viewProvider.getPsi((Language)GspLanguage.INSTANCE);
        if (!(file instanceof GspFile)) {
            return null;
        }
        int startOffset = child.getTextRange().getStartOffset();
        PsiElement psi = child.getPsi();
        if (psi instanceof GspOuterGroovyElement) {
            GroovyLanguage groovyLanguage = GroovyLanguage.INSTANCE;
            PsiElement declElement = file.getViewProvider().findElementAt(startOffset, (Language)groovyLanguage);
            if (declElement == null) {
                return null;
            }
            return Pair.create((Object)TreeUtil.getFileElement((TreeElement)((TreeElement)declElement.getNode())).getPsi(), (Object)groovyLanguage);
        }
        return null;
    }
}

