/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.gspIndex;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeInfo;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GspIncludeIndex
extends FileBasedIndexExtension<String, Collection<GspIncludeInfo>>
implements DataIndexer<String, Collection<GspIncludeInfo>, FileContent>,
DataExternalizer<Collection<GspIncludeInfo>>,
FileBasedIndex.FileTypeSpecificInputFilter {
    public static final ID<String, Collection<GspIncludeInfo>> NAME = ID.create((String)"GspIncludeIndex");

    @NotNull
    public ID<String, Collection<GspIncludeInfo>> getName() {
        ID<String, Collection<GspIncludeInfo>> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<GspIncludeInfo>, FileContent> getIndexer() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "getIndexer"));
        }
        return gspIncludeIndex;
    }

    public boolean acceptInput(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "acceptInput"));
        }
        return true;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)GspFileType.GSP_FILE_TYPE);
        fileTypeSink.consume((Object)GroovyFileType.GROOVY_FILE_TYPE);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<GspIncludeInfo>> getValueExternalizer() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "getValueExternalizer"));
        }
        return gspIncludeIndex;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "getInputFilter"));
        }
        return gspIncludeIndex;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }

    @Nullable
    private static GspOuterGroovyElement extractGroovyOuterElement(XmlAttributeValue value) {
        PsiElement leftQuote = value.getFirstChild();
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)leftQuote, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_START_DELIMITER)) {
            return null;
        }
        PsiElement element = leftQuote.getNextSibling();
        if (element instanceof GspOuterGroovyElement) {
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)element.getNextSibling(), (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER)) {
                return null;
            }
            return (GspOuterGroovyElement)element;
        }
        if (PsiImplUtil.isLeafElementOfType((PsiElement)element, (IElementType)GspTokenTypes.GEXPR_BEGIN)) {
            PsiElement groovyCodeElement = element.getNextSibling();
            if (!(groovyCodeElement instanceof GspOuterGroovyElement)) {
                return null;
            }
            PsiElement closeBracket = groovyCodeElement.getNextSibling();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)closeBracket, (IElementType)GspTokenTypes.GEXPR_END)) {
                return null;
            }
            PsiElement valueEndDelimiter = closeBracket.getNextSibling();
            if (PsiImplUtil.isLeafElementOfType((PsiElement)valueEndDelimiter, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER)) {
                return (GspOuterGroovyElement)groovyCodeElement;
            }
        }
        return null;
    }

    @NotNull
    public Map<String, Collection<GspIncludeInfo>> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "map"));
        }
        final HashMap<String, Collection<GspIncludeInfo>> res = new HashMap<String, Collection<GspIncludeInfo>>();
        GroovyRecursiveElementVisitor groovyVisitor = new GroovyRecursiveElementVisitor(){

            public void visitArgumentLabel(GrArgumentLabel label) {
                GrMethodCall methodCall;
                if (!"model".equals(label.getName())) {
                    return;
                }
                PsiElement namedArgument = label.getParent();
                if (!(namedArgument instanceof GrNamedArgument)) {
                    return;
                }
                GrExpression modelMap = ((GrNamedArgument)namedArgument).getExpression();
                if (!(modelMap instanceof GrListOrMap)) {
                    return;
                }
                PsiElement eNamedArgumentOwner = namedArgument.getParent();
                if (!(eNamedArgumentOwner instanceof GrNamedArgumentsOwner)) {
                    return;
                }
                GrNamedArgumentsOwner owner = (GrNamedArgumentsOwner)eNamedArgumentOwner;
                boolean isTemplate = false;
                GrNamedArgument view = owner.findNamedArgument("view");
                if (view == null) {
                    view = owner.findNamedArgument("template");
                    isTemplate = true;
                }
                if (view == null) {
                    return;
                }
                GrExpression viewExpression = view.getExpression();
                if (!(viewExpression instanceof GrLiteralImpl)) {
                    return;
                }
                Object value = ((GrLiteralImpl)viewExpression).getValue();
                if (!(value instanceof String)) {
                    return;
                }
                String fileName = GspIncludeIndex.getFileNameByElementValue((String)value);
                if (fileName.isEmpty()) {
                    return;
                }
                if (isTemplate) {
                    fileName = '_' + fileName;
                }
                if ((methodCall = PsiUtil.getMethodCallByNamedParameter((GrNamedArgument)((GrNamedArgument)namedArgument))) == null) {
                    return;
                }
                GrExpression invokedExpression = methodCall.getInvokedExpression();
                if (!(invokedExpression instanceof GrReferenceExpression)) {
                    return;
                }
                GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
                if (qualifier != null && "g".equals(qualifier.getText())) {
                    return;
                }
                GspIncludeIndex.addModelMap(res, fileName, (PsiElement)viewExpression, (GrListOrMap)modelMap);
            }
        };
        PsiFile psiFile = inputData.getPsiFile();
        if (psiFile instanceof GspFile) {
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    if (!tag.getName().startsWith("tmpl:")) {
                        return;
                    }
                    ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
                    if (startTagName == null) {
                        return;
                    }
                    String fileName = GspIncludeIndex.getFileNameByElementValue(startTagName.getText().substring("tmpl:".length()));
                    if (fileName.isEmpty()) {
                        return;
                    }
                    fileName = '_' + fileName;
                    XmlAttribute[] attributes = tag.getAttributes();
                    String[] attrNames = new String[attributes.length];
                    for (int i = 0; i < attributes.length; ++i) {
                        attrNames[i] = attributes[i].getName();
                    }
                    GspIncludeIndex.add(res, fileName, new GspIncludeInfo(startTagName.getStartOffset(), attrNames));
                }

                public void visitXmlAttribute(XmlAttribute modelAttribute) {
                    GrListOrMap map2;
                    if (!"model".equals(modelAttribute.getName())) {
                        return;
                    }
                    XmlTag tag = modelAttribute.getParent();
                    if (!tag.getName().startsWith("g:")) {
                        return;
                    }
                    boolean isTemplate = false;
                    XmlAttributeValue viewValue = GrailsPsiUtil.getAttributeValue(tag, "view");
                    if (viewValue == null) {
                        viewValue = GrailsPsiUtil.getAttributeValue(tag, "template");
                        isTemplate = true;
                    }
                    if (viewValue == null || !GrailsPsiUtil.isSimpleAttribute(viewValue)) {
                        return;
                    }
                    String fileName = GspIncludeIndex.getFileNameByElementValue(viewValue.getValue());
                    if (fileName.isEmpty()) {
                        return;
                    }
                    if (isTemplate) {
                        fileName = '_' + fileName;
                    }
                    if ((map2 = GspIncludeIndex.extractMap(modelAttribute)) == null) {
                        return;
                    }
                    GspIncludeIndex.addModelMap(res, fileName, (PsiElement)viewValue, map2);
                }
            });
            ((GspFile)psiFile).getGroovyLanguageRoot().accept((GroovyElementVisitor)groovyVisitor);
        } else if (psiFile instanceof GroovyFileBase) {
            ((GroovyFileBase)psiFile).accept((GroovyElementVisitor)groovyVisitor);
        }
        HashMap<String, Collection<GspIncludeInfo>> hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "map"));
        }
        return hashMap;
    }

    private static String getFileNameByElementValue(String value) {
        String path = StringUtil.trimEnd((String)value, (String)".gsp");
        path = path.substring(path.lastIndexOf(47) + 1);
        return path.trim();
    }

    @Nullable
    public static GrListOrMap extractMap(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "extractMap"));
        }
        XmlAttributeValue value = attribute.getValueElement();
        if (value == null) {
            return null;
        }
        GspOuterGroovyElement outerGroovyElement = GspIncludeIndex.extractGroovyOuterElement(value);
        if (outerGroovyElement == null) {
            return null;
        }
        PsiElement groovyElement = attribute.getContainingFile().getViewProvider().findElementAt(outerGroovyElement.getTextOffset(), (Language)GroovyLanguage.INSTANCE);
        if (groovyElement == null) {
            return null;
        }
        groovyElement = groovyElement instanceof PsiWhiteSpace ? groovyElement.getNextSibling() : groovyElement.getParent();
        return groovyElement instanceof GrListOrMap ? (GrListOrMap)groovyElement : null;
    }

    private static void addModelMap(Map<String, Collection<GspIncludeInfo>> res, String fileName, PsiElement viewElement, @NotNull GrListOrMap modelMap) {
        if (modelMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMap", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "addModelMap"));
        }
        GrNamedArgument[] namedArguments = modelMap.getNamedArguments();
        if (namedArguments.length == 0) {
            return;
        }
        List<String> arguments = new ArrayList(namedArguments.length);
        for (GrNamedArgument namedArgument : namedArguments) {
            String labelName = GrailsPsiUtil.getPlainLabelName(namedArgument);
            if (labelName == null) continue;
            arguments.add(labelName);
        }
        if (arguments.size() > 255) {
            arguments = arguments.subList(0, 255);
        }
        if (arguments.isEmpty()) {
            return;
        }
        GspIncludeInfo includeInfo = new GspIncludeInfo(viewElement.getTextOffset(), arguments.toArray(new String[arguments.size()]));
        GspIncludeIndex.add(res, fileName, includeInfo);
    }

    private static void add(Map<String, Collection<GspIncludeInfo>> res, String fileName, GspIncludeInfo includeInfo) {
        ArrayList<GspIncludeInfo> list = (ArrayList<GspIncludeInfo>)res.get(fileName);
        if (list == null) {
            list = new ArrayList<GspIncludeInfo>();
            res.put(fileName, list);
        }
        if (list.size() < 255) {
            list.add(includeInfo);
        }
    }

    public void save(@NotNull DataOutput out, Collection<GspIncludeInfo> value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "save"));
        }
        assert (value.size() <= 255);
        out.writeByte(value.size());
        for (GspIncludeInfo aValue : value) {
            out.writeInt(aValue.getOffset());
            String[] argumentNames = aValue.getNamedArguments();
            assert (argumentNames.length <= 255);
            out.writeByte(argumentNames.length);
            for (String s : argumentNames) {
                out.writeUTF(s);
            }
        }
    }

    public Collection<GspIncludeInfo> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex", "read"));
        }
        int length = in.readUnsignedByte();
        ArrayList<GspIncludeInfo> res = new ArrayList<GspIncludeInfo>(length);
        for (int i = 0; i < length; ++i) {
            int offset = in.readInt();
            int namedArgumentCount = in.readUnsignedByte();
            String[] namedArguments = new String[namedArgumentCount];
            for (int k = 0; k < namedArgumentCount; ++k) {
                namedArguments[k] = in.readUTF();
            }
            res.add(new GspIncludeInfo(offset, namedArguments));
        }
        return res;
    }
}

