/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;

public class ContextPathReferenceProvider
extends PsiReferenceProvider {
    public static PsiReference[] createReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        return ContextPathReferenceProvider.createReferences(element, text, offset);
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element, @NotNull String text, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "createReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "createReferences"));
        }
        String trimedUrl = PathReference.trimPath((String)text);
        if (trimedUrl.trim().length() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        PluginSupportFileReferenceSet set = new PluginSupportFileReferenceSet(trimedUrl, element, offset, null, true, false, true){

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                VirtualFile root;
                if (!this.isAbsolutePathReference()) {
                    Set<PsiFileSystemItem> set = Collections.emptySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider$1", "computeDefaultContexts"));
                    }
                    return set;
                }
                VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(this.getElement());
                if (appDir == null) {
                    Set<PsiFileSystemItem> set = Collections.emptySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider$1", "computeDefaultContexts"));
                    }
                    return set;
                }
                PsiManager manager = this.getElement().getManager();
                ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>(2);
                VirtualFile view = appDir.findChild("views");
                if (view != null) {
                    ContainerUtil.addIfNotNull((Object)manager.findDirectory(view), res);
                }
                if ((root = appDir.getParent()) != null) {
                    ContainerUtil.addIfNotNull((Object)manager.findDirectory(root), res);
                }
                ArrayList<PsiFileSystemItem> arrayList = res;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider$1", "computeDefaultContexts"));
                }
                return arrayList;
            }
        };
        return set.getAllReferences();
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = ContextPathReferenceProvider.createReferences(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

