/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.detachedCriteria.DetachedCriteriaUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GormDynamicFinderCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(GormDynamicFinderCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiClass domainClass;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider", "addCompletions"));
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)parameters.getPosition().getParent();
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return;
        }
        PsiType type = GroovyCompletionUtil.getQualifierType((PsiElement)qualifier);
        if (!(type instanceof PsiClassType)) {
            return;
        }
        if (GormDynamicFinderCompletionProvider.isStaticMemberReference(qualifier)) {
            domainClass = ((PsiClassType)type).resolve();
            if (!GormUtils.isGormBean(domainClass)) {
                return;
            }
            assert (domainClass != null);
        } else {
            domainClass = DetachedCriteriaUtil.getDomainClassByDetachedCriteriaExpression(type);
            if (domainClass == null) {
                return;
            }
        }
        if (refExpr.getReferenceName() != null) {
            DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
            GormDynamicFinderCompletionProvider.addDynamicFinderMethods(result, descriptor, result.getPrefixMatcher().getPrefix());
        }
    }

    public static boolean isStaticMemberReference(GrExpression qual) {
        PsiReference ref = qual.getReference();
        if (ref == null) {
            return false;
        }
        return ref.resolve() instanceof PsiClass;
    }

    private static void addDynamicFinderMethods(CompletionResultSet result, DomainDescriptor descriptor, String pref) {
        String[] names = ArrayUtil.toStringArray(descriptor.getPersistentProperties().keySet());
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringUtil.capitalize((String)names[i]);
        }
        String p = GormDynamicFinderCompletionProvider.findPrefix(pref, 0, DomainClassUtils.FINDER_PREFIXES);
        if (p == null) {
            for (String prefix : DomainClassUtils.FINDER_PREFIXES) {
                GormDynamicFinderCompletionProvider.addIncompleteLookup(result, prefix, descriptor);
            }
            return;
        }
        int offset = p.length();
        if (p.equals("findOrCreateBy") || p.equals("findOrSaveBy")) {
            GormDynamicFinderCompletionProvider.completeFindOrSave(result, pref, offset, names, descriptor);
            return;
        }
        boolean isGrails2_0 = true;
        GrailsStructure structure = GrailsStructure.getInstance((PsiElement)descriptor.getDomainClass());
        if (structure != null) {
            isGrails2_0 = structure.isAtLeastGrails1_4();
        }
        String[] expressions = isGrails2_0 ? DomainClassUtils.DOMAIN_FINDER_EXPRESSIONS_2_0 : DomainClassUtils.DOMAIN_FINDER_EXPRESSIONS_OLD;
        String connector = null;
        while (true) {
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, names)) == null) {
                for (String name : names) {
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result, pref.substring(0, offset) + name, descriptor);
                }
                break;
            }
            offset += p.length();
            int notLength = 0;
            p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, expressions);
            if (p == null && pref.startsWith("Not", offset)) {
                notLength = "Not".length();
                p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset + 3, expressions);
            }
            if (p == null) {
                if (GormDynamicFinderCompletionProvider.findPrefix(pref, offset, DomainClassUtils.DOMAIN_CONNECTIVES) == null) {
                    String start = pref.substring(0, offset);
                    GormDynamicFinderCompletionProvider.addCompletedLookup(result, start, descriptor);
                    for (String expression : expressions) {
                        if (expression.equals("Equal")) continue;
                        if (expression.equals("NotEqual")) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + expression, descriptor);
                            continue;
                        }
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + expression, descriptor);
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + "Not" + expression, descriptor);
                    }
                    if (connector == null) {
                        for (String c : DomainClassUtils.DOMAIN_CONNECTIVES) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + c, descriptor);
                        }
                        break;
                    }
                    if (!isGrails2_0) break;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + connector, descriptor);
                    break;
                }
            } else {
                offset += p.length() + notLength;
            }
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, DomainClassUtils.DOMAIN_CONNECTIVES)) == null) {
                String start = pref.substring(0, offset);
                GormDynamicFinderCompletionProvider.addCompletedLookup(result, start, descriptor);
                if (connector == null) {
                    for (String name : names) {
                        for (String c : DomainClassUtils.DOMAIN_CONNECTIVES) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + c + name, descriptor);
                        }
                    }
                } else {
                    if (!isGrails2_0) break;
                    for (String name : names) {
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + connector + name, descriptor);
                    }
                }
                break;
            }
            if (connector == null) {
                connector = p;
            } else if (!isGrails2_0) {
                GormDynamicFinderCompletionProvider.addCompletedLookup(result, pref.substring(0, offset), descriptor);
                break;
            }
            offset += p.length();
        }
    }

    private static void completeFindOrSave(CompletionResultSet result, String pref, int offset, String[] names, @NotNull DomainDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider", "completeFindOrSave"));
        }
        THashSet alreadyUsed = new THashSet();
        while (true) {
            String p;
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, names)) == null) {
                for (String name : names) {
                    if (alreadyUsed.contains(name)) continue;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result, pref.substring(0, offset) + name, descriptor);
                }
                break;
            }
            alreadyUsed.add(p);
            if (pref.startsWith("Equal", offset += p.length())) {
                offset += "Equal".length();
            }
            if (!pref.startsWith("And", offset)) {
                String start = pref.substring(0, offset);
                GormDynamicFinderCompletionProvider.addCompletedLookup(result, start, descriptor);
                for (String name : names) {
                    if (alreadyUsed.contains(name)) continue;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result, start + "And" + name, descriptor);
                }
                return;
            }
            offset += "And".length();
        }
    }

    @Nullable
    private static String findPrefix(String s, int offset, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix, offset)) continue;
            return prefix;
        }
        return null;
    }

    private static void addCompletedLookup(CompletionResultSet result, String text, @NotNull DomainDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider", "addCompletedLookup"));
        }
        GrLightMethodBuilder method = DomainMembersProvider.parseFinderMethod(text, descriptor);
        if (method == null) {
            LOG.error("Invalid method name generated: " + text);
            return;
        }
        GrParameter[] parameters = method.getParameters();
        if (parameters.length > 0 && parameters[parameters.length - 1].isOptional()) {
            method.getParameterList().removeParameter(parameters.length - 1);
        }
        result.addElement(GroovyCompletionUtil.createLookupElement((PsiNamedElement)method));
    }

    private static void addIncompleteLookup(CompletionResultSet result, String text, @NotNull DomainDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider", "addIncompleteLookup"));
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)text).withIcon(JetgroovyIcons.Groovy.Method);
        String typeText = "";
        if (text.startsWith("findAll")) {
            typeText = "List<" + descriptor.getDomainClass().getName() + ">";
        } else if (text.startsWith("count")) {
            typeText = "int";
        } else if (text.startsWith("find")) {
            typeText = descriptor.getDomainClass().getName();
        }
        element = element.withTypeText(typeText);
        element = element.withTailText("...", true);
        element = element.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor()));
            }
        });
        result.addElement((LookupElement)element);
    }
}

