/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.spring.InjectedSpringBeanProvider;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class SpringBeanReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SpringBeanReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/grails/spring/SpringBeanReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/grails/spring/SpringBeanReferenceSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return;
        }
        CommonSpringBean bean = SpringBeanUtils.getInstance().findBean(element);
        if (bean == null) {
            return;
        }
        String name = bean.getBeanName();
        if (name == null) {
            return;
        }
        Project project = element.getProject();
        GlobalSearchScope originalScope = (GlobalSearchScope)scope;
        GlobalSearchScope dirScope = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile appRoot;
            if (!originalScope.isSearchInModuleContent(module) || (appRoot = GrailsFramework.getInstance().findAppRoot(module)) == null) continue;
            dirScope = SpringBeanReferenceSearcher.unionWithDir(dirScope, project, appRoot.findChild("grails-app"));
            dirScope = SpringBeanReferenceSearcher.unionWithDir(dirScope, project, appRoot.findChild("test"));
        }
        if (dirScope == null) {
            return;
        }
        for (Module module : GroovyShortNamesCache.getGroovyShortNamesCache((Project)project).getFieldsByName(name, originalScope.intersectWith(dirScope))) {
            SpringBeanPointer pointer = InjectedSpringBeanProvider.getInjectedBean((PsiVariable)module);
            if (pointer == null || !bean.equals(pointer.getSpringBean())) continue;
            consumer.process((Object)new PsiReferenceBase<PsiField>((PsiField)module, true, (PsiField)module){
                final /* synthetic */ PsiField val$psiField;
                {
                    this.val$psiField = psiField;
                    super((PsiElement)x0, x1);
                }

                public PsiElement resolve() {
                    return this.val$psiField;
                }

                protected TextRange calculateDefaultRangeInElement() {
                    PsiIdentifier id = this.val$psiField.getNameIdentifier();
                    return TextRange.from((int)id.getStartOffsetInParent(), (int)id.getTextLength());
                }

                public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                    this.setRangeInElement(null);
                    return this.val$psiField;
                }

                @NotNull
                public Object[] getVariants() {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/SpringBeanReferenceSearcher$1", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
            });
        }
    }

    @Nullable
    private static GlobalSearchScope unionWithDir(@Nullable GlobalSearchScope scope, Project project, @Nullable VirtualFile dir) {
        if (dir == null) {
            return scope;
        }
        GlobalSearchScope s = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)dir, (boolean)true);
        return scope == null ? s : scope.uniteWith(s);
    }
}

