/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.impl;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.structure.GrailsModuleBasedApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public class Grails2Application
extends GrailsModuleBasedApplication {
    public Grails2Application(@NotNull VirtualFile root, @NotNull Module module) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/impl/Grails2Application", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/structure/impl/Grails2Application", "<init>"));
        }
        super(module, root);
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.getApplicationPropertiesName();
        if (name == null) {
            name = this.getModule().getName();
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/impl/Grails2Application", "getName"));
        }
        return string;
    }

    @Nullable
    public Version getApplicationPropertiesVersion() {
        PropertiesFile properties = this.getApplicationProperties();
        if (properties == null) {
            return null;
        }
        String version = Grails2Application.getPropertyValue(properties, "app.grails.version");
        return StringUtil.isEmptyOrSpaces((String)version) ? null : new VersionImpl(version);
    }

    @Nullable
    public String getApplicationPropertiesName() {
        return (String)ApplicationManager.getApplication().runReadAction(this::doGetApplicationPropertiesName);
    }

    @Nullable
    private String doGetApplicationPropertiesName() {
        PropertiesFile properties = this.getApplicationProperties();
        if (properties == null) {
            return null;
        }
        String name = Grails2Application.getPropertyValue(properties, "app.name");
        return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
    }

    @Nullable
    private static String getPropertyValue(@Nullable PropertiesFile properties, @NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/grails/structure/impl/Grails2Application", "getPropertyValue"));
        }
        if (properties == null) {
            return null;
        }
        IProperty property = properties.findPropertyByKey(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public boolean isRunForked() {
        String res = GrailsSettingsService.getGrailsSettings((Module)this.getModule()).properties.get("grails.project.fork.run");
        return Boolean.valueOf(res);
    }

    public boolean isTestForked() {
        String res = GrailsSettingsService.getGrailsSettings((Module)this.getModule()).properties.get("grails.project.fork.test");
        return Boolean.valueOf(res);
    }
}

