/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util.version;

import org.jetbrains.annotations.Nullable;

public class Range<T extends Comparable<T>> {
    @Nullable
    protected T myStart;
    protected boolean myStartInclusive = true;
    @Nullable
    protected T myEnd;
    protected boolean myEndInclusive = true;

    @Nullable
    public T getStart() {
        return this.myStart;
    }

    public Range<T> setStart(@Nullable T start) {
        this.myStart = start;
        return this;
    }

    public boolean isStartInclusive() {
        return this.myStartInclusive;
    }

    public Range<T> setStartInclusive(boolean startInclusive) {
        this.myStartInclusive = startInclusive;
        return this;
    }

    @Nullable
    public T getEnd() {
        return this.myEnd;
    }

    public Range<T> setEnd(@Nullable T end) {
        this.myEnd = end;
        return this;
    }

    public boolean isEndInclusive() {
        return this.myEndInclusive;
    }

    public Range<T> setEndInclusive(boolean endInclusive) {
        this.myEndInclusive = endInclusive;
        return this;
    }

    public boolean contains(T object) {
        return !(this.myStart != null && this.myStart.compareTo(object) >= (this.myStartInclusive ? 1 : 0) || this.myEnd != null && object.compareTo(this.myEnd) >= (this.myEndInclusive ? 1 : 0));
    }

    public String toString() {
        return String.valueOf(this.myStartInclusive ? (char)'[' : '(') + this.myStart + ", " + this.myEnd + (this.myEndInclusive ? (char)']' : ')');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.myStartInclusive != range.myStartInclusive) {
            return false;
        }
        if (this.myEndInclusive != range.myEndInclusive) {
            return false;
        }
        if (this.myStart != null ? !this.myStart.equals(range.myStart) : range.myStart != null) {
            return false;
        }
        return !(this.myEnd != null ? !this.myEnd.equals(range.myEnd) : range.myEnd != null);
    }

    public int hashCode() {
        int result = this.myStart != null ? this.myStart.hashCode() : 0;
        result = 31 * result + (this.myStartInclusive ? 1 : 0);
        result = 31 * result + (this.myEnd != null ? this.myEnd.hashCode() : 0);
        result = 31 * result + (this.myEndInclusive ? 1 : 0);
        return result;
    }
}

