/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.Util;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncLocalVsRemoteAction
extends LocalVsRemoteActionBase {
    private static final Logger LOG = Logger.getInstance((String)SyncLocalVsRemoteAction.class.getName());
    @NonNls
    public static final String DIFF_TITLE = "recursive compare window title";
    @NonNls
    public static final String SYNC_LOAD_COMPONENT = "syncLoadComponent";

    public SyncLocalVsRemoteAction() {
        super(WDBundle.message("sync.with.local.version", new Object[0]));
    }

    @Override
    protected LocalVsRemoteActionBase.LocalData getDataIfEnabledOnProjectView(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = SyncLocalVsRemoteAction.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        WebServerConfig server = publishConfig.findDefaultServer();
        if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return null;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length == 0) {
            return null;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctFiles = new VfsUtilCore.DistinctVFilesRootsCollection(files);
        ArrayList<LocalMappingDiffRoot> filesMap = new ArrayList<LocalMappingDiffRoot>(files.length);
        for (VirtualFile file : distinctFiles) {
            DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, server, true).getFirst();
            if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            filesMap.add(LocalMappingDiffRoot.create(file, mapping));
        }
        if (!filesMap.isEmpty()) {
            return new LocalVsRemoteActionBase.LocalData(project, server, filesMap);
        }
        return null;
    }

    @Override
    protected LocalVsRemoteActionBase.RemoteData getRemoteDataIfEnabledOnRemoteHostView(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = SyncLocalVsRemoteAction.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        WebServerConfig server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(event.getDataContext());
        if (server == null) {
            return null;
        }
        ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (serverNodes == null || serverNodes.length == 0) {
            return null;
        }
        DistinctRootsCollections.ServerTreeNodes distinctServerNodes = new DistinctRootsCollections.ServerTreeNodes(serverNodes, server.isCaseSensitive());
        PublishConfig config = PublishConfig.getInstance(project);
        ArrayList<DiffRoot> files = new ArrayList<DiffRoot>(serverNodes.length);
        Iterator iterator = distinctServerNodes.iterator();
        while (iterator.hasNext()) {
            DeploymentPathMapping mapping;
            ServerTreeNode node = (ServerTreeNode)((Object)iterator.next());
            FileObject fileObject = node.getFileObject();
            if (fileObject == null || (mapping = (DeploymentPathMapping)config.getNearestMappingDeploy2Local(fileObject, false, server, true).getFirst()) == null) continue;
            String localPath = mapping.mapToLocalPath(fileObject.getName(), server);
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(localPath);
            files.add(DiffRoot.create(vFile, fileObject, mapping));
        }
        if (files.isEmpty()) {
            return null;
        }
        RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(event.getDataContext());
        LOG.assertTrue(connection != null);
        return new LocalVsRemoteActionBase.RemoteData(project, server, files, connection);
    }

    @Override
    protected LocalVsRemoteTaskBase createTask(final LocalVsRemoteActionBase.LocalData data) {
        return new SyncTask<LocalMappingDiffRoot>(data.project, data.server, WDBundle.message("sync.with.server.version", new Object[0]), ToolWindowId.PROJECT_VIEW, new ArrayList<LocalMappingDiffRoot>(data.myDiffRoots)){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, LocalMappingDiffRoot pair) throws FileSystemException {
                FileObject remote = LocalVsRemoteActionBase.getRemoteItem(context, pair.getMapping(), pair.getLocal(), data.server);
                return DiffRoot.create(pair.getLocal(), remote, pair.getMapping());
            }
        };
    }

    @Override
    @Nullable
    protected LocalVsRemoteTaskBase createTask(LocalVsRemoteActionBase.RemoteData data) {
        return new SyncTask<DiffRoot>(data.project, data.server, WDBundle.message("sync.with.server.version", new Object[0]), WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW, new ArrayList<DiffRoot>(data.files)){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, DiffRoot pair) throws FileSystemException {
                return pair;
            }
        };
    }

    @Override
    protected String getProjectViewTitle(@NotNull WebServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction", "getProjectViewTitle"));
        }
        return WDBundle.message("sync.with.server.0.version", serverConfig.getName());
    }

    public static boolean isExcludedFileHidden(DirDiffSettings settings) {
        Object value = settings.customSettings.get("hide excluded files");
        LOG.assertTrue(value != null);
        return (Boolean)value;
    }

    private static class ToggleExcludedPathsAction
    extends ToggleAction
    implements DirDiffModelHolder {
        @NonNls
        private static final String HIDE_EXCLUDED_FILES = "hide excluded files";
        private DirDiffModel myModel;
        private Boolean myInitialSelected;

        private ToggleExcludedPathsAction(Boolean initialSelected) {
            super(WDBundle.message("hide.excluded.files", new Object[0]), WDBundle.message("remove.excluded.files.from.comparison", new Object[0]), AllIcons.General.Filter);
            this.myInitialSelected = initialSelected;
        }

        public void setModel(DirDiffModel model) {
            this.myModel = model;
            this.myModel.getSettings().customSettings.put(HIDE_EXCLUDED_FILES, this.myInitialSelected == null ? true : this.myInitialSelected);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (this.myModel instanceof DirDiffTableModel) {
                e.getPresentation().setEnabled(!((DirDiffTableModel)this.myModel).isUpdating());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myModel.getSettings().customSettings.put(HIDE_EXCLUDED_FILES, state);
            this.myModel.reloadModel(false);
        }

        public boolean isSelected() {
            Object value = this.myModel.getSettings().customSettings.get(HIDE_EXCLUDED_FILES);
            return value instanceof Boolean ? (Boolean)value : true;
        }
    }

    private static abstract class SyncTask<T extends LocalMappingDiffRoot>
    extends LocalVsRemoteTaskBase<T> {
        protected SyncTask(@NotNull Project project, WebServerConfig server, String title, String toolWindowId, List<T> localFiles) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask", "<init>"));
            }
            super(project, title, server, toolWindowId, localFiles);
        }

        @Override
        protected boolean execute(List<DiffRoot> roots, ExecutionContextBase context, RemoteConnection remoteConnection) {
            DiffElement localDiffElement;
            DiffElement remoteDiffElement;
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            ArrayList<Document> docsToSave = new ArrayList<Document>();
            block2: for (Document document : mgr.getUnsavedDocuments()) {
                VirtualFile file = mgr.getFile(document);
                if (file == null || !file.isValid()) continue;
                for (DiffRoot pair : roots) {
                    if (pair.getLocal() == null || !VfsUtilCore.isAncestor((VirtualFile)pair.getLocal(), (VirtualFile)file, (boolean)false)) continue;
                    docsToSave.add(document);
                    continue block2;
                }
            }
            if (!docsToSave.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    for (Document document : docsToSave) {
                        mgr.saveDocument(document);
                    }
                }, ModalityState.defaultModalityState());
            }
            RemoteConnection connectionForDiff = remoteConnection.clone();
            PublishConfig config = PublishConfig.getInstance(this.getProject());
            WebServerConfig serverConfig = context.getServer();
            DirDiffSettings settings = new DirDiffSettings();
            SyncUtils.initializeExcludedFromProjectFiles(settings, roots, serverConfig, this.myProject);
            try {
                remoteDiffElement = CompositeDiffElement.createRootRemoteDiffElement(roots, serverConfig, settings, this.getProject(), connectionForDiff);
                localDiffElement = CompositeDiffElement.createRootLocalDiffElement(roots, config, serverConfig, settings, this.getProject());
            }
            catch (FileSystemException e) {
                connectionForDiff.release();
                LOG.warn((Throwable)e);
                Util.showBalloonError(this.myProject, this.myToolWindowId, PublishUtils.getMessage(e, false));
                return false;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                DirDiffManager diffManager = DirDiffManager.getInstance((Project)this.myProject);
                if (diffManager.canShow(localDiffElement, remoteDiffElement)) {
                    ToggleExcludedPathsAction toggleExcludedPathsAction = new ToggleExcludedPathsAction(!config.isShowExcludedInSync());
                    settings.addExtraAction((AnAction)toggleExcludedPathsAction);
                    settings.compareTimestampAccuracy = SyncTask.getTimestampAccuracy(roots);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Compare timestamp accuracy is " + settings.compareTimestampAccuracy);
                    }
                    settings.compareMode = config.getCompareModeInSync();
                    settings.showDifferent = config.isShowDifferentInSync();
                    settings.showEqual = config.isShowEqualInSync();
                    settings.showNewOnSource = config.isShowNewOnSourceInSync();
                    settings.showNewOnTarget = config.isShowNewOnTargetInSync();
                    settings.customSourceChooser = new DirDiffSettings.CustomSourceChooser(){

                        public DiffElement chooseSource(@NotNull DiffElement first, @NotNull DiffElement second) {
                            if (first == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask$1", "chooseSource"));
                            }
                            if (second == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask$1", "chooseSource"));
                            }
                            long firstTimestamp = first.getTimeStamp();
                            long secondTimestamp = second.getTimeStamp();
                            if (firstTimestamp < 0L || secondTimestamp < 0L || firstTimestamp == secondTimestamp) {
                                return null;
                            }
                            return firstTimestamp > secondTimestamp ? first : second;
                        }
                    };
                    settings.customSettings.put(SyncLocalVsRemoteAction.SYNC_LOAD_COMPONENT, new SyncLoadComponent(this.myProject, config, serverConfig));
                    settings.customSettings.put(SyncLocalVsRemoteAction.DIFF_TITLE, WDBundle.message("diff.between.0.and.1", localDiffElement.getPresentablePath(), remoteDiffElement.getPresentablePath()));
                    settings.customSettings.put("Compare mode name provider", new DirDiffSettings.CompareModeNameProvider(){

                        @Nullable
                        public String getName(DirDiffSettings.CompareMode mode) {
                            if (mode == DirDiffSettings.CompareMode.TIMESTAMP) {
                                return WDBundle.message("sync.mode.name.size.and.timestamp", new Object[0]);
                            }
                            return null;
                        }
                    });
                    Runnable onWindowClose = () -> {
                        connectionForDiff.release();
                        DirDiffSettings.CompareMode mode = settings.compareMode;
                        config.setCompareModeInSync(mode);
                        config.setShowDifferentInSync(settings.showDifferent);
                        config.setShowEqualInSync(settings.showEqual);
                        config.setShowNewOnSourceInSync(settings.showNewOnSource);
                        config.setShowNewOnTargetInSync(settings.showNewOnTarget);
                        config.setShowExcludedInSync(!toggleExcludedPathsAction.isSelected());
                    };
                    diffManager.showDiff(localDiffElement, remoteDiffElement, settings, onWindowClose);
                }
            });
            return true;
        }

        private static double getTimestampAccuracy(List<DiffRoot> files) {
            double result = 0.0;
            FileObject local = null;
            FileObject remote = null;
            for (DiffRoot file : files) {
                if (local == null && file.getLocal() != null && (local = DeploymentPathUtils.getLocalFile(file.getLocal().getPath())) != null) {
                    result += local.getFileSystem().getLastModTimeAccuracy();
                }
                if (remote == null && (remote = file.getRemote()) != null) {
                    result += remote.getFileSystem().getLastModTimeAccuracy();
                }
                if (local == null || remote == null) continue;
                return result;
            }
            return result;
        }
    }
}

