/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseScenarioStep
extends BaseStep {
    private static final Logger LOG = Logger.getInstance((String)ChooseScenarioStep.class.getName());
    private JPanel myContentPane;
    private JRadioButton myLocalServerRB;
    private JRadioButton myMountedServerRB;
    private JRadioButton myRemoteServerRB;
    private JRadioButton myNoServerRB;
    private JRadioButton myMountedServerSecondRB;
    public static final Object ID = ChooseScenarioStep.class;

    public ChooseScenarioStep(CreateProjectModel model) {
        super(WDBundle.message("create.web.project.choose.scenario.step.title", new Object[0]), model);
        this.$$$setupUI$$$();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseScenarioStep.this.fireStateChanged();
            }
        };
        this.myLocalServerRB.addActionListener(l);
        this.myMountedServerRB.addActionListener(l);
        this.myMountedServerSecondRB.addActionListener(l);
        this.myRemoteServerRB.addActionListener(l);
        this.myNoServerRB.addActionListener(l);
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseScenarioStep", "getStepId"));
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        if (this.myNoServerRB.isSelected()) {
            return FileChooserStep.ID_NO_SERVER;
        }
        if (this.myLocalServerRB.isSelected()) {
            return FileChooserStep.ID_LOCAL_SERVER;
        }
        return SpecifyLocalPathStep.ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return true;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        this.myModel.scenario = this.getScenario();
    }

    private CreateProjectModel.Scenario getScenario() {
        if (this.myLocalServerRB.isSelected()) {
            return CreateProjectModel.Scenario.LocalServer;
        }
        if (this.myMountedServerRB.isSelected()) {
            return CreateProjectModel.Scenario.MountedServer;
        }
        if (this.myMountedServerSecondRB.isSelected()) {
            return CreateProjectModel.Scenario.MountedServer;
        }
        if (this.myRemoteServerRB.isSelected()) {
            return CreateProjectModel.Scenario.FtpSftpServer;
        }
        if (this.myNoServerRB.isSelected()) {
            return CreateProjectModel.Scenario.NoServer;
        }
        LOG.error("No kind of project creation is selected in ChooseScenarioStep");
        return null;
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myLocalServerRB.isSelected()) {
            return this.myLocalServerRB;
        }
        if (this.myMountedServerRB.isSelected()) {
            return this.myMountedServerRB;
        }
        if (this.myMountedServerSecondRB.isSelected()) {
            return this.myMountedServerSecondRB;
        }
        if (this.myRemoteServerRB.isSelected()) {
            return this.myRemoteServerRB;
        }
        if (this.myNoServerRB.isSelected()) {
            return this.myNoServerRB;
        }
        return this.myLocalServerRB;
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.from.existing.files.choose.scenario";
    }

    @Override
    @Nls
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message("create.web.project.choose.scenario.step.summary", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseScenarioStep", "getSummaryText"));
        }
        return string;
    }

    @Override
    protected void doInit() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Select scenario:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalServerRB = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Web server is installed locally, source files are located under its document root.");
        jRadioButton5.setMnemonic('R');
        jRadioButton5.setDisplayedMnemonicIndex(77);
        jRadioButton5.setSelected(true);
        jPanel.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(false);
        jLabel2.setText("You are ready to go without copying anything.");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JLabel jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(false);
        jLabel3.setText("Source files are downloaded to project root, then synchronized with server when necessary.");
        jPanel.add((Component)jLabel3, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myRemoteServerRB = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Web server is on remote host, files are accessible via FTP/SFTP/FTPS.");
        jRadioButton4.setMnemonic('F');
        jRadioButton4.setDisplayedMnemonicIndex(55);
        jPanel.add((Component)jRadioButton4, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel4 = new JLabel();
        ((Component)jLabel4).setEnabled(false);
        jLabel4.setText("Source files are downloaded to project root, then synchronized with server when necessary.");
        jPanel.add((Component)jLabel4, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myNoServerRB = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Source files are in a local directory, no Web server is yet configured.");
        jRadioButton3.setMnemonic('O');
        jRadioButton3.setDisplayedMnemonicIndex(61);
        jRadioButton3.setSelected(false);
        jPanel.add((Component)jRadioButton3, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(12, 0, 1, 1, 0, 2, 3, 0, null, new Dimension(-1, 5), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myMountedServerRB = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Web server is on remote host, files are accessible via network share or mounted drive.");
        jRadioButton2.setMnemonic('S');
        jRadioButton2.setDisplayedMnemonicIndex(63);
        jPanel.add((Component)jRadioButton2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myMountedServerSecondRB = jRadioButton = new JRadioButton();
        jRadioButton.setText("Web server is installed locally, source files are located elsewhere locally.");
        jRadioButton.setMnemonic('W');
        jRadioButton.setDisplayedMnemonicIndex(62);
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel5 = new JLabel();
        ((Component)jLabel5).setEnabled(false);
        jLabel5.setText("Source files are copied to project root, then synchronized with server when necessary.");
        jPanel.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        JLabel jLabel6 = new JLabel();
        ((Component)jLabel6).setEnabled(false);
        jLabel6.setText("A folder with source files is added to project, server synchronization can be set up later.");
        jPanel.add((Component)jLabel6, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

