/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeTransferOperation
extends TransferOperation.Copy {
    private static final Logger LOG = Logger.getInstance((String)MergeTransferOperation.class.getName());
    private static final int MAX_STRING_LENGTH = 10;
    private FileObject mySource;
    private FileObject myTarget;
    private final DeploymentRevisionTracker.Revision myRevision;

    public MergeTransferOperation(@NotNull FileObject source, @NotNull FileObject target, @Nullable DeploymentRevisionTracker.Revision revision) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "<init>"));
        }
        super(source, target);
        this.mySource = source;
        this.myTarget = target;
        this.myRevision = revision;
    }

    @Override
    public String getProgressText(ExecutionContext context) {
        return WDBundle.message("merging.0", context.isServerSideModification() ? context.getServer().getPresentablePath(this.myTarget) : DeploymentPathUtils.getLocalPath(this.myTarget));
    }

    @Override
    public String getDetailedText(ExecutionContext context) {
        if (context.isServerSideModification()) {
            return WDBundle.message("merging.0.with.1", context.getServer().getPresentablePath(this.myTarget), DeploymentPathUtils.getLocalPath(this.mySource));
        }
        return WDBundle.message("merging.0.with.1", DeploymentPathUtils.getLocalPath(this.myTarget), context.getServer().getPresentablePath(this.mySource));
    }

    @Override
    public void execute(ExecutionContext context) throws FileSystemException {
        boolean justLoad;
        if (!this.myTarget.exists()) {
            this.targetNotExist(context);
            return;
        }
        try {
            justLoad = this.myRevision != null && RemoteChangeNotifier.isFileEqualToRevision(this.myTarget, this.myRevision, context);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message("failed.to.load.local.file.0.content", this.myTarget.getName().getPath()));
        }
        if (justLoad) {
            super.execute(context);
            return;
        }
        FileObject localFile = context.isServerSideModification() ? this.mySource : this.myTarget;
        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)localFile.getURL());
        byte[] targetFileContent = MergeTransferOperation.getContent(this.myTarget, true, context.getProgressIndicator());
        Project project = context.getProject();
        byte[] sourceFileContent = MergeTransferOperation.getContent(this.mySource, false, context.getProgressIndicator());
        context.getProgressIndicator().checkCanceled();
        if (this.myRevision == null && this.isFileUpToDate(context, sourceFileContent, targetFileContent)) {
            MergeTransferOperation.createNewRevision(sourceFileContent, this.mySource, fileByURL, project, context.getServer());
            if (project != null && !project.isDefault()) {
                RemoteChangeNotifier.getInstance(project).updateNotifications(fileByURL, context.getConfig(), context.getServer());
            }
            LOG.debug("Up-to-date, creating revision: " + fileByURL.getPath());
            context.console(WDBundle.message("equal.content.just.making.revision", new Object[0]), ConsoleViewContentType.NORMAL_OUTPUT);
            context.incCounter("transfer.details.upToDate");
            return;
        }
        this.mergeFiles(context, fileByURL, targetFileContent, sourceFileContent);
    }

    private void mergeFiles(@NotNull ExecutionContext context, @NotNull VirtualFile fileByURL, @NotNull byte[] targetFileContent, @NotNull byte[] sourceFileContent) throws FileSystemException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "mergeFiles"));
        }
        if (fileByURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileByURL", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "mergeFiles"));
        }
        if (targetFileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFileContent", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "mergeFiles"));
        }
        if (sourceFileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFileContent", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "mergeFiles"));
        }
        Ref result = new Ref();
        Project project = context.getProject();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            byte[] rightContent;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$mergeFiles$0"));
            }
            if (sourceFileContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFileContent", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$mergeFiles$0"));
            }
            if (targetFileContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFileContent", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$mergeFiles$0"));
            }
            if (fileByURL == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileByURL", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$mergeFiles$0"));
            }
            byte[] leftContent = context.isServerSideModification() ? sourceFileContent : targetFileContent;
            TextMergeRequest diffData = this.createMergeRequest(leftContent, rightContent = context.isServerSideModification() ? targetFileContent : sourceFileContent, this.myRevision, fileByURL, context.getServer(), project, (Ref<Boolean>)result);
            if (diffData != null) {
                DiffManager.getInstance().showMerge(project, (MergeRequest)diffData);
            }
        }, ModalityState.NON_MODAL);
        if (Boolean.TRUE == result.get()) {
            String message = WDBundle.message("file.merged", fileByURL.getPath());
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Merged by user: " + fileByURL.getPath());
            context.incCounter("transfer.details.merged");
        } else {
            String message = WDBundle.message("file.merge.skipped", fileByURL.getPath());
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Merge skipped by user: " + fileByURL.getPath());
            context.incCounter("transfer.details.skippedByUser");
        }
        if (project != null && !project.isDefault()) {
            RemoteChangeNotifier.getInstance(project).updateNotifications(fileByURL, context.getConfig(), context.getServer());
        }
    }

    @NotNull
    private static byte[] getContent(FileObject file, boolean isLocal, ProgressIndicator pi) throws CustomFileSystemException {
        byte[] byArray;
        try {
            byArray = FileTransferUtil.getContent(file, pi);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message(isLocal ? "failed.to.load.local.file.0.content" : "failed.to.load.remote.file.0.content", file.getName().getPath()));
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "getContent"));
        }
        return byArray;
    }

    private void targetNotExist(ExecutionContext context) throws FileSystemException {
        Ref load = new Ref();
        if (load.get() == null && this.myRevision != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message = context.isServerSideModification() ? WDBundle.message("deployed.file.0.was.deleted.and.corresponding.local.file.was.changed.upload.it", context.getServer().getPresentablePath(this.myTarget)) : WDBundle.message("local.file.0.was.deleted.and.corresponding.deployed.file.was.changed.download.it", DeploymentPathUtils.getLocalPath(this.myTarget));
                String title = context.isServerSideModification() ? WDBundle.message("upload.to.0", context.getServer().getName()) : WDBundle.message("update.from.0", context.getServer().getName());
                int loadCode = Messages.showDialog((Project)context.getProject(), (String)message, (String)title, (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)0, (Icon)Messages.getQuestionIcon());
                load.set((Object)(0 == loadCode ? 1 : 0));
            }, ModalityState.NON_MODAL);
        }
        if (this.myRevision == null || Boolean.TRUE == load.get()) {
            super.execute(context);
        } else {
            String message = WDBundle.message("file.skipped", context.isServerSideModification() ? context.getServer().getPresentablePath(this.myTarget) : DeploymentPathUtils.getLocalPath(this.myTarget));
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            context.incCounter("transfer.details.skippedByUser");
        }
    }

    private boolean isFileUpToDate(ExecutionContext context, byte[] remoteFileContent, byte[] localFileContent) throws FileSystemException {
        if (context.getConfig().getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = this.mySource.getContent().getLastModifiedTime(accurateTimestamp);
            long currentLocalTimestamp = this.myTarget.getContent().getLastModifiedTime(accurateTimestamp);
            return TransferOperation.areTimestampsEqual(currentLocalTimestamp, currentRemoteTimestamp, this.mySource.getFileSystem().getLastModTimeAccuracy() + this.myTarget.getFileSystem().getLastModTimeAccuracy()) && this.mySource.getContent().getSize() == this.myTarget.getContent().getSize();
        }
        return Arrays.equals(remoteFileContent, localFileContent);
    }

    @Override
    public String getErrorMessage(ExecutionContext context, String reason) {
        return WDBundle.message("failed.to.merge.file.0.1", DeploymentPathUtils.getLocalPath(this.myTarget), StringUtil.decapitalize((String)reason));
    }

    @Override
    public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        this.myTarget = MergeTransferOperation.updateOnParentMove(this.myTarget, sourceFrom, sourceTo);
    }

    private static void createNewRevision(byte[] remoteFileContent, FileObject remoteItem, VirtualFile localFile, Project project, WebServerConfig server) {
        DeploymentRevisionTracker tracker = ProjectDeploymentRevisionTracker.getInstance(project);
        if ((long)remoteFileContent.length <= DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
            try {
                ThrowableComputable revisionFactory = () -> {
                    boolean accurate = server.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                    return new DeploymentRevisionTracker.Revision(remoteItem.getContent().getLastModifiedTime(accurate), remoteFileContent);
                };
                tracker.putBaseRevision(localFile.getPath(), server.clone(), (ThrowableComputable<DeploymentRevisionTracker.Revision, IOException>)revisionFactory);
            }
            catch (IOException e) {
                LOG.warn("Failed to load content of remote file " + remoteItem.getName().getPath(), (Throwable)e);
            }
        } else {
            LOG.warn("File " + localFile.getPath() + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
        }
    }

    @Nullable
    private TextMergeRequest createMergeRequest(@NotNull byte[] localFileContent, @NotNull byte[] remoteContentBytes, @Nullable DeploymentRevisionTracker.Revision revision, @NotNull VirtualFile localFile, @NotNull WebServerConfig server, @Nullable Project project, @NotNull Ref<Boolean> successRef) {
        if (localFileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFileContent", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "createMergeRequest"));
        }
        if (remoteContentBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteContentBytes", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "createMergeRequest"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "createMergeRequest"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "createMergeRequest"));
        }
        if (successRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successRef", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "createMergeRequest"));
        }
        byte[] middleContent = revision == null ? localFileContent : revision.content;
        String windowTitle = WDBundle.message("title.merge.file.0.1", MergeTransferOperation.getPresentableUrl(localFile), server.getName());
        List titles = ContainerUtil.list((Object[])new String[]{WDBundle.message("local.file", new Object[0]), WDBundle.message("merge.on.upload.result.title", new Object[0]), WDBundle.message("remote.file", new Object[0])});
        List byteContents = ContainerUtil.list((Object[])new byte[][]{localFileContent, middleContent, remoteContentBytes});
        Consumer callback = result -> {
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$createMergeRequest$3"));
            }
            if (remoteContentBytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteContentBytes", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$createMergeRequest$3"));
            }
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$createMergeRequest$3"));
            }
            if (successRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successRef", "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation", "lambda$createMergeRequest$3"));
            }
            Document document = FileDocumentManager.getInstance().getCachedDocument(localFile);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (result != MergeResult.CANCEL) {
                MergeTransferOperation.createNewRevision(remoteContentBytes, this.mySource, localFile, project, server);
            }
            successRef.set((Object)(result != MergeResult.CANCEL ? 1 : 0));
        };
        try {
            return DiffRequestFactory.getInstance().createTextMergeRequest(project, localFile, byteContents, windowTitle, titles, callback);
        }
        catch (InvalidDiffRequestException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String getPresentableUrl(VirtualFile localFile) {
        String presentableUrl = localFile.getPresentableUrl();
        if (presentableUrl.length() > 10) {
            int index;
            int backslashIndex;
            int beginning = presentableUrl.length() - 10;
            int slashIndex = presentableUrl.indexOf(47, beginning);
            if (slashIndex == -1) {
                slashIndex = presentableUrl.lastIndexOf(47);
            }
            if ((backslashIndex = presentableUrl.indexOf(92, beginning)) == -1) {
                backslashIndex = presentableUrl.lastIndexOf(92);
            }
            if ((index = slashIndex != -1 && backslashIndex != -1 ? Math.min(slashIndex, backslashIndex) : Math.max(slashIndex, backslashIndex)) != -1) {
                presentableUrl = "..." + presentableUrl.substring(index);
            }
        }
        return presentableUrl;
    }

    @Override
    public String toString() {
        return WDBundle.message("merging.0.with.1", DeploymentPathUtils.getLocalPath(this.myTarget), this.mySource.getName().getPath());
    }
}

