/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FileContentQueue {
    private final Object LOCK = new Object();
    private final LinkedList<RemoteVirtualFile> myQueue = new LinkedList();
    private final Map<RemoteVirtualFile, byte[]> myContentToSave = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<RemoteVirtualFile, byte[]> getNextFile() {
        while (true) {
            Object object = this.LOCK;
            synchronized (object) {
                RemoteVirtualFile virtualFile = this.myQueue.poll();
                if (virtualFile == null) {
                    return null;
                }
                byte[] bytes = this.myContentToSave.remove((Object)virtualFile);
                if (bytes != null) {
                    return Pair.create((Object)((Object)virtualFile), (Object)bytes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFile(RemoteVirtualFile file, byte[] content) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myContentToSave.put(file, content);
            this.myQueue.push(file);
        }
    }

    public ExecutionContext createContext(@NotNull WebServerConfig config, @NotNull Project project, @NotNull ProgressIndicator pi) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/FileContentQueue", "createContext"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/remoteEdit/FileContentQueue", "createContext"));
        }
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/remoteEdit/FileContentQueue", "createContext"));
        }
        return new MyExecutionContext(project, pi, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myQueue.isEmpty() || this.myContentToSave.isEmpty();
        }
    }

    private static class MyExecutionContext
    implements ExecutionContext {
        private final Project myProject;
        private final ProgressIndicator myPi;
        private final WebServerConfig myConfig;

        public MyExecutionContext(Project project, ProgressIndicator pi, WebServerConfig config) {
            this.myProject = project;
            this.myPi = pi;
            this.myConfig = config;
        }

        @Override
        public PublishConfig getConfig() {
            throw new UnsupportedOperationException("getConfig is not supported");
        }

        @Override
        public void incBytesTransmitted(long bytes) {
            throw new UnsupportedOperationException("incBytesTransmitted is not supported");
        }

        @Override
        public void incCounter(@PropertyKey(resourceBundle="messages.WDBundle") String counterTitle) {
            throw new UnsupportedOperationException("incCounter is not supported");
        }

        @Override
        public void console(String message, ConsoleViewContentType type) {
            throw new UnsupportedOperationException("console is not supported");
        }

        @Override
        public boolean isMultipleOperations() {
            throw new UnsupportedOperationException("isMultipleOperations is not supported");
        }

        @Override
        public void showBalloon(String message, MessageType type) {
            throw new UnsupportedOperationException("showBalloon is not supported");
        }

        @Override
        public boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/remoteEdit/FileContentQueue$MyExecutionContext", "promptForOverwrite"));
            }
            throw new UnsupportedOperationException("promptForOverwrite is not supported");
        }

        @Override
        public boolean isServerSideModification() {
            return true;
        }

        @Override
        public boolean isTolerateSetPermissionsErrors() {
            throw new UnsupportedOperationException("isTolerateSetPermissionsErrors is not supported");
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @Override
        public boolean isCancellable() {
            return true;
        }

        @Override
        public DeploymentRevisionTracker getRevisionTracker() {
            throw new UnsupportedOperationException("getRevisionTracker is not supported");
        }

        @Override
        public void setCurrentFileFraction(double fraction) {
            this.myPi.setFraction(fraction);
        }

        @Override
        public void setIgnoreOverwriting(boolean ignore) {
            throw new UnsupportedOperationException("setIgnoreOverwriting is not supported");
        }

        @Override
        public void addAffectedRoot(FileName fileName, boolean remote) {
        }

        @Override
        public ProgressIndicator getProgressIndicator() {
            return this.myPi;
        }

        @Override
        public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
            throw new UnsupportedOperationException("findRemoteFile is not supported");
        }

        @Override
        public WebServerConfig getServer() {
            return this.myConfig;
        }

        @Override
        public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
            throw new UnsupportedOperationException("scheduleForSelection is not supported");
        }

        @Override
        public DeploymentMode getDeploymentMode() {
            throw new UnsupportedOperationException("getDeploymentMode is not supported");
        }
    }
}

