/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileEditorTitleTabProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(Project project, VirtualFile file) {
        String presentableName;
        if (!(file instanceof RemoteVirtualFile)) {
            return null;
        }
        RemoteVirtualFile remoteFile = (RemoteVirtualFile)file;
        WebServerConfig oldServerConfig = remoteFile.getServerConfig();
        String oldServerConfigId = oldServerConfig.getId();
        String uniqueName = RemoteFileEditorTitleTabProvider.getUniqueName(project, file);
        if (uniqueName.startsWith("<" + oldServerConfigId)) {
            String endSeparator = ">";
            int i = uniqueName.indexOf(">");
            uniqueName = uniqueName.substring(i + ">".length());
        }
        String serverName = StringUtil.isNotEmpty((String)(presentableName = remoteFile.getPresentableServerName())) ? presentableName : RemoteFileEditorTitleTabProvider.getServerName(project, oldServerConfig, oldServerConfigId);
        return "<" + serverName + "> " + uniqueName;
    }

    private static String getServerName(@Nullable Project project, @NotNull WebServerConfig oldServerConfig, @Nullable String oldServerConfigId) {
        if (oldServerConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldServerConfig", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteFileEditorTitleTabProvider", "getServerName"));
        }
        WebServerConfig currentServer = WebServersConfigManager.getInstance(project).findServer(oldServerConfigId);
        return currentServer == null ? WDBundle.message("remote.edit.deleted.ex.0", oldServerConfig.getName()) : currentServer.getName();
    }

    @NotNull
    private static String getUniqueName(Project project, VirtualFile file) {
        if (!UISettings.getInstance().SHOW_DIRECTORY_FOR_NON_UNIQUE_FILENAMES || DumbService.isDumb((Project)project)) {
            String string = file.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteFileEditorTitleTabProvider", "getUniqueName"));
            }
            return string;
        }
        String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteFileEditorTitleTabProvider", "getUniqueName"));
        }
        return string;
    }
}

