/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalItemDiffElement
extends VirtualFileDiffElement
implements BackgroundOperatingDiffElement {
    private static final Logger LOG = Logger.getInstance((String)LocalItemDiffElement.class.getName());
    private static final int UNKNOWN_VALUE = -1;
    private static final LocalItemDiffElement[] EMPTY = new LocalItemDiffElement[0];
    private final AtomicBoolean myOperationRunning;
    private PublishConfig myConfig;
    private WebServerConfig myServer;
    private final String myName;
    private final boolean myIsRoot;
    private final DirDiffSettings mySettings;
    private final boolean myExcluded;
    private final Project myProject;
    private final DeploymentPathMapping myMapping;

    public LocalItemDiffElement(@NotNull VirtualFile file, @NotNull DeploymentPathMapping mapping, PublishConfig config, @NotNull WebServerConfig server, boolean excluded, DirDiffSettings settings, @NotNull String name, Project project, boolean isRoot) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        super(file);
        this.myOperationRunning = new AtomicBoolean(false);
        this.myMapping = mapping;
        this.myConfig = config;
        this.myServer = server;
        this.myExcluded = excluded;
        this.mySettings = settings;
        this.myName = name;
        this.myProject = project;
        this.myIsRoot = isRoot;
    }

    public LocalItemDiffElement(@NotNull VirtualFile file, @NotNull DeploymentPathMapping mapping, PublishConfig config, @NotNull WebServerConfig server, boolean excluded, DirDiffSettings settings, Project project, boolean isRoot) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        this(file, mapping, config, server, excluded, settings, CompositeDiffElement.getSimpleRootName(file), project, isRoot);
    }

    public LocalItemDiffElement[] getChildren() {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return EMPTY;
        }
        if (this.getValue().is(VFileProperty.SYMLINK)) {
            return EMPTY;
        }
        VirtualFile[] files = this.getValue().getChildren();
        ArrayList<LocalItemDiffElement> elements = new ArrayList<LocalItemDiffElement>();
        for (VirtualFile file : files) {
            boolean isExcluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), this.myMapping, this.myServer, this.myConfig, this.mySettings);
            if (isExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || FileTypeManager.getInstance().isFileIgnored(file)) continue;
            elements.add(new LocalItemDiffElement(file, this.myMapping, this.myConfig, this.myServer, isExcluded, this.mySettings, this.myProject, false));
        }
        return elements.toArray(new LocalItemDiffElement[elements.size()]);
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "createDiffContent"));
        }
        LOG.assertTrue(!SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || !this.isExcluded());
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, this.getValue());
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "createDiffContent"));
        }
        return diffContent;
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myExcluded || this.myOperationRunning.get()) {
            return false;
        }
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), this.myServer);
        return !this.myConfig.isExcludedByName(remotePath.path) && !PublishConfig.isRemotePathExcluded(remotePath, this.myServer, this.myConfig);
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public long getSize() {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return -1L;
        }
        try {
            return super.getSize();
        }
        catch (InvalidVirtualFileAccessException e) {
            return -1L;
        }
    }

    public long getTimeStamp() {
        long result;
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            result = -1L;
        } else {
            try {
                result = super.getTimeStamp();
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.warn((Throwable)e);
                result = -1L;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.getValue().getPath() + " is " + result);
        }
        return result;
    }

    @Nullable
    public byte[] getContent() throws IOException {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return null;
        }
        if (RemoteItemDiffElement.isTooBig((DiffElement)this)) {
            return null;
        }
        try {
            return super.getContent();
        }
        catch (InvalidVirtualFileAccessException e) {
            return null;
        }
    }

    public VirtualFileDiffElement copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    public void copyTo(DiffElement container, final Ref<String> errorMessage, final Ref<DiffElement> diffElement, final Runnable onFinish, final DiffElement targetElement, String path) {
        if (this.myExcluded) {
            return;
        }
        LOG.assertTrue(container instanceof RemoteDiffElement);
        final RemoteDiffElement remoteElement = (RemoteDiffElement)container;
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            return;
        }
        this.saveDocument();
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), this.myServer);
        TransferOperation.Copy operation = new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(this.getValue().getPath()), remotePath){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    context.setIgnoreOverwriting(this.promptOverwriteIgnoreNeeded(context));
                    super.execute(context);
                    if (this.mySuccessfullyFinished) {
                        diffElement.set((Object)new RemoteItemDiffElement(remoteElement.getConnection(), LocalItemDiffElement.this.myServer, this.myTarget, remoteElement.getProject(), LocalItemDiffElement.this.myConfig, false, LocalItemDiffElement.this.myMapping, LocalItemDiffElement.this.mySettings, LocalItemDiffElement.this.myIsRoot));
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.upload.file.0", LocalItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    context.setIgnoreOverwriting(false);
                    ApplicationManager.getApplication().invokeAndWait(onFinish, ModalityState.defaultModalityState());
                    LocalItemDiffElement.this.myOperationRunning.set(false);
                }
            }

            private boolean promptOverwriteIgnoreNeeded(final ExecutionContext context) {
                if (targetElement == null || context.getConfig().getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    return false;
                }
                LOG.assertTrue(targetElement instanceof RemoteItemDiffElement);
                final RemoteItemDiffElement remoteTargetElement = (RemoteItemDiffElement)targetElement;
                try {
                    return remoteTargetElement.getConnection().executeServerOperation(new ThrowableComputable<Boolean, FileSystemException>(){

                        public Boolean compute() throws FileSystemException {
                            FileObject remoteTargetFile = remoteTargetElement.getValue();
                            DeploymentPathUtils.refreshRemoteFile(remoteTargetFile, context);
                            FileContent content = remoteTargetFile.getContent();
                            switch (context.getConfig().getPromptOnRemoteOverwrite()) {
                                case CHECK_TIMESTAMP: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                    long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                    if (!(unchanged &= TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, ((LocalItemDiffElement)LocalItemDiffElement.this).mySettings.compareTimestampAccuracy))) {
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, null);
                                    }
                                    return unchanged;
                                }
                                case CHECK_CONTENT: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    byte[] newContent = null;
                                    if (unchanged) {
                                        try {
                                            newContent = FileUtil.getContent((FileObject)remoteTargetFile);
                                            unchanged = Arrays.equals(remoteTargetElement.getContent(), newContent);
                                        }
                                        catch (IOException e) {
                                            LOG.warn((Throwable)e);
                                            return false;
                                        }
                                    }
                                    if (!unchanged) {
                                        boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                        long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                        unchanged = TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, remoteTargetFile.getFileSystem().getLastModTimeAccuracy());
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, newContent);
                                    }
                                    return unchanged;
                                }
                            }
                            return false;
                        }
                    }, null);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    return false;
                }
            }
        };
        component.offerTransferOperation(operation, true);
    }

    protected void saveDocument() {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(this.getValue());
        if (document != null) {
            manager.saveDocument(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Ref<String> errorMessage, Runnable onFinish) {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            return;
        }
        if (this.myExcluded) {
            LOG.debug("Excluded " + this.getPresentablePath());
            return;
        }
        if (!this.getValue().exists()) {
            onFinish.run();
            this.myOperationRunning.set(false);
            return;
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(((Object)((Object)this)).getClass());
        try {
            this.getValue().delete((Object)this);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            errorMessage.set((Object)WDBundle.message("failed.to.delete.local.file.0.1", this.getValue().getPath(), StringUtil.decapitalize((String)StringUtil.notNullize((String)e.getLocalizedMessage(), (String)WDBundle.message("unknown.reason", new Object[0])))));
        }
        finally {
            token.finish();
            onFinish.run();
            this.myOperationRunning.set(false);
        }
    }

    public LocalItemDiffElement createElement(VirtualFile file) {
        return LocalItemDiffElement.createLocalElement(file, this.myMapping, this.myConfig, this.myServer, this.mySettings, this.myProject);
    }

    static LocalItemDiffElement createLocalElement(VirtualFile file, DeploymentPathMapping mapping, PublishConfig config, WebServerConfig server, DirDiffSettings settings, Project project) {
        boolean excluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), mapping, server, config, settings);
        return new LocalItemDiffElement(file, mapping, config, server, excluded, settings, project, false);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "getName"));
        }
        return string;
    }

    public String toString() {
        return "LocalItemDiffElement{name=" + this.getName() + '}';
    }
}

