/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ultimate.UltimateVerifier;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathChecker;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.RemoteMoveProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.jetbrains.annotations.NotNull;

class DnDTask
extends ExtendedNotificationBrowserTask {
    private static final Logger LOG = Logger.getInstance((String)DnDTask.class.getName());
    private final Tree myTree;
    private final WebServerConfig myServer;
    private final RemoteMoveProvider.SourceFilesData mySourceFilesData;
    private final FileObject myTarget;
    private final boolean myRemoteSource;
    private final boolean myRemoteTarget;
    private final boolean myMoving;
    private final RemoteConnection myConnection;
    private MyDoNotAskOption myFoldersDoNotAsk;
    private MyDoNotAskOption myFilesDoNotAsk;

    public DnDTask(Project project, ServerTree tree, WebServerConfig server, @NotNull RemoteMoveProvider.SourceFilesData sourceFilesData, FileObject target, boolean remoteSource, boolean remoteTarget, boolean moving) {
        if (sourceFilesData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilesData", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/DnDTask", "<init>"));
        }
        super(project, ConnectionOwnerFactory.createConnectionOwner(project, (Component)((Object)tree)), project != null ? PublishConfig.getInstance(project) : new PublishConfig(null, UltimateVerifier.getInstance()), server, DnDTask.getTaskTitle(remoteSource, remoteTarget, moving), IdeKeyEventDispatcher.isModalContext((Component)((Object)tree)), (Component)((Object)tree), DnDTask.getErrorTitle(remoteSource, remoteTarget, server, sourceFilesData, target, moving), DeploymentRevisionTracker.DEAF, remoteTarget, remoteSource && remoteTarget);
        this.myTree = tree;
        this.myServer = server;
        this.mySourceFilesData = sourceFilesData;
        this.myTarget = target;
        this.myRemoteSource = remoteSource;
        this.myRemoteTarget = remoteTarget;
        this.myMoving = moving;
        this.myConnection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData((DataProvider)tree);
    }

    private static Collection<FileObject> filterChildren(Collection<FileObject> files) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (FileObject file : files) {
            boolean add = true;
            FileName fileName = file.getName();
            for (FileObject probableParent : files) {
                if (!fileName.isAncestor(probableParent.getName())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(file);
        }
        return result;
    }

    private static String getErrorTitle(boolean remoteSource, boolean remoteTarget, WebServerConfig serverConfig, RemoteMoveProvider.SourceFilesData sourceFilesData, FileObject targetFile, boolean moving) {
        String sourceFilesDescription = sourceFilesData.getFilesDescription(serverConfig, true, remoteSource);
        String targetDescription = RemoteMoveProvider.getFileDescription(targetFile, serverConfig, true, remoteTarget);
        return WDBundle.message("0.1.to.2", DnDTask.getActionName(remoteSource, remoteTarget, moving), sourceFilesDescription, targetDescription);
    }

    private static String getActionName(boolean remoteSource, boolean remoteTarget, boolean moving) {
        if (remoteSource && remoteTarget) {
            return WDBundle.message("action.move", new Object[0]);
        }
        if (remoteSource) {
            return moving ? WDBundle.message("action.move.from.server", new Object[0]) : WDBundle.message("action.download", new Object[0]);
        }
        if (remoteTarget) {
            return moving ? WDBundle.message("action.move.to.server", new Object[0]) : WDBundle.message("action.upload", new Object[0]);
        }
        throw new IllegalStateException("Totally local operations have nothing to do with deployment.");
    }

    private static String getTaskTitle(boolean remoteSource, boolean remoteTarget, boolean moving) {
        if (remoteSource && remoteTarget) {
            return WDBundle.message("move.error.title", new Object[0]);
        }
        if (remoteSource && moving) {
            return WDBundle.message("action.move.items.from.server", new Object[0]);
        }
        if (remoteTarget && moving) {
            return WDBundle.message("action.move.items.to.server", new Object[0]);
        }
        return WDBundle.message("0.items", DnDTask.getActionName(remoteSource, remoteTarget, moving));
    }

    @Override
    protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) {
        context.getProgressIndicator().checkCanceled();
        int size = this.mySourceFilesData.getSize();
        context.getProgressIndicator().setText(WDBundle.message("processing.0", WDBundle.message("files", size, size)));
        context.setIgnoreOverwriting(true);
        LinkedList<TransferOperation> operations = new LinkedList<TransferOperation>();
        LinkedList<String> messages = new LinkedList<String>();
        Collection<FileObject> sourceFiles = this.mySourceFilesData.resolveFiles(context, messages);
        sourceFiles = DnDTask.filterChildren(sourceFiles);
        for (FileObject source : sourceFiles) {
            try {
                FileObject newFile = this.myTarget.resolveFile(source.getName().getBaseName(), NameScope.CHILD);
                this.addOperations(source, newFile, operations, context);
            }
            catch (FileSystemException ex) {
                String sourcePath = this.myRemoteSource ? context.getServer().getPresentablePath(source) : DeploymentPathUtils.getLocalPath(source);
                messages.add(this.getFailureMessage(sourcePath));
            }
        }
        return new TransferTask.ListBased.ResultWithErrors(operations, DeploymentPathUtils.ErrorsAndExclusions.reportErrors(messages));
    }

    private String getFailureMessage(String sourcePath) {
        return WDBundle.message("failed.to.0.1", DnDTask.getActionName(this.myRemoteSource, this.myRemoteTarget, this.myMoving).toLowerCase(), sourcePath);
    }

    private void addOperations(FileObject source, FileObject target, List<TransferOperation> operations, @NotNull ExecutionContext context) throws FileSystemException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/DnDTask", "addOperations"));
        }
        if (this.myRemoteSource && this.myRemoteTarget) {
            this.addPureRemoteMove(source, target, operations, context);
        } else if (this.myRemoteSource != this.myRemoteTarget) {
            DeploymentPathChecker checker = new DeploymentPathChecker();
            checker.initProcessing();
            this.addLoadOperations(source, target, operations, checker);
        } else {
            throw new IllegalStateException("Totally local operations have nothing to do with deployment.");
        }
    }

    private void addLoadOperations(final FileObject source, final FileObject target, List<TransferOperation> operations, @NotNull DeploymentPathChecker checker) throws FileSystemException {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/DnDTask", "addLoadOperations"));
        }
        FileObject previousObject = checker.getAlreadyProcessedFileObject(source);
        if (previousObject != null) {
            String errorMessage = "Skipping duplicate path: " + source.getName().getPath() + " looks like a recursive symlink to " + previousObject.getName().getPath();
            LOG.warn(errorMessage);
            return;
        }
        FileType type = source.getType();
        if (type == FileType.FILE) {
            operations.add(new TransferOperation.Copy(source, target){

                @Override
                public void execute(ExecutionContext context) throws FileSystemException {
                    super.execute(context);
                    if (DnDTask.this.myRemoteTarget) {
                        context.scheduleForSelection(DnDTask.this.myServer.getRemotePath(target), DnDTask.this.myTree);
                    }
                }
            });
            if (this.myMoving) {
                operations.add(new TransferOperation.Delete(source, false, false){

                    @Override
                    public void execute(ExecutionContext context) throws FileSystemException {
                        super.execute(context);
                        context.addAffectedRoot(source.getName(), DnDTask.this.myRemoteSource);
                    }
                });
            }
        } else {
            if (type == FileType.IMAGINARY) {
                return;
            }
            if (!target.exists()) {
                operations.add(new TransferOperation.CreateFolder(target));
            }
            for (FileObject child : source.getChildren()) {
                FileObject newFile = target.resolveFile(child.getName().getBaseName(), NameScope.CHILD);
                this.addLoadOperations(child, newFile, operations, checker);
            }
            if (this.myMoving) {
                operations.add(new TransferOperation.Delete(source, true, false){

                    @Override
                    public void execute(ExecutionContext context) throws FileSystemException {
                        super.execute(context);
                        context.addAffectedRoot(source.getName(), DnDTask.this.myRemoteSource);
                    }
                });
            }
        }
    }

    private boolean addPureRemoteMove(FileObject source, final FileObject target, List<TransferOperation> operations, ExecutionContext context) throws FileSystemException {
        if (target.equals(source)) {
            return false;
        }
        boolean equalNames = context.getServer().isCaseSensitive() ? source.getName().getBaseName().equals(target.getName().getBaseName()) : source.getName().getBaseName().equalsIgnoreCase(target.getName().getBaseName());
        if (!equalNames || !target.exists()) {
            operations.add(new TransferOperation.RemoteMove(source, target, source.getType() == FileType.FOLDER, false){

                @Override
                public void execute(ExecutionContext context) throws FileSystemException {
                    super.execute(context);
                    context.scheduleForSelection(DnDTask.this.myServer.getRemotePath(target), DnDTask.this.myTree);
                }
            });
            return true;
        }
        boolean isFolder = source.getType() == FileType.FOLDER;
        Ref resultRef = new Ref();
        MyDoNotAskOption doNotAskOption = this.getDoNotAskOption(isFolder);
        if (doNotAskOption.isSelected) {
            resultRef.set((Object)doNotAskOption.exitCode);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message = WDBundle.message(isFolder ? "merge.folder.message" : "overwrite.file.message", context.getServer().getPresentablePath(target));
                resultRef.set((Object)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)WDBundle.message("move.error.title", new Object[0]), (String)message).project(this.getProject())).doNotAsk((DialogWrapper.DoNotAskOption)doNotAskOption)).show());
            }, ModalityState.any());
        }
        if ((Integer)resultRef.get() == 0) {
            boolean totalMove = true;
            if (isFolder) {
                for (FileObject child : source.getChildren()) {
                    FileObject newFile = target.resolveFile(child.getName().getBaseName(), NameScope.CHILD);
                    totalMove &= this.addPureRemoteMove(child, newFile, operations, context);
                }
                if (totalMove) {
                    operations.add(new TransferOperation.Delete(source, true, false));
                }
                return totalMove;
            }
            operations.add(new TransferOperation.RemoteMove(source, target, source.getType() == FileType.FOLDER, true){

                @Override
                public void execute(ExecutionContext context) throws FileSystemException {
                    super.execute(context);
                    context.scheduleForSelection(DnDTask.this.myServer.getRemotePath(target), DnDTask.this.myTree);
                }
            });
            return true;
        }
        if ((Integer)resultRef.get() == 2) {
            throw new ProcessCanceledException();
        }
        return false;
    }

    @Override
    protected RemoteConnection getExistingConnection() {
        return this.myConnection;
    }

    @Override
    protected boolean stopOnFirstError() {
        return true;
    }

    private MyDoNotAskOption getDoNotAskOption(boolean isFolder) {
        if (isFolder) {
            if (this.myFoldersDoNotAsk == null) {
                this.myFoldersDoNotAsk = new MyDoNotAskOption(true);
            }
            return this.myFoldersDoNotAsk;
        }
        if (this.myFilesDoNotAsk == null) {
            this.myFilesDoNotAsk = new MyDoNotAskOption(false);
        }
        return this.myFilesDoNotAsk;
    }

    private static class MyDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        private boolean isSelected;
        private int exitCode;
        private final boolean myIsFolder;

        private MyDoNotAskOption(boolean isFolder) {
            this.myIsFolder = isFolder;
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean value, int exitCode) {
            this.isSelected = !value;
            this.exitCode = exitCode;
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = WDBundle.message("use.it.for.all.0", this.myIsFolder ? 1 : 0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/DnDTask$MyDoNotAskOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }
}

