/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConsoleSettingsPanel {
    private JPanel myEncodingsListCombo;
    private ChooseFileEncodingAction myEncodingAction;
    private final Ref<Charset> myCharset;
    private JPanel myWholePanel;
    private JPanel myConnectionSettingsHolder;
    private SshConsoleOptionsProvider myOptionsProvider;
    private RemoteConnectionSettingsForm myConnectionSettingsForm;
    private final Disposable myParentDisposable;
    @Nullable
    private final Project myProject;

    public SshConsoleSettingsPanel(Disposable parent, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myCharset = new Ref();
        this.myParentDisposable = parent;
        this.myProject = project;
    }

    public JComponent createPanel(SshConsoleOptionsProvider provider) {
        this.myOptionsProvider = provider;
        this.myEncodingAction = SshConsoleSettingsPanel.installChooseEncodingCombo(this.myEncodingsListCombo, this.myCharset);
        this.myConnectionSettingsForm = new RemoteConnectionSettingsForm(this.myProject, this.myParentDisposable);
        this.myConnectionSettingsForm.setShowServerSettingsLink(true);
        this.myConnectionSettingsHolder.setLayout(new BorderLayout());
        this.myConnectionSettingsHolder.add((Component)this.myConnectionSettingsForm.createPanel(), "Center");
        return this.myWholePanel;
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.myCharset.get(), (Object)this.myOptionsProvider.getCharset()) || this.connectionIsModified();
    }

    private boolean connectionIsModified() {
        return this.myConnectionSettingsForm.getConnectionType() != this.myOptionsProvider.getConnectionType() || StringUtil.isEmpty((String)this.myConnectionSettingsForm.getConnectionId()) && !StringUtil.isEmpty((String)this.myOptionsProvider.getConnectionId()) || this.myConnectionSettingsForm.getConnectionId() != null && !this.myConnectionSettingsForm.getConnectionId().equals(this.myOptionsProvider.getConnectionId());
    }

    public void apply() {
        this.myOptionsProvider.setCharset((Charset)this.myCharset.get());
        this.myOptionsProvider.setConnectByDefaultType(this.myConnectionSettingsForm.getConnectionType());
        this.myOptionsProvider.setConnectionId(this.myConnectionSettingsForm.getConnectionId());
    }

    public void reset() {
        this.myCharset.set((Object)this.myOptionsProvider.getCharset());
        this.myEncodingAction.update(null);
        this.myConnectionSettingsForm.setConnectionTypeAndId(this.myOptionsProvider.getConnectionType(), this.myOptionsProvider.getConnectionId());
    }

    private static ChooseFileEncodingAction installChooseEncodingCombo(@NotNull JPanel parentPanel, final @NotNull Ref<Charset> selected) {
        if (parentPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPanel", "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel", "installChooseEncodingCombo"));
        }
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel", "installChooseEncodingCombo"));
        }
        ChooseFileEncodingAction myAction = new ChooseFileEncodingAction(null){

            public void update(AnActionEvent e) {
                this.getTemplatePresentation().setEnabled(true);
                Charset charset = (Charset)selected.get();
                this.getTemplatePresentation().setText(charset == null ? SshConsoleSettingsPanel.getSystemDefault() : charset.displayName());
            }

            protected void chosen(VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel$1", "chosen"));
                }
                selected.set((Object)(charset == NO_ENCODING ? null : charset));
                this.update(null);
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup("<System Default>", (Charset)selected.get(), charset -> "Choose encoding '" + charset + "'");
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel$1", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }
        };
        parentPanel.removeAll();
        Presentation templatePresentation = myAction.getTemplatePresentation();
        parentPanel.add((Component)myAction.createCustomComponent(templatePresentation), "Center");
        myAction.update(null);
        return myAction;
    }

    private static String getSystemDefault() {
        return CharsetToolkit.getDefaultSystemCharset().name();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConnectionSettingsHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(24, 25), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Default encoding:");
        jLabel.setHorizontalTextPosition(2);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEncodingsListCombo = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

