/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "()V", "removableDeclarations", "", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "getRemovableDeclarations", "()Ljava/util/List;", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "isLocalFunctionDeclaration", "", "jsVar", "Lcom/google/dart/compiler/backend/js/ast/JsVars$JsVar;", "visit", "x", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "kotlin-compiler"})
final class UnusedInstanceCollector
extends JsVisitorWithContextImpl {
    private final ReferenceTracker<JsName, JsStatement> tracker = new ReferenceTracker();

    @NotNull
    public final List<JsStatement> getRemovableDeclarations() {
        return this.tracker.getRemovable();
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        void $receiver$iv;
        JsStatement currentStatement;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (!this.isLocalFunctionDeclaration(x)) {
            return super.visit(x, ctx);
        }
        JsName jsName = x.getName();
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name = jsName;
        JsContext<JsStatement> statementContext = this.getLastStatementLevelContext();
        JsStatement jsStatement = currentStatement = statementContext.getCurrentNode();
        if (jsStatement == null) {
            Intrinsics.throwNpe();
        }
        JsNode jsNode = jsStatement;
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "currentStatement!!");
        this.tracker.addCandidateForRemoval(name, (JsStatement)jsNode);
        Set<JsName> references = CollectUtilsKt.collectUsedNames(x);
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)references);
        for (Object element$iv : $receiver$iv) {
            JsName it = (JsName)element$iv;
            this.tracker.addRemovableReference(name, it);
        }
        return false;
    }

    public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName name = x.getName();
        if (name != null) {
            this.tracker.markReachable(name);
        }
        return false;
    }

    private final boolean isLocalFunctionDeclaration(JsVars.JsVar jsVar) {
        JsName name = jsVar.getName();
        JsExpression expr = jsVar.getInitExpression();
        JsName jsName = name;
        JsNode staticRef = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
        return staticRef != null && Intrinsics.areEqual(staticRef, expr);
    }
}

