/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.typePredicates.TypePredicatesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        PatternTranslator patternTranslator = new PatternTranslator(context);
        if (patternTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        return patternTranslator;
    }

    private PatternTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "<init>"));
        }
        super(context);
    }

    public static boolean isCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isCastExpression"));
        }
        return PatternTranslator.isSafeCast(expression) || PatternTranslator.isUnsafeCast(expression);
    }

    @NotNull
    public JsExpression translateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        JsExpressionImpl onFail;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
        }
        assert (PatternTranslator.isCastExpression(expression)) : "Expected cast expression, got " + expression;
        KtExpression left = expression.getLeft();
        JsExpression expressionToCast = Translation.translateAsExpression(left, this.context());
        if (JsAstUtils.isEmptyExpression(expressionToCast)) {
            JsExpression jsExpression = expressionToCast;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
            }
            return jsExpression;
        }
        TemporaryVariable temporary = this.context().declareTemporary(expressionToCast);
        KtTypeReference typeReference = expression.getRight();
        assert (typeReference != null) : "Cast expression must have type reference";
        KotlinType sourceType = BindingUtils.getTypeForExpression(this.bindingContext(), left);
        JsExpression isCheck = this.translateIsCheck(temporary.assignmentExpression(), sourceType, typeReference);
        if (isCheck == null) {
            JsExpression jsExpression = expressionToCast;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
            }
            return jsExpression;
        }
        if (PatternTranslator.isSafeCast(expression)) {
            onFail = JsLiteral.NULL;
        } else {
            JsExpression throwCCEFunRef = this.context().namer().throwClassCastExceptionFunRef();
            onFail = new JsInvocation(throwCCEFunRef, new JsExpression[0]);
        }
        JsConditional jsConditional = new JsConditional(isCheck, temporary.reference(), onFail);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
        }
        return jsConditional;
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull KtIsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        JsExpression left = Translation.translateAsExpression(expression.getLeftHandSide(), this.context());
        KtTypeReference typeReference = expression.getTypeReference();
        assert (typeReference != null);
        KotlinType sourceType = BindingUtils.getTypeForExpression(this.bindingContext(), expression.getLeftHandSide());
        JsExpression result2 = this.translateIsCheck(left, sourceType, typeReference);
        if (result2 == null) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean(!expression.isNegated());
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsBooleanLiteral;
        }
        if (expression.isNegated()) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(result2);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        return jsExpression;
    }

    @Nullable
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @Nullable KotlinType sourceType, @NotNull KtTypeReference targetTypeReference) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        if (targetTypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTypeReference", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        if (JsAstUtils.isEmptyExpression(subject)) {
            return subject;
        }
        KotlinType targetType = BindingUtils.getTypeByReference(this.bindingContext(), targetTypeReference);
        if (sourceType != null && !DynamicTypesKt.isDynamic(sourceType) && TypeUtilsKt.isSubtypeOf(sourceType, targetType)) {
            return null;
        }
        JsExpression checkFunReference = this.doGetIsTypeCheckCallable(targetType);
        boolean isReifiedType = TypeUtils.isReifiedTypeParameter(targetType);
        if (!isReifiedType && TypeUtils.isNullableType(targetType) || isReifiedType && KtPsiUtil.findChildByType(targetTypeReference, KtNodeTypes.NULLABLE_TYPE) != null) {
            checkFunReference = this.namer().orNull(checkFunReference);
        }
        return new JsInvocation(checkFunReference, subject);
    }

    @NotNull
    public JsExpression getIsTypeCheckCallable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        JsExpression callable = this.doGetIsTypeCheckCallable(type2);
        if (TypeUtils.isNullableType(type2)) {
            JsExpression jsExpression = this.namer().orNull(callable);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = callable;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression doGetIsTypeCheckCallable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
        }
        JsExpression builtinCheck = this.getIsTypeCheckCallableForBuiltin(type2);
        if (builtinCheck != null) {
            JsExpression jsExpression = builtinCheck;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        builtinCheck = this.getIsTypeCheckCallableForPrimitiveBuiltin(type2);
        if (builtinCheck != null) {
            JsExpression jsExpression = builtinCheck;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                JsExpression jsExpression = this.getIsTypeCheckCallableForReifiedType(typeParameterDescriptor);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
                }
                return jsExpression;
            }
            JsExpression result2 = null;
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                JsExpression next = this.doGetIsTypeCheckCallable(upperBound);
                result2 = result2 != null ? this.namer().andPredicate(result2, next) : next;
            }
            assert (result2 != null) : "KotlinType is expected to return at least one upper bound: " + type2;
            JsExpression jsExpression = result2;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        JsNameRef typeName = this.getClassNameReference(type2);
        JsExpression jsExpression = this.namer().isInstanceOf(typeName);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForBuiltin(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForBuiltin"));
        }
        if (KotlinBuiltIns.isAnyOrNullableAny(type2)) {
            return this.namer().isAny();
        }
        if (FunctionTypesKt.isFunctionTypeOrSubtype(type2)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("function"));
        }
        if (KotlinBuiltIns.isArray(type2)) {
            return Namer.IS_ARRAY_FUN_REF;
        }
        if (TypePredicatesKt.getCHAR_SEQUENCE().apply(type2)) {
            return this.namer().isCharSequence();
        }
        if (TypePredicatesKt.getCOMPARABLE().apply(type2)) {
            return this.namer().isComparable();
        }
        return null;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForPrimitiveBuiltin(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForPrimitiveBuiltin"));
        }
        Name typeName = DescriptorUtilsKt.getNameIfStandardType(type2);
        if (NamePredicate.STRING.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("string"));
        }
        if (NamePredicate.BOOLEAN.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("boolean"));
        }
        if (NamePredicate.LONG.apply(typeName)) {
            return this.namer().isInstanceOf(Namer.kotlinLong());
        }
        if (NamePredicate.NUMBER.apply(typeName)) {
            return this.namer().kotlin("isNumber");
        }
        if (NamePredicate.CHAR.apply(typeName)) {
            return this.namer().kotlin("isChar");
        }
        if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("number"));
        }
        return null;
    }

    @NotNull
    private JsExpression getIsTypeCheckCallableForReifiedType(@NotNull TypeParameterDescriptor typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        assert (typeParameter.isReified()) : "Expected reified type, actual: " + typeParameter;
        DeclarationDescriptor containingDeclaration = typeParameter.getContainingDeclaration();
        assert (containingDeclaration instanceof CallableDescriptor) : "Expected type parameter " + typeParameter + " to be contained in CallableDescriptor, actual: " + containingDeclaration.getClass();
        JsExpression alias = this.context().getAliasForDescriptor(typeParameter);
        assert (alias != null) : "No alias found for reified type parameter: " + typeParameter;
        JsExpression jsExpression = alias;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        return jsExpression;
    }

    @NotNull
    private JsNameRef getClassNameReference(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        ClassDescriptor referencedClass = DescriptorUtils.getClassDescriptorForType(type2);
        JsNameRef jsNameRef = this.context().getQualifiedReference(referencedClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull JsExpression expressionToMatch, @NotNull KtExpression patternExpression) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(patternExpression);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull KtExpression patternExpression) {
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(patternExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        return jsExpression;
    }

    private static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isSafeCast"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    private static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isUnsafeCast"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }
}

