/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class SerializerExtension {
    @NotNull
    public abstract StringTable getStringTable();

    public boolean shouldUseTypeTable() {
        return false;
    }

    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeClass"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeClass"));
        }
    }

    public void serializePackage(@NotNull ProtoBuf.Package.Builder proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializePackage"));
        }
    }

    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeConstructor"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeConstructor"));
        }
    }

    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeFunction"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeFunction"));
        }
    }

    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeProperty"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeProperty"));
        }
    }

    public void serializeEnumEntry(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeEnumEntry"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeEnumEntry"));
        }
    }

    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeValueParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeValueParameter"));
        }
    }

    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeType"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeType"));
        }
    }

    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeTypeParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeTypeParameter"));
        }
    }

    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeErrorType"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/serialization/SerializerExtension", "serializeErrorType"));
        }
        throw new IllegalStateException("Cannot serialize error type: " + type2);
    }
}

