/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalyzerFacade;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.jvm.JvmAnalyzerFacade;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformParameters;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializer;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002JD\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "", "dependOnOldBuiltIns", "", "(Z)V", "totalFiles", "", "totalSize", "serialize", "", "disposable", "Lcom/intellij/openapi/Disposable;", "destDir", "Ljava/io/File;", "srcDirs", "", "extraClassPath", "onComplete", "Lkotlin/Function2;", "BuiltInsSourcesModule", "PackageSerializer", "kotlin-compiler"})
public final class BuiltInsSerializer {
    private int totalSize;
    private int totalFiles;
    private final boolean dependOnOldBuiltIns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(@NotNull File destDir, @NotNull List<? extends File> srcDirs, @NotNull List<? extends File> extraClassPath, @NotNull Function2<? super Integer, ? super Integer, Unit> onComplete) {
        Intrinsics.checkParameterIsNotNull(destDir, "destDir");
        Intrinsics.checkParameterIsNotNull(srcDirs, "srcDirs");
        Intrinsics.checkParameterIsNotNull(extraClassPath, "extraClassPath");
        Intrinsics.checkParameterIsNotNull(onComplete, "onComplete");
        Disposable rootDisposable = Disposer.newDisposable();
        try {
            Disposable disposable = rootDisposable;
            Intrinsics.checkExpressionValueIsNotNull(disposable, "rootDisposable");
            this.serialize(disposable, destDir, srcDirs, extraClassPath);
            onComplete.invoke((Integer)this.totalSize, (Integer)this.totalFiles);
        }
        finally {
            Disposer.dispose(rootDisposable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serialize(Disposable disposable, File destDir, List<? extends File> srcDirs, List<? extends File> extraClassPath) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable it;
        Object object;
        void destination$iv$iv2;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        Iterable iterable = srcDirs;
        CompilerConfiguration compilerConfiguration = configuration;
        void var7_8 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            File file = (File)item$iv$iv;
            object = destination$iv$iv2;
            String string = ((File)((Object)it)).getPath();
            object.add(string);
        }
        object = (List)destination$iv$iv2;
        ContentRootsKt.addKotlinSourceRoots(compilerConfiguration, (List<String>)object);
        JvmContentRootsKt.addJvmClasspathRoots(configuration, extraClassPath);
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForTests(disposable, configuration, list2);
        List<KtFile> files = environment2.getSourceFiles();
        BuiltInsSourcesModule builtInModule = new BuiltInsSourcesModule();
        ResolverForProject resolver2 = AnalyzerFacade.setupResolverForProject$default(JvmAnalyzerFacade.INSTANCE, "builtIns source", ContextKt.ProjectContext(environment2.getProject()), CollectionsKt.listOf(builtInModule), new Function1<BuiltInsSourcesModule, ModuleContent>(files){
            final /* synthetic */ List $files;

            @NotNull
            public final ModuleContent invoke(@NotNull BuiltInsSourcesModule it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Collection collection = this.$files;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.EMPTY_SCOPE");
                return new ModuleContent(collection, globalSearchScope);
            }
            {
                this.$files = list2;
                super(1);
            }
        }, new JvmPlatformParameters(serialize.resolver.2.INSTANCE), CompilerEnvironment.INSTANCE, null, new Function2<BuiltInsSourcesModule, ModuleContent, JvmPackagePartProvider>(environment2){
            final /* synthetic */ KotlinCoreEnvironment $environment;

            @NotNull
            public final JvmPackagePartProvider invoke(@NotNull BuiltInsSourcesModule module, @NotNull ModuleContent content) {
                Intrinsics.checkParameterIsNotNull(module, "module");
                Intrinsics.checkParameterIsNotNull(content, "content");
                return new JvmPackagePartProvider(this.$environment);
            }
            {
                this.$environment = kotlinCoreEnvironment;
                super(2);
            }
        }, 64, null);
        ModuleDescriptor moduleDescriptor = resolver2.descriptorForModule((ModuleInfo)builtInModule);
        FilesKt.deleteRecursively(destDir);
        if (!destDir.mkdirs()) {
            System.err.println("Could not make directories: " + destDir);
        }
        it = files;
        void $i$a$1$map = $receiver$iv;
        Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            KtFile ktFile = (KtFile)item$iv$iv;
            compilerConfiguration = destination$iv$iv;
            object = it2.getPackageFqName();
            compilerConfiguration.add(object);
        }
        $receiver$iv = CollectionsKt.toSet((List)destination$iv$iv);
        for (Object element$iv : $receiver$iv) {
            FqName fqName2;
            FqName fqName3 = fqName2 = (FqName)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            new PackageSerializer(moduleDescriptor.getPackage(fqName3), destDir, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(this, moduleDescriptor, destDir){
                final /* synthetic */ BuiltInsSerializer this$0;
                final /* synthetic */ ModuleDescriptor $moduleDescriptor$inlined;
                final /* synthetic */ File $destDir$inlined;

                public final void invoke(int bytesWritten) {
                    BuiltInsSerializer builtInsSerializer = this.this$0;
                    BuiltInsSerializer.access$setTotalSize$p(builtInsSerializer, BuiltInsSerializer.access$getTotalSize$p(builtInsSerializer) + bytesWritten);
                    BuiltInsSerializer builtInsSerializer2 = this.this$0;
                    int n = BuiltInsSerializer.access$getTotalFiles$p(builtInsSerializer2);
                    BuiltInsSerializer.access$setTotalFiles$p(builtInsSerializer2, n + 1);
                }
                {
                    this.this$0 = builtInsSerializer;
                    this.$moduleDescriptor$inlined = moduleDescriptor;
                    this.$destDir$inlined = file;
                    super(1);
                }
            }).run();
        }
    }

    public BuiltInsSerializer(boolean dependOnOldBuiltIns) {
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    public static final /* synthetic */ int access$getTotalSize$p(BuiltInsSerializer $this) {
        return $this.totalSize;
    }

    public static final /* synthetic */ void access$setTotalSize$p(BuiltInsSerializer $this, int n) {
        $this.totalSize = n;
    }

    public static final /* synthetic */ int access$getTotalFiles$p(BuiltInsSerializer $this) {
        return $this.totalFiles;
    }

    public static final /* synthetic */ void access$setTotalFiles$p(BuiltInsSerializer $this, int n) {
        $this.totalFiles = n;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$BuiltInsSourcesModule;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "(Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "dependencies", "", "Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "dependencyOnBuiltIns", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo$DependencyOnBuiltIns;", "kotlin-compiler"})
    private final class BuiltInsSourcesModule
    implements ModuleInfo {
        @NotNull
        private final Name name = Name.special("<module for resolving builtin source files>");

        @Override
        @NotNull
        public Name getName() {
            return this.name;
        }

        @NotNull
        public List<BuiltInsSourcesModule> dependencies() {
            return CollectionsKt.listOf(this);
        }

        @Override
        @NotNull
        public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
            return BuiltInsSerializer.this.dependOnOldBuiltIns ? (ModuleInfo.DependencyOnBuiltIns)ModuleInfo.DependenciesOnBuiltIns.LAST : (ModuleInfo.DependencyOnBuiltIns)ModuleInfo.DependenciesOnBuiltIns.NONE;
        }

        @Override
        public boolean isLibrary() {
            return ModuleInfo.DefaultImpls.isLibrary(this);
        }

        @Override
        @NotNull
        public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
            return ModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
        }

        @Override
        @NotNull
        public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
            return ModuleInfo.DefaultImpls.getCapabilities(this);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0015\u001a\u00020\tJ\b\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$PackageSerializer;", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "destDir", "Ljava/io/File;", "onFileWrite", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "extension", "Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializerExtension;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "fragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsProtoBuf$BuiltIns$Builder;", "kotlin.jvm.PlatformType", "run", "serializeBuiltInsFile", "serializeClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "serializeClasses", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "serializePackageFragments", "serializeStringTable", "write", "fileName", "", "stream", "Ljava/io/ByteArrayOutputStream;", "kotlin-compiler"})
    private static final class PackageSerializer {
        private final FqName fqName;
        private final List<PackageFragmentDescriptor> fragments;
        private final BuiltInsProtoBuf.BuiltIns.Builder proto;
        private final BuiltInsSerializerExtension extension;
        private final PackageViewDescriptor packageView;
        private final File destDir;
        private final Function1<Integer, Unit> onFileWrite;

        public final void run() {
            this.serializeClasses(this.packageView.getMemberScope());
            this.serializePackageFragments(this.fragments);
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        private final void serializeClass(ClassDescriptor classDescriptor) {
            ProtoBuf.Class classProto = DescriptorSerializer.createTopLevel(this.extension).classProto(classDescriptor).build();
            this.proto.addClass(classProto);
            MemberScope memberScope2 = classDescriptor.getUnsubstitutedInnerClassesScope();
            Intrinsics.checkExpressionValueIsNotNull(memberScope2, "classDescriptor.unsubstitutedInnerClassesScope");
            this.serializeClasses(memberScope2);
        }

        private final void serializeClasses(MemberScope scope2) {
            for (DeclarationDescriptor descriptor2 : DescriptorSerializer.sort(ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null))) {
                if (!(descriptor2 instanceof ClassDescriptor) || !(Intrinsics.areEqual((Object)((ClassDescriptor)descriptor2).getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true)) continue;
                this.serializeClass((ClassDescriptor)descriptor2);
            }
        }

        private final void serializePackageFragments(List<? extends PackageFragmentDescriptor> fragments2) {
            this.proto.setPackage(DescriptorSerializer.createTopLevel(this.extension).packageProto((Collection<PackageFragmentDescriptor>)fragments2).build());
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeStringTable() {
            void qualifiedNames;
            void strings;
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable stringTable = pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNameTable = pair.component2();
            pair = null;
            this.proto.setStrings((ProtoBuf.StringTable)strings);
            this.proto.setQualifiedNames((ProtoBuf.QualifiedNameTable)qualifiedNames);
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeBuiltInsFile() {
            void $receiver$iv;
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(stream2);
            DataOutputStream $receiver = dataOutputStream;
            int[] version = BuiltInsBinaryVersion.INSTANCE.toArray();
            $receiver.writeInt(version.length);
            int[] nArray = version;
            for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                void element$iv;
                void it = element$iv = $receiver$iv[i];
                $receiver.writeInt((int)it);
            }
            this.proto.build().writeTo(stream2);
            this.write(BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(this.fqName), stream2);
        }

        private final void write(String fileName, ByteArrayOutputStream stream2) {
            this.onFileWrite.invoke(stream2.size());
            File file = new File(this.destDir, fileName);
            file.getParentFile().mkdirs();
            byte[] byArray = stream2.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
            FilesKt.writeBytes(file, byArray);
        }

        public PackageSerializer(@NotNull PackageViewDescriptor packageView, @NotNull File destDir, @NotNull Function1<? super Integer, Unit> onFileWrite) {
            Intrinsics.checkParameterIsNotNull(packageView, "packageView");
            Intrinsics.checkParameterIsNotNull(destDir, "destDir");
            Intrinsics.checkParameterIsNotNull(onFileWrite, "onFileWrite");
            this.packageView = packageView;
            this.destDir = destDir;
            this.onFileWrite = onFileWrite;
            this.fqName = this.packageView.getFqName();
            this.fragments = this.packageView.getFragments();
            this.proto = BuiltInsProtoBuf.BuiltIns.newBuilder();
            this.extension = new BuiltInsSerializerExtension((Collection<? extends PackageFragmentDescriptor>)this.fragments);
        }
    }
}

