/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.compass.ConfigureCompassQuickFix;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;

public class SassScssImportReference
extends StylesheetFileReference {
    @NonNls
    protected static final String SCSS_EXT = "scss";
    @NonNls
    protected static final String SASS_EXT = "sass";
    @NonNls
    protected static final String CSS_EXT = "css";
    private static final Joiner EXTENSIONS_JOINER = Joiner.on((String)".");
    @NonNls
    private static final String EMPTY_STRING = "";
    private static final String COMPASS_IMPORT = "compass";

    public LocalQuickFix[] getQuickFixes() {
        LocalQuickFix compassQuickFix;
        Object[] quickFixes = super.getQuickFixes();
        FileReference firstReference = this.getFileReferenceSet().getReference(0);
        if (COMPASS_IMPORT.equals(firstReference.getText()) && firstReference.resolve() == null && (compassQuickFix = this.getCompassQuickFix()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (quickFixes != null) {
                localQuickFixArray = (LocalQuickFix[])ArrayUtil.prepend((Object)compassQuickFix, (Object[])quickFixes);
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = compassQuickFix;
            }
            return localQuickFixArray;
        }
        return quickFixes;
    }

    @Nullable
    private LocalQuickFix getCompassQuickFix() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        return module != null ? new ConfigureCompassQuickFix(module, this.getElement()) : null;
    }

    public SassScssImportReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/scss/references/SassScssImportReference", "<init>"));
        }
        super(fileReferenceSet, range, index, text);
    }

    @NotNull
    public String getFileNameToCreate() {
        String extension;
        LanguageFileType fileType;
        Language language;
        String result = super.getFileNameToCreate();
        if (!this.isLast()) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "getFileNameToCreate"));
            }
            return string;
        }
        if (!SassScssImportReference.endsWithExtensions(result, SCSS_EXT, new String[0]) && !SassScssImportReference.endsWithExtensions(result, SASS_EXT, new String[0]) && !SassScssImportReference.endsWithExtensions(result, CSS_EXT, new String[0]) && (language = CssPsiUtil.getStylesheetLanguage((PsiElement)this.getElement())) != null && (fileType = language.getAssociatedFileType()) != null && StringUtil.isNotEmpty((String)(extension = fileType.getDefaultExtension()))) {
            result = result + "." + extension;
        }
        if (this.partialSupported(result) && !result.startsWith("_")) {
            String string = "_" + result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "getFileNameToCreate"));
            }
            return string;
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "getFileNameToCreate"));
        }
        return string;
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (this.partialSupported(candidate)) {
            PsiFile psiFile = (PsiFile)candidate;
            LookupElementBuilder fileLookupItem = FileInfoManager.getFileLookupItem((PsiElement)psiFile, (String)this.createImportTextForFileName(psiFile.getName()), (Icon)psiFile.getIcon(0));
            return fileLookupItem.withTypeText(psiFile.getName(), true);
        }
        return super.createLookupItem(candidate);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/plugins/scss/references/SassScssImportReference", "handleElementRename"));
        }
        return super.handleElementRename(this.createImportTextForFileName(newElementName));
    }

    protected PsiElement rename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/scss/references/SassScssImportReference", "rename"));
        }
        return super.rename(this.createImportTextForFileName(newName));
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        Collection resultWithoutDirectories;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolve"));
        }
        String referenceText = this.getText();
        Collection result = Sets.newHashSet((Object[])super.innerResolve(caseSensitive, containingFile));
        if (this.isLast() && !referenceText.isEmpty()) {
            result.addAll(this.innerResolveWithNameVariants(caseSensitive, referenceText));
            if (!referenceText.startsWith("_")) {
                result.addAll(this.innerResolveWithNameVariants(caseSensitive, "_" + referenceText));
            }
        }
        if (this.isLast() && !(resultWithoutDirectories = Collections2.filter((Collection)result, (Predicate)new Predicate<ResolveResult>(){

            public boolean apply(@NotNull ResolveResult input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/plugins/scss/references/SassScssImportReference$1", "apply"));
                }
                return input.getElement() instanceof PsiFile;
            }
        })).isEmpty()) {
            result = resultWithoutDirectories;
        }
        ResolveResult[] resolveResultArray = (resultCount = result.size()) > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolve"));
        }
        return resolveResultArray;
    }

    protected Collection<ResolveResult> innerResolveWithNameVariants(boolean caseSensitive, @NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolveWithNameVariants"));
        }
        Collection<ResolveResult> result = this.innerResolve(caseSensitive, referenceText);
        if (!(SassScssImportReference.endsWithExtensions(referenceText, SCSS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(referenceText, SASS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(referenceText, CSS_EXT, new String[0]))) {
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, SASS_EXT, new String[0])));
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, SCSS_EXT, new String[0])));
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, CSS_EXT, new String[0])));
        }
        return result;
    }

    @NotNull
    protected Collection<ResolveResult> innerResolve(boolean caseSensitive, @NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolve"));
        }
        Collection contexts = this.getContexts();
        THashSet result = new THashSet();
        for (PsiFileSystemItem context : contexts) {
            if (context == null) continue;
            this.innerResolveInContext(referenceText, context, (Collection<ResolveResult>)result, caseSensitive);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolve"));
        }
        return tHashSet;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final @NotNull Collection<ResolveResult> result, boolean caseSensitive) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolveInContext"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/scss/references/SassScssImportReference", "innerResolveInContext"));
        }
        super.innerResolveInContext(text, context, result, caseSensitive);
        if (!this.isLast() && "**".equals(text)) {
            context.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssImportReference$2", "execute"));
                    }
                    if (element instanceof PsiDirectory) {
                        result.add(new PsiElementResolveResult((PsiElement)element));
                    }
                    return true;
                }
            });
        }
        if (this.isLast() && "*".equals(SassScssImportReference.withoutExtension(text))) {
            final String extension = FileUtilRt.getExtension((String)text);
            context.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssImportReference$3", "execute"));
                    }
                    if (FileUtilRt.extensionEquals((String)element.getName(), (String)extension)) {
                        result.add(new PsiElementResolveResult((PsiElement)element));
                    }
                    return true;
                }
            });
        }
    }

    @NotNull
    protected String createImportTextForFileName(@NotNull String path) {
        List strings;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/scss/references/SassScssImportReference", "createImportTextForFileName"));
        }
        if (this.partialSupported(path) && !(strings = FileUtil.splitPath((String)(path = this.dismissExtensionIfNeeded(path)))).isEmpty()) {
            String fileName = (String)strings.remove(strings.size() - 1);
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'_') && fileName.length() > 1) {
                fileName = fileName.substring(1);
            }
            strings.add(fileName);
            path = StringUtil.join((Collection)strings, (String)File.separator);
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "createImportTextForFileName"));
        }
        return string;
    }

    @NotNull
    protected String dismissExtensionIfNeeded(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/scss/references/SassScssImportReference", "dismissExtensionIfNeeded"));
        }
        String string = !SassScssImportReference.endsWithExtensions(path, CSS_EXT, SCSS_EXT) && !SassScssImportReference.endsWithExtensions(path, CSS_EXT, SASS_EXT) ? SassScssImportReference.withoutExtension(path) : path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "dismissExtensionIfNeeded"));
        }
        return string;
    }

    protected boolean partialSupported(PsiElement psiElement) {
        return psiElement instanceof SassScssStylesheetFile;
    }

    protected boolean partialSupported(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/scss/references/SassScssImportReference", "partialSupported"));
        }
        return SassScssImportReference.endsWithExtensions(path, SCSS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(path, SASS_EXT, new String[0]);
    }

    protected static boolean endsWithExtensions(@NotNull String text, String extension, String ... rest) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/scss/references/SassScssImportReference", "endsWithExtensions"));
        }
        return text.endsWith(SassScssImportReference.withExtensions(EMPTY_STRING, extension, rest));
    }

    @NotNull
    protected static String withoutExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/scss/references/SassScssImportReference", "withoutExtension"));
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            String string = fileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "withoutExtension"));
            }
            return string;
        }
        String string = fileName.substring(0, index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/references/SassScssImportReference", "withoutExtension"));
        }
        return string;
    }

    protected static String withExtensions(String text, String extension, String ... rest) {
        return EXTENSIONS_JOINER.join((Object)text, (Object)extension, (Object[])rest);
    }
}

