/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NashornDebuggerSupportWrapper {
    private static final Logger LOG = Logger.getInstance(NashornObject.class);
    private static final Key<NashornDebuggerSupportWrapper> DEBUGGER_SUPPORT = Key.create((String)"nashornDebuggerSupport");
    private final ClassType classType;
    private final Method getPropertiesMethod;
    private final Method getIndexedValuesMethod;
    private Field nameField;
    private Field typeField;
    private Field vmValueField;
    private Field stringValueField;
    private Field lengthField;
    private Field indexField;
    private final List<Field> fields;
    private final Method evaluateMethod;

    NashornDebuggerSupportWrapper(@NotNull ClassType classType, @NotNull List<Field> fields) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "<init>"));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "<init>"));
        }
        this.classType = classType;
        this.getPropertiesMethod = classType.concreteMethodByName("getProperties", "(Ljava/lang/Object;)[Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        this.getIndexedValuesMethod = classType.concreteMethodByName("getIndexedValues", "(Ljava/lang/Object;II)[Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        this.fields = fields;
        for (Field field : fields) {
            String name = field.name();
            if (name.equals("name")) {
                this.nameField = field;
                continue;
            }
            if (name.equals("type")) {
                this.typeField = field;
                continue;
            }
            if (name.equals("value")) {
                this.vmValueField = field;
                continue;
            }
            if (name.equals("stringValue")) {
                this.stringValueField = field;
                continue;
            }
            if (name.equals("length")) {
                this.lengthField = field;
                continue;
            }
            if (!name.equals("index")) continue;
            this.indexField = field;
        }
        this.evaluateMethod = classType.concreteMethodByName("evaluate", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        LOG.assertTrue(this.evaluateMethod != null);
        LOG.assertTrue(this.getPropertiesMethod != null);
        LOG.assertTrue(this.getIndexedValuesMethod != null);
    }

    private static Value mirrorOf(@NotNull URL value, @NotNull ThreadReference threadReference) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "mirrorOf"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "mirrorOf"));
        }
        String typeName = value.getClass().getCanonicalName();
        ClassType type = (ClassType)threadReference.virtualMachine().classesByName(typeName).get(0);
        ArrayList<StringReference> args = new ArrayList<StringReference>();
        args.add(threadReference.virtualMachine().mirrorOf(value.toString()));
        return type.newInstance(threadReference, type.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), args, 1);
    }

    private static ObjectReference mirrorOf(@NotNull URL[] value, @NotNull ThreadReference threadReference) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "mirrorOf"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "mirrorOf"));
        }
        int l = value.length;
        String typeName = value.getClass().getCanonicalName();
        ArrayType arrayType = (ArrayType)threadReference.virtualMachine().classesByName(typeName).get(0);
        ArrayReference reference = arrayType.newInstance(l);
        int length = value.length;
        for (int i = 0; i < length; ++i) {
            URL url = value[i];
            reference.setValue(i, NashornDebuggerSupportWrapper.mirrorOf(url, threadReference));
        }
        return reference;
    }

    private static ReferenceType getClass(@NotNull ThreadReference threadReference, @NotNull String name, @NotNull ClassLoaderReference classLoader) throws Exception {
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getClass"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getClass"));
        }
        ReferenceType refType = null;
        VirtualMachine virtualMachine = threadReference.virtualMachine();
        ClassType classClassType = (ClassType)virtualMachine.classesByName("java.lang.Class").get(0);
        Method forNameMethod = classClassType.concreteMethodByName("forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(virtualMachine.mirrorOf(name));
        args.add(virtualMachine.mirrorOf(true));
        args.add(classLoader);
        Value value = classClassType.invokeMethod(threadReference, forNameMethod, args, 1);
        if (value instanceof ClassObjectReference) {
            refType = ((ClassObjectReference)value).reflectedType();
        }
        return refType;
    }

    static NashornDebuggerSupportWrapper get(@NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager) throws Exception {
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "get"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "get"));
        }
        NashornDebuggerSupportWrapper wrapper = (NashornDebuggerSupportWrapper)DEBUGGER_SUPPORT.get((UserDataHolder)valueManager.getProcessLevelCache());
        if (wrapper == null) {
            ClassType urlClassLoaderClass = (ClassType)threadReference.virtualMachine().classesByName("java.net.URLClassLoader").get(0);
            File file = new File(PathManager.getPreInstalledPluginsPath(), FileUtil.toSystemDependentName((String)"JavaScriptDebugger/nashorn-debugger-support.jar"));
            LOG.assertTrue(file.exists());
            SmartList args = new SmartList();
            args.add(NashornDebuggerSupportWrapper.mirrorOf(new URL[]{file.toURI().toURL()}, threadReference));
            Method ctorMethod = urlClassLoaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;)V");
            ClassLoaderReference classLoader = (ClassLoaderReference)urlClassLoaderClass.newInstance(threadReference, ctorMethod, (List<? extends Value>)args, 1);
            wrapper = new NashornDebuggerSupportWrapper((ClassType)NashornDebuggerSupportWrapper.getClass(threadReference, "org.jetbrains.nashorn.NashornDebuggerSupport", classLoader), NashornDebuggerSupportWrapper.getClass(threadReference, "org.jetbrains.nashorn.NashornDebuggerSupport$VariableDescriptor", classLoader).fields());
            DEBUGGER_SUPPORT.set((UserDataHolder)valueManager.getProcessLevelCache(), (Object)wrapper);
        }
        return wrapper;
    }

    @NotNull
    public ArrayReference getProperties(@NotNull ObjectReference parent, @NotNull ThreadReference threadReference) throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getProperties"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getProperties"));
        }
        SmartList args = new SmartList();
        args.add(parent);
        ArrayReference arrayReference = (ArrayReference)this.classType.invokeMethod(threadReference, this.getPropertiesMethod, (List<? extends Value>)args, 0);
        if (arrayReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getProperties"));
        }
        return arrayReference;
    }

    @NotNull
    public ArrayReference getIndexedValues(@NotNull ObjectReference parent, @NotNull ThreadReference threadReference, int index, int length) throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getIndexedValues"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getIndexedValues"));
        }
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(parent);
        args.add(threadReference.virtualMachine().mirrorOf(index));
        args.add(threadReference.virtualMachine().mirrorOf(length));
        ArrayReference arrayReference = (ArrayReference)this.classType.invokeMethod(threadReference, this.getIndexedValuesMethod, args, 0);
        if (arrayReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getIndexedValues"));
        }
        return arrayReference;
    }

    @NotNull
    public String getName(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getName"));
        }
        String string = ((StringReference)fieldToValue.get(this.nameField)).value();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getName"));
        }
        return string;
    }

    public int getType(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getType"));
        }
        return ((IntegerValue)fieldToValue.get(this.typeField)).value();
    }

    @NotNull
    public ObjectReference getValue(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getValue"));
        }
        ObjectReference objectReference = (ObjectReference)fieldToValue.get(this.vmValueField);
        if (objectReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getValue"));
        }
        return objectReference;
    }

    public String getStringValue(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getStringValue"));
        }
        return ((StringReference)fieldToValue.get(this.stringValueField)).value();
    }

    public int getLength(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getLength"));
        }
        return ((IntegerValue)fieldToValue.get(this.lengthField)).value();
    }

    public int getIndex(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getIndex"));
        }
        return ((IntegerValue)fieldToValue.get(this.indexField)).value();
    }

    @NotNull
    public ObjectReference evaluate(@NotNull String expression, @Nullable ObjectReference scope, @Nullable ObjectReference self, @NotNull EvaluationContext context) throws Exception {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "evaluate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "evaluate"));
        }
        ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
        args.add(context.getSuspendContext().getThread().getThreadReference().virtualMachine().mirrorOf(expression));
        args.add(scope);
        args.add(self);
        ObjectReference objectReference = (ObjectReference)((DebugProcessImpl)context.getDebugProcess()).invokeMethod(context, this.classType, this.evaluateMethod, args, true);
        if (objectReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "evaluate"));
        }
        return objectReference;
    }

    @NotNull
    public Map<Field, Value> getValues(@NotNull ObjectReference objectDescriptor) {
        if (objectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDescriptor", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getValues"));
        }
        Map<Field, Value> map = objectDescriptor.getValues(this.fields);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper", "getValues"));
        }
        return map;
    }
}

