/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.javascript.debugger.nashorn.NashornArray;
import com.intellij.javascript.debugger.nashorn.NashornDebuggerSupportWrapper;
import com.intellij.javascript.debugger.nashorn.NashornFunction;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

class NashornObject
extends ObjectValueBase<JdiValueManager> {
    protected final ObjectReference objectReference;
    private final String valueString;
    protected final ThreadReference threadReference;
    private final VariablesHost<JdiValueManager> childrenManager;

    @NotNull
    protected VariablesHost<JdiValueManager> getChildrenManager() {
        VariablesHost<JdiValueManager> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornObject", "getChildrenManager"));
        }
        return variablesHost;
    }

    public NashornObject(@NotNull ValueType type, @NotNull ObjectReference objectReference, @Nullable String valueString, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/debugger/nashorn/NashornObject", "<init>"));
        }
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/javascript/debugger/nashorn/NashornObject", "<init>"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornObject", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/debugger/nashorn/NashornObject", "<init>"));
        }
        super(type);
        this.objectReference = objectReference;
        this.threadReference = threadReference;
        this.valueString = valueString;
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                final AsyncPromise promise = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new DebuggerContextCommandImpl(((JdiValueManager)this.valueManager).getDebugProcess().getDebuggerContext()){

                    public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/javascript/debugger/nashorn/NashornObject$1$1", "threadAction"));
                        }
                        this.updateCacheStamp();
                        try {
                            promise.setResult(NashornObject.loadVariables(new ArrayList<Variable>(), NashornObject.this.objectReference, NashornObject.this.threadReference, (JdiValueManager)valueManager, null));
                        }
                        catch (Exception e) {
                            promise.setError((Throwable)e);
                        }
                    }
                });
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornObject$1", "load"));
                }
                return asyncPromise;
            }
        };
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    @Nullable
    public String getValueString() {
        return this.valueString;
    }

    static List<Variable> loadVariables(@NotNull List<Variable> variables, @NotNull ObjectReference parent, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager, @Nullable Set<String> existingVariables) throws Exception {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/javascript/debugger/nashorn/NashornObject", "loadVariables"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/debugger/nashorn/NashornObject", "loadVariables"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornObject", "loadVariables"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/debugger/nashorn/NashornObject", "loadVariables"));
        }
        NashornDebuggerSupportWrapper debuggerSupport = NashornDebuggerSupportWrapper.get(threadReference, valueManager);
        ArrayReference properties = debuggerSupport.getProperties(parent, threadReference);
        if (properties.length() == 0) {
            return Collections.emptyList();
        }
        for (com.sun.jdi.Value valueDescription : properties.getValues()) {
            Map<Field, com.sun.jdi.Value> fieldToValue = debuggerSupport.getValues((ObjectReference)valueDescription);
            String name = debuggerSupport.getName(fieldToValue);
            if (existingVariables != null && existingVariables.contains(name)) continue;
            variables.add((Variable)new VariableImpl(name, NashornObject.createValue(threadReference, valueManager, debuggerSupport, fieldToValue), null));
        }
        return variables;
    }

    static Value createValue(@NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager, @NotNull NashornDebuggerSupportWrapper debuggerSupport, @NotNull Map<Field, com.sun.jdi.Value> fieldToValue) {
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornObject", "createValue"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/debugger/nashorn/NashornObject", "createValue"));
        }
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/javascript/debugger/nashorn/NashornObject", "createValue"));
        }
        if (fieldToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToValue", "com/intellij/javascript/debugger/nashorn/NashornObject", "createValue"));
        }
        int type = debuggerSupport.getType(fieldToValue);
        if (type == -1) {
            return valueManager.createValue(debuggerSupport.getValue(fieldToValue));
        }
        ValueType valueType = ValueType.fromIndex((int)type);
        switch (valueType) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                return new PrimitiveValue(valueType, debuggerSupport.getStringValue(fieldToValue));
            }
            case NULL: {
                return PrimitiveValue.NULL;
            }
            case UNDEFINED: {
                return PrimitiveValue.UNDEFINED;
            }
            case OBJECT: 
            case FUNCTION: 
            case ARRAY: {
                ObjectReference reference = debuggerSupport.getValue(fieldToValue);
                Object value = valueManager.getCachedValue(reference);
                if (value == null) {
                    value = valueType == ValueType.OBJECT ? new NashornObject(valueType, reference, null, threadReference, valueManager) : (valueType == ValueType.ARRAY ? new NashornArray(debuggerSupport.getLength(fieldToValue), reference, null, threadReference, valueManager) : new NashornFunction(reference, debuggerSupport.getStringValue(fieldToValue), threadReference, valueManager));
                    value = valueManager.getOrCacheValue(reference, (Value)value);
                }
                return value;
            }
        }
        throw new IllegalArgumentException(valueType.name());
    }
}

