/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.references;

import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class BvPrivateMembersScopeEnlarger
extends UseScopeEnlarger {
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/beanValidation/references/BvPrivateMembersScopeEnlarger", "getAdditionalUseScope"));
        }
        if (element instanceof PsiField || element instanceof PsiMethod) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null || !BVUtils.isBeanValidationDefined(module)) {
                return null;
            }
            XmlFile[] xmlFiles = BVUtils.getConstraintFiles(module);
            if (xmlFiles.length == 0) {
                return null;
            }
            HashSet files = new HashSet(xmlFiles.length);
            for (XmlFile xmlFile : xmlFiles) {
                ContainerUtil.addIfNotNull((Object)xmlFile.getVirtualFile(), files);
            }
            if (files.isEmpty()) {
                return null;
            }
            return GlobalSearchScope.filesScope((Project)element.getProject(), files);
        }
        return null;
    }
}

